/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx;

import android.content.Context;
import com.qualcomm.hardware.R;
import com.qualcomm.hardware.lynx.LynxController;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxNackException;
import com.qualcomm.hardware.lynx.LynxUsbUtil;
import com.qualcomm.hardware.lynx.commands.LynxRespondable;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetADCCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetADCResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetBulkInputDataCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetBulkInputDataResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorChannelCurrentAlertLevelCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorChannelCurrentAlertLevelResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorChannelEnableCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorChannelEnableResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorChannelModeCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorChannelModeResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorConstantPowerCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorConstantPowerResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorEncoderPositionCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorEncoderPositionResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorPIDControlLoopCoefficientsCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorPIDControlLoopCoefficientsResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorPIDFControlLoopCoefficientsCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorPIDFControlLoopCoefficientsResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorTargetPositionCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorTargetPositionResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorTargetVelocityCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorTargetVelocityResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxIsMotorAtTargetCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxIsMotorAtTargetResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxResetMotorEncoderCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxSetMotorChannelCurrentAlertLevelCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxSetMotorChannelEnableCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxSetMotorChannelModeCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxSetMotorConstantPowerCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxSetMotorPIDControlLoopCoefficientsCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxSetMotorPIDFControlLoopCoefficientsCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxSetMotorTargetPositionCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxSetMotorTargetVelocityCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxNack;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.exception.TargetPositionNotSetException;
import com.qualcomm.robotcore.hardware.DcMotor;
import com.qualcomm.robotcore.hardware.DcMotorController;
import com.qualcomm.robotcore.hardware.DcMotorControllerEx;
import com.qualcomm.robotcore.hardware.MotorControlAlgorithm;
import com.qualcomm.robotcore.hardware.PIDCoefficients;
import com.qualcomm.robotcore.hardware.PIDFCoefficients;
import com.qualcomm.robotcore.hardware.configuration.ExpansionHubMotorControllerParamsState;
import com.qualcomm.robotcore.hardware.configuration.typecontainers.MotorConfigurationType;
import com.qualcomm.robotcore.util.LastKnown;
import com.qualcomm.robotcore.util.Range;
import com.qualcomm.robotcore.util.RobotLog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.CurrentUnit;
import org.firstinspires.ftc.robotcore.external.navigation.UnnormalizedAngleUnit;
import org.firstinspires.ftc.robotcore.internal.system.Misc;

public class LynxDcMotorController
extends LynxController
implements DcMotorController,
DcMotorControllerEx {
    public static final int apiMotorFirst = 0;
    public static final int apiMotorLast = 3;
    public static final double apiPowerFirst = -1.0;
    public static final double apiPowerLast = 1.0;
    public static final String TAG = "LynxMotor";
    protected static boolean DEBUG = false;
    protected final MotorProperties[] motors = new MotorProperties[4];

    @Override
    protected String getTag() {
        return TAG;
    }

    public LynxDcMotorController(Context context, LynxModule module) throws RobotCoreException, InterruptedException {
        super(context, module);
        for (int motor = 0; motor < this.motors.length; ++motor) {
            this.motors[motor] = new MotorProperties();
        }
        this.finishConstruction();
    }

    @Override
    public void initializeHardware() throws RobotCoreException, InterruptedException {
        this.runWithoutEncoders();
        this.floatHardware();
        this.forgetLastKnown();
        for (int motor = 0; motor <= 3; ++motor) {
            this.updateMotorParams(motor);
        }
        this.reportPIDFControlLoopCoefficients();
    }

    @Override
    protected void doHook() {
        this.forgetLastKnown();
    }

    @Override
    protected void doUnhook() {
        this.forgetLastKnown();
    }

    @Override
    public void forgetLastKnown() {
        for (MotorProperties motor : this.motors) {
            motor.lastKnownMode.invalidate();
            motor.lastKnownPower.invalidate();
            motor.lastKnownTargetPosition.invalidate();
            motor.lastKnownZeroPowerBehavior.invalidate();
            motor.lastKnownEnable.invalidate();
        }
    }

    @Override
    public String getDeviceName() {
        return this.context.getString(R.string.lynxDcMotorControllerDisplayName);
    }

    public synchronized void setMotorEnable(int motor) {
        this.validateMotor(motor);
        this.internalSetMotorEnable(motor += 0, true);
    }

    public synchronized void setMotorDisable(int motor) {
        this.validateMotor(motor);
        this.internalSetMotorEnable(motor += 0, false);
    }

    void internalSetMotorEnable(int motorZ, boolean enable) {
        if (this.motors[motorZ].lastKnownEnable.updateValue((Object)enable)) {
            LynxSetMotorChannelEnableCommand command = new LynxSetMotorChannelEnableCommand(this.getModule(), motorZ, enable);
            try {
                if (DEBUG) {
                    RobotLog.vv((String)TAG, (String)"setMotorEnable mod=%d motor=%d enable=%s", (Object[])new Object[]{this.getModuleAddress(), motorZ, Boolean.valueOf(enable).toString()});
                }
                command.send();
            }
            catch (LynxNackException e) {
                LynxNack.ReasonCode reason = e.getNack().getNackReasonCode();
                if (reason == LynxNack.StandardReasonCode.MOTOR_NOT_CONFIG_BEFORE_ENABLED) {
                    throw new TargetPositionNotSetException();
                }
                this.handleException(e);
            }
            catch (InterruptedException | RuntimeException e) {
                this.handleException(e);
            }
        }
    }

    public synchronized boolean isMotorEnabled(int motor) {
        this.validateMotor(motor);
        Boolean result = (Boolean)this.motors[motor += 0].lastKnownEnable.getValue();
        if (result != null) {
            return result;
        }
        LynxGetMotorChannelEnableCommand command = new LynxGetMotorChannelEnableCommand(this.getModule(), motor);
        try {
            LynxGetMotorChannelEnableResponse response = (LynxGetMotorChannelEnableResponse)command.sendReceive();
            result = response.isEnabled();
            this.motors[motor].lastKnownEnable.setValue((Object)result);
            return result;
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(true);
        }
    }

    public synchronized void resetDeviceConfigurationForOpMode(int motor) {
        this.validateMotor(motor);
        this.motors[motor += 0].desiredPIDParams.remove(DcMotor.RunMode.RUN_TO_POSITION);
        this.motors[motor].desiredPIDParams.remove(DcMotor.RunMode.RUN_USING_ENCODER);
        if (this.motors[motor].originalPIDParams.containsKey(DcMotor.RunMode.RUN_TO_POSITION)) {
            this.motors[motor].desiredPIDParams.put(DcMotor.RunMode.RUN_TO_POSITION, this.motors[motor].originalPIDParams.get(DcMotor.RunMode.RUN_TO_POSITION));
        }
        if (this.motors[motor].originalPIDParams.containsKey(DcMotor.RunMode.RUN_USING_ENCODER)) {
            this.motors[motor].desiredPIDParams.put(DcMotor.RunMode.RUN_USING_ENCODER, this.motors[motor].originalPIDParams.get(DcMotor.RunMode.RUN_USING_ENCODER));
        }
        if (this.motors[motor].internalMotorType != null) {
            this.setMotorType(motor + 0, this.motors[motor].internalMotorType);
        } else {
            this.updateMotorParams(motor);
        }
    }

    public synchronized MotorConfigurationType getMotorType(int motor) {
        this.validateMotor(motor);
        return this.motors[motor += 0].motorType;
    }

    public synchronized void setMotorType(int motor, MotorConfigurationType motorType) {
        this.validateMotor(motor);
        this.motors[motor += 0].motorType = motorType;
        if (this.motors[motor].internalMotorType == null) {
            this.motors[motor].internalMotorType = motorType;
        }
        if (motorType.hasExpansionHubVelocityParams()) {
            this.rememberPIDParams(motor, motorType.getHubVelocityParams());
        }
        if (motorType.hasExpansionHubPositionParams()) {
            this.rememberPIDParams(motor, motorType.getHubPositionParams());
        }
        this.updateMotorParams(motor);
    }

    protected void rememberPIDParams(int motorZ, ExpansionHubMotorControllerParamsState params) {
        this.motors[motorZ].desiredPIDParams.put(params.mode, params);
    }

    protected void updateMotorParams(int motorZ) {
        for (ExpansionHubMotorControllerParamsState params : this.motors[motorZ].desiredPIDParams.values()) {
            if (params.isDefault()) continue;
            this.internalSetPIDFCoefficients(motorZ, params.mode, params.getPidfCoefficients());
        }
    }

    protected int getDefaultMaxMotorSpeed(int motorZ) {
        return this.motors[motorZ].motorType.getAchieveableMaxTicksPerSecondRounded();
    }

    public synchronized void setMotorMode(int motor, DcMotor.RunMode mode) {
        this.validateMotor(motor);
        if (!this.motors[motor += 0].lastKnownMode.isValue((Object)mode)) {
            LynxDekaInterfaceCommand command;
            Double prevPower = (Double)this.motors[motor].lastKnownPower.getNonTimedValue();
            if (prevPower == null) {
                prevPower = this.internalGetMotorPower(motor);
            }
            DcMotor.ZeroPowerBehavior zeroPowerBehavior = DcMotor.ZeroPowerBehavior.UNKNOWN;
            if (mode == DcMotor.RunMode.STOP_AND_RESET_ENCODER) {
                this.internalSetMotorPower(motor, 0.0);
                command = new LynxResetMotorEncoderCommand(this.getModule(), motor);
            } else {
                zeroPowerBehavior = this.internalGetZeroPowerBehavior(motor);
                command = new LynxSetMotorChannelModeCommand(this.getModule(), motor, mode, zeroPowerBehavior);
            }
            try {
                if (DEBUG) {
                    RobotLog.vv((String)TAG, (String)"setMotorChannelMode: mod=%d motor=%d mode=%s power=%f zero=%s", (Object[])new Object[]{this.getModuleAddress(), motor, mode.toString(), prevPower, zeroPowerBehavior.toString()});
                }
                command.send();
                this.motors[motor].lastKnownMode.setValue((Object)mode);
                this.internalSetMotorPower(motor, prevPower, true);
            }
            catch (LynxNackException | InterruptedException | RuntimeException e) {
                this.handleException(e);
            }
        }
    }

    public synchronized DcMotor.RunMode getMotorMode(int motor) {
        this.validateMotor(motor);
        return this.internalGetPublicMotorMode(motor += 0);
    }

    protected DcMotor.RunMode internalGetPublicMotorMode(int motorZ) {
        DcMotor.RunMode result = (DcMotor.RunMode)this.motors[motorZ].lastKnownMode.getValue();
        if (result != null) {
            return result;
        }
        if (this.motors[motorZ].lastKnownMode.getNonTimedValue() == DcMotor.RunMode.STOP_AND_RESET_ENCODER) {
            return DcMotor.RunMode.STOP_AND_RESET_ENCODER;
        }
        LynxGetMotorChannelModeCommand command = new LynxGetMotorChannelModeCommand(this.getModule(), motorZ);
        try {
            LynxGetMotorChannelModeResponse response = (LynxGetMotorChannelModeResponse)command.sendReceive();
            result = response.getMode();
            this.motors[motorZ].lastKnownMode.setValue((Object)result);
            return result;
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(DcMotor.RunMode.RUN_WITHOUT_ENCODER);
        }
    }

    protected DcMotor.RunMode internalGetMotorChannelMode(int motorZ) {
        DcMotor.RunMode result = (DcMotor.RunMode)this.motors[motorZ].lastKnownMode.getValue();
        if (result != null && result != DcMotor.RunMode.STOP_AND_RESET_ENCODER) {
            return result;
        }
        LynxGetMotorChannelModeCommand command = new LynxGetMotorChannelModeCommand(this.getModule(), motorZ);
        try {
            LynxGetMotorChannelModeResponse response = (LynxGetMotorChannelModeResponse)command.sendReceive();
            result = response.getMode();
            return result;
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(DcMotor.RunMode.RUN_WITHOUT_ENCODER);
        }
    }

    public synchronized void setMotorPower(int motor, double apiMotorPower) {
        this.validateMotor(motor);
        this.internalSetMotorPower(motor += 0, apiMotorPower);
    }

    public synchronized double getMotorPower(int motor) {
        this.validateMotor(motor);
        return this.internalGetMotorPower(motor += 0);
    }

    DcMotor.ZeroPowerBehavior internalGetZeroPowerBehavior(int motorZ) {
        DcMotor.ZeroPowerBehavior result = (DcMotor.ZeroPowerBehavior)this.motors[motorZ].lastKnownZeroPowerBehavior.getValue();
        if (result != null) {
            return result;
        }
        LynxGetMotorChannelModeCommand command = new LynxGetMotorChannelModeCommand(this.getModule(), motorZ);
        try {
            LynxGetMotorChannelModeResponse response = (LynxGetMotorChannelModeResponse)command.sendReceive();
            result = response.getZeroPowerBehavior();
            this.motors[motorZ].lastKnownZeroPowerBehavior.setValue((Object)result);
            return result;
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(DcMotor.ZeroPowerBehavior.BRAKE);
        }
    }

    void internalSetZeroPowerBehavior(int motorZ, DcMotor.ZeroPowerBehavior behavior) {
        if (this.motors[motorZ].lastKnownZeroPowerBehavior.updateValue((Object)behavior)) {
            DcMotor.RunMode runMode = this.internalGetMotorChannelMode(motorZ);
            LynxSetMotorChannelModeCommand command = new LynxSetMotorChannelModeCommand(this.getModule(), motorZ, runMode, behavior);
            try {
                if (DEBUG) {
                    RobotLog.vv((String)TAG, (String)"setZeroBehavior mod=%d motor=%d zero=%s", (Object[])new Object[]{this.getModuleAddress(), motorZ, behavior.toString()});
                }
                command.send();
            }
            catch (LynxNackException | InterruptedException | RuntimeException e) {
                this.handleException(e);
            }
        }
    }

    void internalSetMotorPower(int motorZ, double apiPower) {
        this.internalSetMotorPower(motorZ, apiPower, false);
    }

    void internalSetMotorPower(int motorZ, double apiPower, boolean forceUpdate) {
        double power = Range.clip((double)apiPower, (double)-1.0, (double)1.0);
        int iPower = 0;
        if (this.motors[motorZ].lastKnownPower.updateValue((Object)power) || forceUpdate) {
            DcMotor.RunMode mode = this.internalGetPublicMotorMode(motorZ);
            LynxRespondable command = null;
            switch (mode) {
                case RUN_TO_POSITION: 
                case RUN_USING_ENCODER: {
                    power = Math.signum(power) * Range.scale((double)Math.abs(power), (double)0.0, (double)1.0, (double)0.0, (double)this.getDefaultMaxMotorSpeed(motorZ));
                    iPower = (int)power;
                    command = new LynxSetMotorTargetVelocityCommand(this.getModule(), motorZ, iPower);
                    break;
                }
                case RUN_WITHOUT_ENCODER: {
                    power = Range.scale((double)power, (double)-1.0, (double)1.0, (double)-32767.0, (double)32767.0);
                    iPower = (int)power;
                    command = new LynxSetMotorConstantPowerCommand(this.getModule(), motorZ, iPower);
                    break;
                }
                case STOP_AND_RESET_ENCODER: {
                    command = null;
                }
            }
            try {
                if (command != null) {
                    if (DEBUG) {
                        RobotLog.vv((String)TAG, (String)"setMotorPower: mod=%d motor=%d iPower=%d", (Object[])new Object[]{this.getModuleAddress(), motorZ, iPower});
                    }
                    command.send();
                    this.internalSetMotorEnable(motorZ, true);
                }
            }
            catch (LynxNackException | InterruptedException | RuntimeException e) {
                this.handleException(e);
            }
        }
    }

    double internalGetMotorPower(int motorZ) {
        Double result = (Double)this.motors[motorZ].lastKnownPower.getValue();
        if (result != null) {
            if (DEBUG) {
                RobotLog.vv((String)TAG, (String)"getMotorPower(cached): mod=%d motor=%d power=%f", (Object[])new Object[]{this.getModuleAddress(), motorZ, result});
            }
            return result;
        }
        DcMotor.RunMode mode = this.internalGetPublicMotorMode(motorZ);
        try {
            switch (mode) {
                case RUN_TO_POSITION: 
                case RUN_USING_ENCODER: {
                    LynxGetMotorTargetVelocityCommand command = new LynxGetMotorTargetVelocityCommand(this.getModule(), motorZ);
                    LynxGetMotorTargetVelocityResponse response = (LynxGetMotorTargetVelocityResponse)command.sendReceive();
                    int iVelocity = response.getVelocity();
                    result = (double)Math.signum(iVelocity) * Range.scale((double)Math.abs(iVelocity), (double)0.0, (double)this.getDefaultMaxMotorSpeed(motorZ), (double)0.0, (double)1.0);
                    if (!DEBUG) break;
                    RobotLog.vv((String)TAG, (String)"getMotorPower: mod=%d motor=%d velocity=%d power=%f", (Object[])new Object[]{this.getModuleAddress(), motorZ, iVelocity, result});
                    break;
                }
                default: {
                    LynxGetMotorConstantPowerCommand command = new LynxGetMotorConstantPowerCommand(this.getModule(), motorZ);
                    LynxGetMotorConstantPowerResponse response = (LynxGetMotorConstantPowerResponse)command.sendReceive();
                    int iPower = response.getPower();
                    result = Range.scale((double)iPower, (double)-32767.0, (double)32767.0, (double)-1.0, (double)1.0);
                    if (!DEBUG) break;
                    RobotLog.vv((String)TAG, (String)"getMotorPower: mod=%d motor=%d iPower=%d power=%f", (Object[])new Object[]{this.getModuleAddress(), motorZ, iPower, result});
                }
            }
            result = Range.clip((double)result, (double)-1.0, (double)1.0);
            this.motors[motorZ].lastKnownPower.setValue((Object)result);
            return result;
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(0).intValue();
        }
    }

    public synchronized boolean isBusy(int motor) {
        LynxModule module;
        this.validateMotor(motor);
        LynxIsMotorAtTargetCommand command = new LynxIsMotorAtTargetCommand(this.getModule(), motor += 0);
        if (this.getModule() instanceof LynxModule && (module = (LynxModule)this.getModule()).getBulkCachingMode() != LynxModule.BulkCachingMode.OFF) {
            LynxModule.BulkData bulkData = module.recordBulkCachingCommandIntent(command);
            return bulkData.isMotorBusy(motor);
        }
        if (this.internalGetMotorChannelMode(motor) != DcMotor.RunMode.RUN_TO_POSITION) {
            return false;
        }
        try {
            LynxIsMotorAtTargetResponse response = (LynxIsMotorAtTargetResponse)command.sendReceive();
            return !response.isAtTarget();
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(false);
        }
    }

    public synchronized void setMotorZeroPowerBehavior(int motor, DcMotor.ZeroPowerBehavior zeroPowerBehavior) {
        this.validateMotor(motor);
        motor += 0;
        if (zeroPowerBehavior == DcMotor.ZeroPowerBehavior.UNKNOWN) {
            throw new IllegalArgumentException("zeroPowerBehavior may not be UNKNOWN");
        }
        this.internalSetZeroPowerBehavior(motor, zeroPowerBehavior);
    }

    public synchronized DcMotor.ZeroPowerBehavior getMotorZeroPowerBehavior(int motor) {
        this.validateMotor(motor);
        return this.internalGetZeroPowerBehavior(motor += 0);
    }

    protected synchronized void setMotorPowerFloat(int motor) {
        this.validateMotor(motor);
        this.internalSetZeroPowerBehavior(motor += 0, DcMotor.ZeroPowerBehavior.FLOAT);
        this.internalSetMotorPower(motor, 0.0);
    }

    public synchronized boolean getMotorPowerFloat(int motor) {
        this.validateMotor(motor);
        return this.internalGetZeroPowerBehavior(motor += 0) == DcMotor.ZeroPowerBehavior.FLOAT && this.internalGetMotorPower(motor) == 0.0;
    }

    public synchronized void setMotorTargetPosition(int motor, int position) {
        this.setMotorTargetPosition(motor, position, 5);
    }

    public synchronized void setMotorTargetPosition(int motor, int position, int tolerance) {
        this.validateMotor(motor);
        LynxSetMotorTargetPositionCommand command = new LynxSetMotorTargetPositionCommand(this.getModule(), motor += 0, position, tolerance);
        try {
            command.send();
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
        }
    }

    public synchronized int getMotorTargetPosition(int motor) {
        this.validateMotor(motor);
        LynxGetMotorTargetPositionCommand command = new LynxGetMotorTargetPositionCommand(this.getModule(), motor += 0);
        try {
            LynxGetMotorTargetPositionResponse response = (LynxGetMotorTargetPositionResponse)command.sendReceive();
            return response.getTarget();
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(0);
        }
    }

    public synchronized int getMotorCurrentPosition(int motor) {
        LynxModule module;
        this.validateMotor(motor);
        LynxGetMotorEncoderPositionCommand command = new LynxGetMotorEncoderPositionCommand(this.getModule(), motor += 0);
        if (this.getModule() instanceof LynxModule && (module = (LynxModule)this.getModule()).getBulkCachingMode() != LynxModule.BulkCachingMode.OFF) {
            LynxModule.BulkData bulkData = module.recordBulkCachingCommandIntent(command);
            return bulkData.getMotorCurrentPosition(motor);
        }
        try {
            LynxGetMotorEncoderPositionResponse response = (LynxGetMotorEncoderPositionResponse)command.sendReceive();
            return response.getPosition();
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(0);
        }
    }

    public synchronized void setMotorVelocity(int motor, double ticksPerSecond) {
        switch (this.getMotorMode(motor)) {
            case RUN_TO_POSITION: 
            case RUN_USING_ENCODER: {
                break;
            }
            default: {
                this.setMotorMode(motor, DcMotor.RunMode.RUN_USING_ENCODER);
            }
        }
        this.validateMotor(motor);
        motor += 0;
        int iTicksPerSecond = Range.clip((int)((int)Math.round(ticksPerSecond)), (int)-32767, (int)Short.MAX_VALUE);
        try {
            LynxSetMotorTargetVelocityCommand command = new LynxSetMotorTargetVelocityCommand(this.getModule(), motor, iTicksPerSecond);
            if (DEBUG) {
                RobotLog.vv((String)TAG, (String)"setMotorVelocity: mod=%d motor=%d iPower=%d", (Object[])new Object[]{this.getModuleAddress(), motor, iTicksPerSecond});
            }
            command.send();
            this.internalSetMotorEnable(motor, true);
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
        }
    }

    public synchronized void setMotorVelocity(int motor, double angularRate, AngleUnit unit) {
        this.validateMotor(motor);
        double degreesPerSecond = UnnormalizedAngleUnit.DEGREES.fromUnit(unit.getUnnormalized(), angularRate);
        double revolutionsPerSecond = degreesPerSecond / 360.0;
        double ticksPerSecond = this.motors[motor += 0].motorType.getTicksPerRev() * revolutionsPerSecond;
        this.setMotorVelocity(motor + 0, ticksPerSecond);
    }

    public synchronized double getMotorVelocity(int motor) {
        this.validateMotor(motor);
        return this.internalGetMotorTicksPerSecond(motor += 0);
    }

    public synchronized double getMotorVelocity(int motor, AngleUnit unit) {
        this.validateMotor(motor);
        int ticksPerSecond = this.internalGetMotorTicksPerSecond(motor += 0);
        double revsPerSecond = (double)ticksPerSecond / this.motors[motor].motorType.getTicksPerRev();
        return unit.getUnnormalized().fromDegrees(revsPerSecond * 360.0);
    }

    int internalGetMotorTicksPerSecond(int motorZ) {
        LynxModule module;
        LynxGetBulkInputDataCommand command = new LynxGetBulkInputDataCommand(this.getModule());
        if (this.getModule() instanceof LynxModule && (module = (LynxModule)this.getModule()).getBulkCachingMode() != LynxModule.BulkCachingMode.OFF) {
            LynxModule.BulkData bulkData = module.recordBulkCachingCommandIntent(command, "motorVelocity" + motorZ);
            return bulkData.getMotorVelocity(motorZ);
        }
        try {
            LynxGetBulkInputDataResponse response = (LynxGetBulkInputDataResponse)command.sendReceive();
            return response.getVelocity(motorZ);
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(0);
        }
    }

    public void setPIDCoefficients(int motor, DcMotor.RunMode mode, PIDCoefficients pidCoefficients) {
        this.setPIDFCoefficients(motor, mode, new PIDFCoefficients(pidCoefficients));
    }

    public synchronized void setPIDFCoefficients(int motor, DcMotor.RunMode mode, PIDFCoefficients pidfCoefficients) {
        this.validatePIDMode(motor, mode);
        this.validateMotor(motor);
        mode = mode.migrate();
        this.rememberPIDParams(motor += 0, new ExpansionHubMotorControllerParamsState(mode, pidfCoefficients));
        if (!this.internalSetPIDFCoefficients(motor, mode, pidfCoefficients)) {
            throw new UnsupportedOperationException(Misc.formatForUser((String)"setting of pidf coefficents not supported: motor=%d mode=%s pidf=%s", (Object[])new Object[]{motor + 0, mode, pidfCoefficients}));
        }
    }

    protected boolean internalSetPIDFCoefficients(int motorZ, DcMotor.RunMode mode, PIDFCoefficients pidfCoefficients) {
        boolean supported = true;
        if (!this.motors[motorZ].originalPIDParams.containsKey(mode)) {
            PIDFCoefficients originalCoefficients = this.getPIDFCoefficients(motorZ + 0, mode);
            this.motors[motorZ].originalPIDParams.put(mode, new ExpansionHubMotorControllerParamsState(mode, originalCoefficients));
        }
        int p = LynxSetMotorPIDControlLoopCoefficientsCommand.internalCoefficientFromExternal(pidfCoefficients.p);
        int i = LynxSetMotorPIDControlLoopCoefficientsCommand.internalCoefficientFromExternal(pidfCoefficients.i);
        int d = LynxSetMotorPIDControlLoopCoefficientsCommand.internalCoefficientFromExternal(pidfCoefficients.d);
        int f = LynxSetMotorPIDControlLoopCoefficientsCommand.internalCoefficientFromExternal(pidfCoefficients.f);
        if (mode == DcMotor.RunMode.RUN_TO_POSITION && pidfCoefficients.algorithm != MotorControlAlgorithm.LegacyPID && (pidfCoefficients.i != 0.0 || pidfCoefficients.d != 0.0 || pidfCoefficients.f != 0.0)) {
            supported = false;
            RobotLog.ww((String)TAG, (String)"using unreasonable coefficients for RUN_TO_POSITION: setPIDFCoefficients(%d, %s, %s)", (Object[])new Object[]{motorZ + 0, mode, pidfCoefficients});
        }
        if (supported) {
            if (this.getModule().isCommandSupported(LynxSetMotorPIDFControlLoopCoefficientsCommand.class)) {
                LynxSetMotorPIDFControlLoopCoefficientsCommand.InternalMotorControlAlgorithm algorithm = LynxSetMotorPIDFControlLoopCoefficientsCommand.InternalMotorControlAlgorithm.fromExternal(pidfCoefficients.algorithm);
                LynxSetMotorPIDFControlLoopCoefficientsCommand command = new LynxSetMotorPIDFControlLoopCoefficientsCommand(this.getModule(), motorZ, mode, p, i, d, f, algorithm);
                try {
                    command.send();
                }
                catch (LynxNackException | InterruptedException | RuntimeException e) {
                    supported = this.handleException(e);
                }
            } else if (f == 0 && pidfCoefficients.algorithm == MotorControlAlgorithm.LegacyPID) {
                LynxSetMotorPIDControlLoopCoefficientsCommand command = new LynxSetMotorPIDControlLoopCoefficientsCommand(this.getModule(), motorZ, mode, p, i, d);
                try {
                    command.send();
                }
                catch (LynxNackException | InterruptedException | RuntimeException e) {
                    supported = this.handleException(e);
                }
            } else {
                supported = false;
                RobotLog.ww((String)TAG, (String)"not supported: setPIDFCoefficients(%d, %s, %s)", (Object[])new Object[]{motorZ + 0, mode, pidfCoefficients});
            }
        }
        return supported;
    }

    public synchronized PIDCoefficients getPIDCoefficients(int motor, DcMotor.RunMode mode) {
        this.validateMotor(motor);
        LynxGetMotorPIDControlLoopCoefficientsCommand command = new LynxGetMotorPIDControlLoopCoefficientsCommand(this.getModule(), motor += 0, mode);
        try {
            LynxGetMotorPIDControlLoopCoefficientsResponse response = (LynxGetMotorPIDControlLoopCoefficientsResponse)command.sendReceive();
            return new PIDCoefficients(LynxSetMotorPIDControlLoopCoefficientsCommand.externalCoefficientFromInternal(response.getP()), LynxSetMotorPIDControlLoopCoefficientsCommand.externalCoefficientFromInternal(response.getI()), LynxSetMotorPIDControlLoopCoefficientsCommand.externalCoefficientFromInternal(response.getD()));
        }
        catch (LynxNackException e) {
            if (e.getNack().getNackReasonCode() == LynxNack.StandardReasonCode.PARAM2) {
                PIDFCoefficients pidfCoefficients = this.getPIDFCoefficients(motor + 0, mode);
                return new PIDCoefficients(pidfCoefficients.p, pidfCoefficients.i, pidfCoefficients.d);
            }
            this.handleException(e);
        }
        catch (InterruptedException | RuntimeException e) {
            this.handleException(e);
        }
        return LynxUsbUtil.makePlaceholderValue(new PIDCoefficients());
    }

    public synchronized PIDFCoefficients getPIDFCoefficients(int motor, DcMotor.RunMode mode) {
        if (this.getModule().isCommandSupported(LynxGetMotorPIDFControlLoopCoefficientsCommand.class)) {
            this.validateMotor(motor);
            LynxGetMotorPIDFControlLoopCoefficientsCommand command = new LynxGetMotorPIDFControlLoopCoefficientsCommand(this.getModule(), motor += 0, mode);
            try {
                LynxGetMotorPIDFControlLoopCoefficientsResponse response = (LynxGetMotorPIDFControlLoopCoefficientsResponse)command.sendReceive();
                return new PIDFCoefficients(LynxSetMotorPIDControlLoopCoefficientsCommand.externalCoefficientFromInternal(response.getP()), LynxSetMotorPIDControlLoopCoefficientsCommand.externalCoefficientFromInternal(response.getI()), LynxSetMotorPIDControlLoopCoefficientsCommand.externalCoefficientFromInternal(response.getD()), LynxSetMotorPIDControlLoopCoefficientsCommand.externalCoefficientFromInternal(response.getF()), response.getInternalMotorControlAlgorithm().toExternal());
            }
            catch (LynxNackException | InterruptedException | RuntimeException e) {
                this.handleException(e);
                return LynxUsbUtil.makePlaceholderValue(new PIDFCoefficients());
            }
        }
        return new PIDFCoefficients(this.getPIDCoefficients(motor, mode));
    }

    public double getMotorCurrent(int motor, CurrentUnit unit) {
        LynxGetADCCommand command = new LynxGetADCCommand(this.getModule(), LynxGetADCCommand.Channel.motorCurrent(motor), LynxGetADCCommand.Mode.ENGINEERING);
        try {
            LynxGetADCResponse response = (LynxGetADCResponse)command.sendReceive();
            return unit.convert((double)response.getValue(), CurrentUnit.MILLIAMPS);
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(0.0);
        }
    }

    public double getMotorCurrentAlert(int motor, CurrentUnit unit) {
        Double cachedCurrent = (Double)this.motors[motor].lastKnownCurrentAlert.getValue();
        if (cachedCurrent != null) {
            return unit.convert(cachedCurrent.doubleValue(), CurrentUnit.MILLIAMPS);
        }
        LynxGetMotorChannelCurrentAlertLevelCommand command = new LynxGetMotorChannelCurrentAlertLevelCommand(this.getModule(), motor);
        try {
            LynxGetMotorChannelCurrentAlertLevelResponse response = (LynxGetMotorChannelCurrentAlertLevelResponse)command.sendReceive();
            double limit = response.getCurrentLimit();
            this.motors[motor].lastKnownCurrentAlert.setValue((Object)limit);
            return unit.convert(limit, CurrentUnit.MILLIAMPS);
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(0.0);
        }
    }

    public void setMotorCurrentAlert(int motor, double current, CurrentUnit unit) {
        LynxSetMotorChannelCurrentAlertLevelCommand command = new LynxSetMotorChannelCurrentAlertLevelCommand(this.getModule(), motor, (int)Math.round(unit.toMilliAmps(current)));
        try {
            command.send();
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
        }
    }

    public boolean isMotorOverCurrent(int motor) {
        LynxModule module;
        LynxGetBulkInputDataCommand command = new LynxGetBulkInputDataCommand(this.getModule());
        if (this.getModule() instanceof LynxModule && (module = (LynxModule)this.getModule()).getBulkCachingMode() != LynxModule.BulkCachingMode.OFF) {
            LynxModule.BulkData bulkData = module.recordBulkCachingCommandIntent(command, "motorOverCurrent" + motor);
            return bulkData.isMotorOverCurrent(motor);
        }
        try {
            LynxGetBulkInputDataResponse response = (LynxGetBulkInputDataResponse)command.sendReceive();
            return response.isOverCurrent(motor);
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(false);
        }
    }

    @Override
    public void floatHardware() {
        for (int motor = 0; motor <= 3; ++motor) {
            this.setMotorPowerFloat(motor);
        }
    }

    private void runWithoutEncoders() {
        for (int motor = 0; motor <= 3; ++motor) {
            this.setMotorMode(motor, DcMotor.RunMode.RUN_WITHOUT_ENCODER);
        }
    }

    private void validateMotor(int motor) {
        if (motor < 0 || motor > 3) {
            throw new IllegalArgumentException(String.format("motor %d is invalid; valid motors are %d..%d", motor, 0, 3));
        }
    }

    private void validatePIDMode(int motor, DcMotor.RunMode runMode) {
        if (!runMode.isPIDMode()) {
            throw new IllegalArgumentException(String.format("motor %d: mode %s is invalid as PID Mode", motor, runMode));
        }
    }

    private void reportPIDFControlLoopCoefficients() throws RobotCoreException, InterruptedException {
        this.reportPIDFControlLoopCoefficients(DcMotor.RunMode.RUN_TO_POSITION);
        this.reportPIDFControlLoopCoefficients(DcMotor.RunMode.RUN_USING_ENCODER);
    }

    private void reportPIDFControlLoopCoefficients(DcMotor.RunMode mode) throws RobotCoreException, InterruptedException {
        if (DEBUG) {
            for (int motor = 0; motor <= 3; ++motor) {
                PIDFCoefficients coeffs = this.getPIDFCoefficients(motor, mode);
                RobotLog.vv((String)TAG, (String)"mod=%d motor=%d mode=%s p=%f i=%f d=%f f=%f alg=%s", (Object[])new Object[]{this.getModuleAddress(), motor, mode.toString(), coeffs.p, coeffs.i, coeffs.d, coeffs.f, coeffs.algorithm});
            }
        }
    }

    protected int getModuleAddress() {
        return this.getModule().getModuleAddress();
    }

    protected class MotorProperties {
        LastKnown<Double> lastKnownPower = new LastKnown();
        LastKnown<Integer> lastKnownTargetPosition = new LastKnown();
        LastKnown<DcMotor.RunMode> lastKnownMode = new LastKnown();
        LastKnown<DcMotor.ZeroPowerBehavior> lastKnownZeroPowerBehavior = new LastKnown();
        LastKnown<Boolean> lastKnownEnable = new LastKnown();
        LastKnown<Double> lastKnownCurrentAlert = new LastKnown();
        MotorConfigurationType motorType = MotorConfigurationType.getUnspecifiedMotorType();
        MotorConfigurationType internalMotorType = null;
        Map<DcMotor.RunMode, ExpansionHubMotorControllerParamsState> desiredPIDParams = new ConcurrentHashMap<DcMotor.RunMode, ExpansionHubMotorControllerParamsState>();
        Map<DcMotor.RunMode, ExpansionHubMotorControllerParamsState> originalPIDParams = new ConcurrentHashMap<DcMotor.RunMode, ExpansionHubMotorControllerParamsState>();

        protected MotorProperties() {
        }
    }
}

