/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx;

import android.content.Context;
import android.graphics.Color;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.qualcomm.hardware.HardwareManualControlOpMode;
import com.qualcomm.hardware.R;
import com.qualcomm.hardware.bosch.BHI260IMU;
import com.qualcomm.hardware.bosch.BNO055IMU;
import com.qualcomm.hardware.bosch.BNO055Util;
import com.qualcomm.hardware.lynx.LynxCommExceptionHandler;
import com.qualcomm.hardware.lynx.LynxController;
import com.qualcomm.hardware.lynx.LynxI2cDeviceSynch;
import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.LynxModuleWarningManager;
import com.qualcomm.hardware.lynx.LynxNackException;
import com.qualcomm.hardware.lynx.LynxUnsupportedCommandException;
import com.qualcomm.hardware.lynx.LynxUsbDevice;
import com.qualcomm.hardware.lynx.LynxUsbDeviceImpl;
import com.qualcomm.hardware.lynx.LynxUsbUtil;
import com.qualcomm.hardware.lynx.Supplier;
import com.qualcomm.hardware.lynx.commands.LynxCommand;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.LynxInterface;
import com.qualcomm.hardware.lynx.commands.LynxInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.LynxMessage;
import com.qualcomm.hardware.lynx.commands.LynxRespondable;
import com.qualcomm.hardware.lynx.commands.LynxResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxFirmwareVersionManager;
import com.qualcomm.hardware.lynx.commands.core.LynxFtdiResetControlCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetADCCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetADCResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetBulkInputDataCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetBulkInputDataResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxPhoneChargeControlCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxPhoneChargeQueryCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxPhoneChargeQueryResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxReadVersionStringCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxReadVersionStringResponse;
import com.qualcomm.hardware.lynx.commands.standard.LynxAck;
import com.qualcomm.hardware.lynx.commands.standard.LynxDiscoveryCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxFailSafeCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxGetModuleLEDColorCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxGetModuleStatusCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxGetModuleStatusResponse;
import com.qualcomm.hardware.lynx.commands.standard.LynxKeepAliveCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxNack;
import com.qualcomm.hardware.lynx.commands.standard.LynxQueryInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxQueryInterfaceResponse;
import com.qualcomm.hardware.lynx.commands.standard.LynxSetDebugLogLevelCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxSetModuleLEDColorCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxSetModuleLEDPatternCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxSetNewModuleAddressCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxStandardCommand;
import com.qualcomm.robotcore.R;
import com.qualcomm.robotcore.eventloop.opmode.OpModeManagerImpl;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.Blinker;
import com.qualcomm.robotcore.hardware.EmbeddedControlHubModule;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.HardwareDeviceHealth;
import com.qualcomm.robotcore.hardware.LynxModuleImuType;
import com.qualcomm.robotcore.hardware.RobotConfigNameable;
import com.qualcomm.robotcore.hardware.RobotCoreLynxModule;
import com.qualcomm.robotcore.hardware.VisuallyIdentifiableHardwareDevice;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import com.qualcomm.robotcore.hardware.usb.RobotArmingStateNotifier;
import com.qualcomm.robotcore.util.ClassUtil;
import com.qualcomm.robotcore.util.ElapsedTime;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.SerialNumber;
import com.qualcomm.robotcore.util.ThreadPool;
import com.qualcomm.robotcore.util.TypeConversion;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.firstinspires.ftc.robotcore.external.function.Consumer;
import org.firstinspires.ftc.robotcore.external.navigation.CurrentUnit;
import org.firstinspires.ftc.robotcore.external.navigation.TempUnit;
import org.firstinspires.ftc.robotcore.external.navigation.VoltageUnit;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.system.Assert;
import org.firstinspires.ftc.robotcore.internal.system.Misc;
import org.firstinspires.ftc.robotcore.internal.ui.UILocation;
import org.firstinspires.ftc.robotcore.internal.usb.LynxModuleSerialNumber;

public class LynxModule
extends LynxCommExceptionHandler
implements LynxModuleIntf,
RobotArmingStateNotifier,
RobotArmingStateNotifier.Callback,
Blinker,
VisuallyIdentifiableHardwareDevice {
    public static final String TAG = "LynxModule";
    public static BlinkerPolicy blinkerPolicy = new CountModuleAddressBlinkerPolicy();
    protected static final int msInitialContact = 500;
    protected static final int msKeepAliveTimeout = 2500;
    protected static final byte moduleStatusPersistentBits = 28;
    protected static Map<Integer, MessageClassAndCtor> standardMessages = new HashMap<Integer, MessageClassAndCtor>();
    protected static Map<Class<? extends LynxCommand>, MessageClassAndCtor> responseClasses = new HashMap<Class<? extends LynxCommand>, MessageClassAndCtor>();
    protected LynxUsbDevice lynxUsbDevice;
    protected List<LynxController> controllers;
    protected final Object addrAndSerialLock;
    protected int moduleAddress;
    protected SerialNumber moduleSerialNumber;
    protected AtomicInteger nextMessageNumber;
    protected boolean isParent;
    protected volatile boolean isSystemSynthetic;
    protected volatile boolean isUserModule;
    protected int systemOperationCounter = 0;
    protected boolean isEngaged;
    protected final Object engagementLock = this;
    protected volatile boolean isOpen;
    protected volatile boolean isNotResponding = false;
    protected final Object startStopLock;
    protected final ConcurrentHashMap<Integer, LynxRespondable> unfinishedCommands;
    protected final ConcurrentHashMap<Integer, MessageClassAndCtor> commandClasses;
    protected final Set<Class<? extends LynxCommand>> supportedCommands;
    protected final ConcurrentHashMap<String, LynxInterface> interfacesQueried;
    protected final Object i2cLock;
    protected ArrayList<Blinker.Step> currentSteps;
    protected Deque<ArrayList<Blinker.Step>> previousSteps;
    protected boolean isVisuallyIdentifying;
    protected ScheduledExecutorService executor;
    protected Future<?> pingFuture;
    protected final Object pingFutureLock;
    protected Future<?> moduleStatusFuture;
    protected boolean attentionRequiredPreviously;
    protected int previousModuleStatus;
    protected final Object moduleStatusLock;
    protected boolean ftdiResetWatchdogActive;
    protected boolean ftdiResetWatchdogActiveWhenEngaged;
    protected final Object bulkCachingLock;
    protected BulkCachingMode bulkCachingMode;
    protected Map<String, List<LynxDekaInterfaceCommand<?>>> bulkCachingHistory;
    @Nullable
    protected BulkData lastBulkData;

    @Override
    protected String getTag() {
        return TAG;
    }

    protected static void addStandardMessage(Class<? extends LynxMessage> clazz) {
        try {
            Integer commandNumber = (Integer)LynxMessage.invokeStaticNullaryMethod(clazz, "getStandardCommandNumber");
            Assert.assertTrue(((commandNumber & 0x8000) == 0 ? 1 : 0) != 0);
            MessageClassAndCtor pair = new MessageClassAndCtor();
            pair.clazz = clazz;
            pair.assignCtor();
            standardMessages.put(commandNumber, pair);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            RobotLog.ee((String)TAG, (String)"error registering %s", (Object[])new Object[]{clazz.getSimpleName()});
        }
    }

    protected static void correlateStandardResponse(Class<? extends LynxCommand> commandClass) {
        try {
            Class<LynxResponse> responseClass = LynxCommand.getResponseClass(commandClass);
            LynxModule.correlateResponse(commandClass, responseClass);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            RobotLog.ee((String)TAG, (String)"error registering response to %s", (Object[])new Object[]{commandClass.getSimpleName()});
        }
    }

    public static void correlateResponse(Class<? extends LynxCommand> commandClass, Class<? extends LynxResponse> responseClass) throws NoSuchMethodException {
        MessageClassAndCtor pair = new MessageClassAndCtor();
        pair.clazz = responseClass;
        pair.assignCtor();
        responseClasses.put(commandClass, pair);
    }

    public LynxModule(LynxUsbDevice lynxUsbDevice, int moduleAddress, boolean isParent, boolean isUserModule) {
        this.lynxUsbDevice = lynxUsbDevice;
        this.controllers = new CopyOnWriteArrayList<LynxController>();
        this.addrAndSerialLock = new Object();
        this.moduleAddress = moduleAddress;
        this.moduleSerialNumber = new LynxModuleSerialNumber(lynxUsbDevice.getSerialNumber(), moduleAddress);
        this.isParent = isParent;
        this.isSystemSynthetic = false;
        this.isEngaged = true;
        this.isUserModule = isUserModule;
        this.isOpen = true;
        this.startStopLock = new Object();
        this.nextMessageNumber = new AtomicInteger(0);
        this.commandClasses = new ConcurrentHashMap<Integer, MessageClassAndCtor>(standardMessages);
        this.supportedCommands = new HashSet<Class<? extends LynxCommand>>();
        for (MessageClassAndCtor pair : this.commandClasses.values()) {
            if (!ClassUtil.inheritsFrom(pair.clazz, LynxCommand.class)) continue;
            this.supportedCommands.add(pair.clazz);
        }
        this.interfacesQueried = new ConcurrentHashMap();
        this.unfinishedCommands = new ConcurrentHashMap();
        this.i2cLock = new Object();
        this.currentSteps = new ArrayList();
        this.previousSteps = new ArrayDeque<ArrayList<Blinker.Step>>();
        this.isVisuallyIdentifying = false;
        this.executor = null;
        this.pingFuture = null;
        this.moduleStatusFuture = null;
        this.attentionRequiredPreviously = false;
        this.previousModuleStatus = Integer.MIN_VALUE;
        this.moduleStatusLock = new Object();
        this.pingFutureLock = new Object();
        this.ftdiResetWatchdogActive = false;
        this.ftdiResetWatchdogActiveWhenEngaged = false;
        this.bulkCachingMode = BulkCachingMode.OFF;
        this.bulkCachingHistory = new HashMap();
        this.bulkCachingLock = new Object();
        this.startExecutor();
        this.lynxUsbDevice.registerCallback(this, false);
    }

    public String toString() {
        return Misc.formatForUser((String)"LynxModule(mod#=%d, serial=%s)", (Object[])new Object[]{this.getModuleAddress(), this.getSerialNumber()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.startStopLock;
        synchronized (object) {
            if (this.isOpen) {
                this.stopFtdiResetWatchdog();
                RobotLog.vv((String)TAG, (String)"close(#%d)", (Object[])new Object[]{this.getModuleAddress()});
                for (LynxController controller : this.controllers) {
                    controller.close();
                }
                this.unregisterCallback(this);
                this.lynxUsbDevice.removeConfiguredModule(this);
                this.isOpen = false;
                this.stopAttentionRequired();
                this.stopPingTimer(true);
                this.stopExecutor();
            }
        }
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean isUserModule() {
        return this.isUserModule;
    }

    public void setUserModule(boolean isUserModule) {
        this.warnIfClosed();
        this.isUserModule = isUserModule;
    }

    public boolean isSystemSynthetic() {
        return this.isSystemSynthetic;
    }

    public void setSystemSynthetic(boolean systemSynthetic) {
        this.warnIfClosed();
        this.isSystemSynthetic = systemSynthetic;
    }

    public void noteController(LynxController controller) {
        this.warnIfClosed();
        this.controllers.add(controller);
    }

    public int getRevProductNumber() {
        try {
            boolean succeeded = this.queryInterface(new LynxInterface("SERVO_HUB", new Class[0]));
            return succeeded ? 0x111855 : 3215698;
        }
        catch (InterruptedException e) {
            RobotLog.ee((String)TAG, (Throwable)e, (String)"Failed to determine the REV product number");
            return 3215698;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getModuleAddress() {
        Object object = this.addrAndSerialLock;
        synchronized (object) {
            return this.moduleAddress;
        }
    }

    public void setNewModuleAddress(final int newModuleAddress) {
        this.warnIfClosed();
        if (newModuleAddress != this.getModuleAddress()) {
            this.lynxUsbDevice.changeModuleAddress(this, newModuleAddress, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        LynxSetNewModuleAddressCommand command = new LynxSetNewModuleAddressCommand(LynxModule.this, (byte)newModuleAddress);
                        command.acquireNetworkLock();
                        try {
                            int oldAddress = LynxModule.this.getModuleAddress();
                            command.send();
                            Object object = LynxModule.this.addrAndSerialLock;
                            synchronized (object) {
                                LynxModule.this.moduleAddress = newModuleAddress;
                                LynxModule.this.moduleSerialNumber = new LynxModuleSerialNumber(LynxModule.this.getSerialNumber(), newModuleAddress);
                            }
                            HardwareManualControlOpMode manualControlOpMode = HardwareManualControlOpMode.getInstance();
                            if (manualControlOpMode != null) {
                                manualControlOpMode.onLynxModuleAddressChanged(LynxModule.this, oldAddress, newModuleAddress);
                            }
                        }
                        finally {
                            command.releaseNetworkLock();
                        }
                    }
                    catch (LynxNackException | InterruptedException e) {
                        LynxModule.this.handleException(e);
                    }
                }
            });
        }
    }

    protected byte getNewMessageNumber() {
        int intResult;
        byte result;
        do {
            result = (byte)this.nextMessageNumber.getAndIncrement();
            intResult = TypeConversion.unsignedByteToInt((byte)result);
        } while (result == 0 || this.unfinishedCommands.containsKey(intResult));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttentionRequired(boolean attentionRequired) {
        this.warnIfClosed();
        Object object = this.moduleStatusLock;
        synchronized (object) {
            boolean getModuleStatus = attentionRequired;
            if (!attentionRequired && this.attentionRequiredPreviously) {
                getModuleStatus = true;
            }
            this.attentionRequiredPreviously = attentionRequired;
            if (this.isOpen && getModuleStatus) {
                if (this.moduleStatusFuture != null) {
                    this.moduleStatusFuture.cancel(false);
                }
                this.moduleStatusFuture = this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (LynxModule.this.isOpen) {
                            LynxModule.this.sendGetModuleStatusAndProcessResponse(true);
                        }
                    }
                });
            }
        }
        if (attentionRequired) {
            this.forgetLastKnown();
        }
    }

    protected void noteDatagramReceived() {
        this.warnIfClosed();
        if (this.isNotResponding) {
            this.isNotResponding = false;
            RobotLog.vv((String)TAG, (String)"REV Hub #%d has reconnected", (Object[])new Object[]{this.getModuleAddress()});
        }
    }

    @Override
    public void noteNotResponding() {
        this.warnIfClosed();
        this.isNotResponding = true;
    }

    @Override
    public boolean isNotResponding() {
        this.warnIfClosed();
        return this.isNotResponding;
    }

    protected void warnIfClosed() {
        if (!this.isOpen()) {
            RobotLog.ww((String)TAG, (Throwable)new RuntimeException(), (String)"Attempted use of a closed LynxModule instance");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopAttentionRequired() {
        Object object = this.moduleStatusLock;
        synchronized (object) {
            if (this.moduleStatusFuture != null) {
                this.moduleStatusFuture.cancel(true);
                ThreadPool.awaitFuture(this.moduleStatusFuture, (long)250L, (TimeUnit)TimeUnit.MILLISECONDS);
                this.moduleStatusFuture = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendGetModuleStatusAndProcessResponse(boolean clearStatus) {
        LynxGetModuleStatusCommand command = new LynxGetModuleStatusCommand(this, clearStatus);
        try {
            HardwareManualControlOpMode manualControlOpMode;
            LynxGetModuleStatusResponse response = (LynxGetModuleStatusResponse)command.sendReceive();
            Object object = this.moduleStatusLock;
            synchronized (object) {
                int currentStatus = response.getStatus();
                int currentMotorAlerts = response.getMotorAlerts();
                if (currentStatus == this.previousModuleStatus && currentMotorAlerts == 0) {
                    return;
                }
                this.previousModuleStatus = currentStatus & 0x1C;
            }
            if (response.testAnyBits(-23)) {
                RobotLog.vv((String)TAG, (String)"received status: %s", (Object[])new Object[]{response.toString()});
            }
            if ((manualControlOpMode = HardwareManualControlOpMode.getInstance()) != null) {
                int statusWord = response.getStatus();
                int motorAlerts = response.getMotorAlerts();
                ThreadPool.getDefault().submit(() -> manualControlOpMode.onLynxModuleStatusChanged(this, statusWord, motorAlerts));
            }
            if (response.isKeepAliveTimeout()) {
                this.resendCurrentPattern();
            }
            if (response.isDeviceReset() && this.isUserModule()) {
                LynxModuleWarningManager.getInstance().reportModuleReset(this);
                this.resendCurrentPattern();
            }
            if (response.isBatteryLow() && this.isUserModule()) {
                LynxModuleWarningManager.getInstance().reportModuleLowBattery(this);
            }
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
        }
    }

    protected void forgetLastKnown() {
        for (LynxController controller : this.controllers) {
            controller.forgetLastKnown();
        }
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.Lynx;
    }

    public String getDeviceName() {
        return String.format("%s (%s)", AppUtil.getDefContext().getString(R.string.expansionHubDisplayName), this.getFirmwareVersionString());
    }

    public String getFirmwareVersionString() {
        String result = this.getNullableFirmwareVersionString();
        if (result == null) {
            result = AppUtil.getDefContext().getString(R.string.lynxUnavailableFWVersionString);
        }
        return result;
    }

    public String getNullableFirmwareVersionString() {
        this.warnIfClosed();
        try {
            LynxReadVersionStringCommand command = new LynxReadVersionStringCommand(this);
            LynxReadVersionStringResponse response = (LynxReadVersionStringResponse)command.sendReceive();
            return response.getNullableVersionString();
        }
        catch (LynxNackException | InterruptedException e) {
            this.handleException(e);
            return null;
        }
    }

    public String getConnectionInfo() {
        return String.format("%s; module %d", this.lynxUsbDevice.getConnectionInfo(), this.getModuleAddress());
    }

    public int getVersion() {
        return 1;
    }

    public void resetDeviceConfigurationForOpMode() {
        this.warnIfClosed();
        this.setBulkCachingMode(BulkCachingMode.OFF);
    }

    public List<String> getGlobalWarnings() {
        this.warnIfClosed();
        ArrayList<String> result = new ArrayList<String>();
        for (LynxController controller : this.controllers) {
            String candidate = LynxModule.getHealthStatusWarningMessage(controller);
            if (candidate.isEmpty()) continue;
            result.add(candidate);
        }
        return result;
    }

    @NonNull
    public static String getHealthStatusWarningMessage(HardwareDeviceHealth hardwareDeviceHealth) {
        switch (hardwareDeviceHealth.getHealthStatus()) {
            case UNHEALTHY: {
                String name = null;
                if (hardwareDeviceHealth instanceof RobotConfigNameable && (name = ((RobotConfigNameable)hardwareDeviceHealth).getUserConfiguredName()) != null) {
                    name = AppUtil.getDefContext().getString(R.string.quotes, new Object[]{name});
                }
                if (name == null && hardwareDeviceHealth instanceof HardwareDevice) {
                    HardwareDevice hardwareDevice = (HardwareDevice)hardwareDeviceHealth;
                    String typeDescription = hardwareDevice.getDeviceName();
                    String connectionInfo = hardwareDevice.getConnectionInfo();
                    name = AppUtil.getDefContext().getString(R.string.hwDeviceDescriptionAndConnection, new Object[]{typeDescription, connectionInfo});
                }
                if (name == null) {
                    name = AppUtil.getDefContext().getString(R.string.hwPoorlyNamedDevice);
                }
                return AppUtil.getDefContext().getString(R.string.unhealthyDevice, new Object[]{name});
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerialNumber getModuleSerialNumber() {
        Object object = this.addrAndSerialLock;
        synchronized (object) {
            return this.moduleSerialNumber;
        }
    }

    public SerialNumber getSerialNumber() {
        return this.lynxUsbDevice.getSerialNumber();
    }

    public RobotArmingStateNotifier.ARMINGSTATE getArmingState() {
        return this.lynxUsbDevice.getArmingState();
    }

    public void registerCallback(RobotArmingStateNotifier.Callback callback, boolean doInitialCallback) {
        this.lynxUsbDevice.registerCallback(callback, doInitialCallback);
    }

    public void unregisterCallback(RobotArmingStateNotifier.Callback callback) {
        this.lynxUsbDevice.unregisterCallback(callback);
    }

    public void onModuleStateChange(RobotArmingStateNotifier module, RobotArmingStateNotifier.ARMINGSTATE state) {
        switch (state) {
            default: 
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engage() {
        this.warnIfClosed();
        Object object = this.engagementLock;
        synchronized (object) {
            if (!this.isEngaged) {
                RobotLog.vv((String)TAG, (String)"engaging lynx module #%d", (Object[])new Object[]{this.getModuleAddress()});
                for (LynxController controller : this.controllers) {
                    controller.engage();
                }
                this.isEngaged = true;
                if (this.ftdiResetWatchdogActiveWhenEngaged) {
                    this.startFtdiResetWatchdog();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disengage() {
        this.warnIfClosed();
        Object object = this.engagementLock;
        synchronized (object) {
            if (this.isEngaged) {
                RobotLog.vv((String)TAG, (String)"disengaging lynx module #%d", (Object[])new Object[]{this.getModuleAddress()});
                this.stopFtdiResetWatchdog(true);
                this.isEngaged = false;
                this.nackUnfinishedCommands();
                for (LynxController controller : this.controllers) {
                    controller.disengage();
                }
                this.nackUnfinishedCommands();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEngaged() {
        this.warnIfClosed();
        Object object = this.engagementLock;
        synchronized (object) {
            return this.isEngaged;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visuallyIdentify(boolean shouldIdentify) {
        this.warnIfClosed();
        LynxModule lynxModule = this;
        synchronized (lynxModule) {
            if (this.isVisuallyIdentifying != shouldIdentify) {
                if (!this.isVisuallyIdentifying) {
                    this.internalPushPattern(blinkerPolicy.getVisuallyIdentifyPattern(this));
                } else {
                    this.popPattern();
                }
                this.isVisuallyIdentifying = shouldIdentify;
            }
        }
    }

    public int getBlinkerPatternMaxLength() {
        return 16;
    }

    public void setConstant(@ColorInt int color) {
        this.warnIfClosed();
        Blinker.Step step = new Blinker.Step(color, 1L, TimeUnit.SECONDS);
        ArrayList<Blinker.Step> steps = new ArrayList<Blinker.Step>();
        steps.add(step);
        this.setPattern(steps);
    }

    public void stopBlinking() {
        this.warnIfClosed();
        this.setConstant(-16777216);
    }

    public synchronized void setPattern(Collection<Blinker.Step> steps) {
        this.currentSteps = steps == null ? new ArrayList() : new ArrayList<Blinker.Step>(steps);
        this.sendLEDPatternSteps(this.currentSteps);
    }

    public synchronized Collection<Blinker.Step> getPattern() {
        this.warnIfClosed();
        return new ArrayList<Blinker.Step>(this.currentSteps);
    }

    protected void resendCurrentPattern() {
        RobotLog.vv((String)TAG, (String)"resendCurrentPattern()");
        this.sendLEDPatternSteps(this.currentSteps);
    }

    public synchronized void pushPattern(Collection<Blinker.Step> steps) {
        this.visuallyIdentify(false);
        this.internalPushPattern(steps);
    }

    protected void internalPushPattern(Collection<Blinker.Step> steps) {
        this.warnIfClosed();
        this.previousSteps.push(this.currentSteps);
        this.setPattern(steps);
    }

    public synchronized boolean patternStackNotEmpty() {
        this.warnIfClosed();
        return this.previousSteps.size() > 0;
    }

    public synchronized boolean popPattern() {
        this.warnIfClosed();
        try {
            this.setPattern((Collection<Blinker.Step>)this.previousSteps.pop());
            return true;
        }
        catch (NoSuchElementException e) {
            this.setPattern(null);
            return false;
        }
    }

    void sendLEDPatternSteps(Collection<Blinker.Step> steps) {
        this.warnIfClosed();
        RobotLog.vv((String)TAG, (String)"sendLEDPatternSteps(): steps=%s", (Object[])new Object[]{steps});
        this.ping();
        LynxSetModuleLEDPatternCommand.Steps commandSteps = new LynxSetModuleLEDPatternCommand.Steps();
        for (Blinker.Step step : steps) {
            commandSteps.add(step);
        }
        LynxSetModuleLEDPatternCommand patternCommand = new LynxSetModuleLEDPatternCommand(this, commandSteps);
        try {
            patternCommand.sendReceive();
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
        }
    }

    public boolean isParent() {
        this.warnIfClosed();
        return this.isParent;
    }

    public void pingAndQueryKnownInterfacesAndEtc() throws RobotCoreException, InterruptedException {
        this.warnIfClosed();
        RobotLog.vv((String)TAG, (String)"pingAndQueryKnownInterfaces mod=%d", (Object[])new Object[]{this.getModuleAddress()});
        this.pingInitialContact();
        this.queryInterface(LynxDekaInterfaceCommand.createDekaInterface());
        this.startFtdiResetWatchdog();
        this.initializeDebugLogging();
        this.initializeLEDS();
        if (this.isParent() && LynxConstants.isEmbeddedSerialNumber((SerialNumber)this.getSerialNumber())) {
            RobotLog.vv((String)TAG, (String)"setAsControlHubEmbeddedModule(mod=%d)", (Object[])new Object[]{this.getModuleAddress()});
            EmbeddedControlHubModule.set((RobotCoreLynxModule)this);
        }
    }

    protected void initializeLEDS() {
        this.setPattern(blinkerPolicy.getIdlePattern(this));
    }

    protected void initializeDebugLogging() throws RobotCoreException, InterruptedException {
        this.setDebug(DebugGroup.MODULELED, DebugVerbosity.HIGH);
    }

    protected void pingInitialContact() throws RobotCoreException, InterruptedException {
        ElapsedTime duration = new ElapsedTime();
        while (duration.milliseconds() < 500.0) {
            try {
                this.ping(true);
                return;
            }
            catch (LynxNackException | RobotCoreException | RuntimeException e) {
                RobotLog.vv((String)TAG, (String)"retrying ping mod=%d", (Object[])new Object[]{this.getModuleAddress()});
            }
        }
        throw new RobotCoreException("initial ping contact failed: mod=%d", new Object[]{this.getModuleAddress()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateCommand(LynxMessage lynxMessage) throws LynxUnsupportedCommandException {
        this.warnIfClosed();
        ConcurrentHashMap<String, LynxInterface> concurrentHashMap = this.interfacesQueried;
        synchronized (concurrentHashMap) {
            if (this.lynxUsbDevice.getArmingState() != RobotArmingStateNotifier.ARMINGSTATE.ARMED) {
                return;
            }
            int commandNumber = lynxMessage.getCommandNumber();
            if (LynxStandardCommand.isStandardCommandNumber(commandNumber)) {
                return;
            }
            if (!this.commandClasses.containsKey(commandNumber)) {
                throw new LynxUnsupportedCommandException(this, lynxMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCommandSupported(Class<? extends LynxCommand> clazz) {
        this.warnIfClosed();
        ConcurrentHashMap<String, LynxInterface> concurrentHashMap = this.interfacesQueried;
        synchronized (concurrentHashMap) {
            return this.getModuleAddress() == 0 ? clazz == LynxDiscoveryCommand.class : this.supportedCommands.contains(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean queryInterface(LynxInterface theInterface) throws InterruptedException {
        this.warnIfClosed();
        boolean supported = false;
        ConcurrentHashMap<String, LynxInterface> concurrentHashMap = this.interfacesQueried;
        synchronized (concurrentHashMap) {
            LynxQueryInterfaceCommand queryInterfaceCommand = new LynxQueryInterfaceCommand(this, theInterface.getInterfaceName());
            try {
                LynxQueryInterfaceResponse response = (LynxQueryInterfaceResponse)queryInterfaceCommand.sendReceive();
                theInterface.setWasNacked(false);
                theInterface.setBaseCommandNumber(response.getCommandNumberFirst());
                RobotLog.vv((String)TAG, (String)"mod#=%d queryInterface(%s)=%d commands starting at %d", (Object[])new Object[]{this.getModuleAddress(), theInterface.getInterfaceName(), response.getNumberOfCommands(), response.getCommandNumberFirst()});
                List<Class<? extends LynxInterfaceCommand>> interfaceCommandClasses = theInterface.getCommandClasses();
                for (Map.Entry<Integer, MessageClassAndCtor> pair : this.commandClasses.entrySet()) {
                    if (!interfaceCommandClasses.contains(pair.getValue().clazz)) continue;
                    this.commandClasses.remove(pair.getKey());
                    this.supportedCommands.remove(pair.getValue().clazz);
                }
                int iCommand = 0;
                for (Class<? extends LynxInterfaceCommand> interfaceCommandClass : interfaceCommandClasses) {
                    if (iCommand >= response.getNumberOfCommands()) {
                        RobotLog.vv((String)TAG, (String)"mod#=%d intf=%s: expected %d commands; found %d", (Object[])new Object[]{this.getModuleAddress(), theInterface.getInterfaceName(), interfaceCommandClasses.size(), response.getNumberOfCommands()});
                        break;
                    }
                    if (interfaceCommandClass != null) {
                        try {
                            int commandNumber = iCommand + response.getCommandNumberFirst();
                            MessageClassAndCtor pair = new MessageClassAndCtor();
                            pair.clazz = interfaceCommandClass;
                            pair.assignCtor();
                            this.commandClasses.put(commandNumber, pair);
                            this.supportedCommands.add(interfaceCommandClass);
                        }
                        catch (NoSuchMethodException | RuntimeException e) {
                            RobotLog.ee((String)TAG, (Throwable)e, (String)"exception registering %s", (Object[])new Object[]{interfaceCommandClass.getSimpleName()});
                        }
                    }
                    ++iCommand;
                }
                this.interfacesQueried.put(theInterface.getInterfaceName(), theInterface);
                supported = true;
            }
            catch (LynxNackException e) {
                boolean success;
                RobotLog.vv((String)TAG, (String)"mod#=%d queryInterface(): interface %s is not supported", (Object[])new Object[]{this.getModuleAddress(), theInterface.getInterfaceName()});
                theInterface.setWasNacked(true);
                this.interfacesQueried.put(theInterface.getInterfaceName(), theInterface);
                if (Objects.equals(theInterface.getInterfaceName(), "DEKA") && (success = this.queryInterface(new LynxInterface("SERVO_HUB", new Class[0])))) {
                    AppUtil.getInstance().showAlertDialog(UILocation.BOTH, "Unsupported Servo Hub Firmware Version", "The Robot Controller app needs to be updated to support the firmware version of the connected Servo Hub");
                }
            }
            catch (RuntimeException e) {
                RobotLog.ee((String)TAG, (Throwable)e, (String)"exception during queryInterface(%s)", (Object[])new Object[]{theInterface.getInterfaceName()});
                RobotLog.setGlobalErrorMsg((String)"REV Hub interface query failed");
            }
        }
        return supported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LynxInterface getInterface(String interfaceName) {
        this.warnIfClosed();
        ConcurrentHashMap<String, LynxInterface> concurrentHashMap = this.interfacesQueried;
        synchronized (concurrentHashMap) {
            LynxInterface anInterface = this.interfacesQueried.get(interfaceName);
            if (anInterface == null) {
                RobotLog.ee((String)TAG, (String)"interface \"%s\" has not been successfully queried for %s", (Object[])new Object[]{interfaceName, this});
            } else if (anInterface.wasNacked()) {
                RobotLog.ee((String)TAG, (String)"interface \"%s\" not supported on %s", (Object[])new Object[]{interfaceName, this});
            }
            return anInterface;
        }
    }

    protected void ping() {
        try {
            this.ping(false);
        }
        catch (LynxNackException | RobotCoreException | InterruptedException | RuntimeException e) {
            this.handleException((Exception)e);
        }
    }

    protected void ping(boolean initialPing) throws RobotCoreException, InterruptedException, LynxNackException {
        this.warnIfClosed();
        LynxKeepAliveCommand command = new LynxKeepAliveCommand(this, initialPing);
        command.send();
    }

    protected int getMsModulePingInterval() {
        return 1950;
    }

    @Override
    public void resetPingTimer(@NonNull LynxMessage message) {
        this.warnIfClosed();
        this.startPingTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startPingTimer() {
        this.warnIfClosed();
        Object object = this.pingFutureLock;
        synchronized (object) {
            this.stopPingTimer(false);
            if (this.isOpen) {
                try {
                    this.pingFuture = this.executor.schedule(new Runnable(){

                        @Override
                        public void run() {
                            if (LynxModule.this.isOpen) {
                                LynxModule.this.ping();
                            }
                        }
                    }, (long)this.getMsModulePingInterval(), TimeUnit.MILLISECONDS);
                }
                catch (RejectedExecutionException e) {
                    RobotLog.vv((String)TAG, (String)"mod#=%d: scheduling of ping rejected: ignored", (Object[])new Object[]{this.getModuleAddress()});
                    this.pingFuture = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopPingTimer(boolean wait) {
        Object object = this.pingFutureLock;
        synchronized (object) {
            if (this.pingFuture != null) {
                this.pingFuture.cancel(false);
                if (wait && !ThreadPool.awaitFuture(this.pingFuture, (long)250L, (TimeUnit)TimeUnit.MILLISECONDS)) {
                    RobotLog.vv((String)TAG, (String)"mod#=%d: unable to await ping future cancellation", (Object[])new Object[]{this.getModuleAddress()});
                }
                this.pingFuture = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startFtdiResetWatchdog() {
        Object object = this.engagementLock;
        synchronized (object) {
            if (!this.ftdiResetWatchdogActive) {
                this.ftdiResetWatchdogActive = true;
                this.setFtdiResetWatchdog(true);
            }
            if (this.isEngaged) {
                this.ftdiResetWatchdogActiveWhenEngaged = this.ftdiResetWatchdogActive;
            }
        }
    }

    protected void stopFtdiResetWatchdog() {
        this.stopFtdiResetWatchdog(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopFtdiResetWatchdog(boolean disengaging) {
        Object object = this.engagementLock;
        synchronized (object) {
            if (this.ftdiResetWatchdogActive) {
                this.ftdiResetWatchdogActive = false;
                this.setFtdiResetWatchdog(false);
            }
            if (this.isEngaged && !disengaging) {
                this.ftdiResetWatchdogActiveWhenEngaged = this.ftdiResetWatchdogActive;
            }
        }
    }

    protected void setFtdiResetWatchdog(boolean enabled) {
        if (this.isCommandSupported(LynxFtdiResetControlCommand.class)) {
            boolean wasInterrupted = Thread.interrupted();
            RobotLog.vv((String)TAG, (String)"sending LynxFtdiResetControlCommand(%s) wasInterrupted=%s", (Object[])new Object[]{enabled, wasInterrupted});
            try {
                LynxFtdiResetControlCommand command = new LynxFtdiResetControlCommand((LynxModuleIntf)this, enabled);
                command.sendReceive();
            }
            catch (LynxNackException | InterruptedException | RuntimeException e) {
                this.handleException(e);
            }
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected void startExecutor() {
        if (this.executor == null) {
            this.executor = ThreadPool.newScheduledExecutor((int)1, (String)"lynx module executor");
        }
    }

    protected void stopExecutor() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            try {
                ThreadPool.awaitTermination((ExecutorService)this.executor, (long)2L, (TimeUnit)TimeUnit.SECONDS, (String)"lynx module executor");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkData getBulkData() {
        this.warnIfClosed();
        Object object = this.bulkCachingLock;
        synchronized (object) {
            this.clearBulkCache();
            LynxGetBulkInputDataCommand command = new LynxGetBulkInputDataCommand(this);
            try {
                LynxGetBulkInputDataResponse response = (LynxGetBulkInputDataResponse)command.sendReceive();
                this.lastBulkData = new BulkData(response, false);
                return this.lastBulkData;
            }
            catch (LynxNackException | InterruptedException | RuntimeException e) {
                this.handleException(e);
                this.lastBulkData = LynxUsbUtil.makePlaceholderValue(new BulkData(new LynxGetBulkInputDataResponse(this), true));
                return this.lastBulkData;
            }
        }
    }

    public BulkCachingMode getBulkCachingMode() {
        this.warnIfClosed();
        return this.bulkCachingMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBulkCachingMode(BulkCachingMode mode) {
        this.warnIfClosed();
        Object object = this.bulkCachingLock;
        synchronized (object) {
            if (mode == BulkCachingMode.OFF) {
                this.clearBulkCache();
            }
            this.bulkCachingMode = mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBulkCache() {
        this.warnIfClosed();
        Object object = this.bulkCachingLock;
        synchronized (object) {
            for (List<LynxDekaInterfaceCommand<?>> commands : this.bulkCachingHistory.values()) {
                commands.clear();
            }
            this.lastBulkData = null;
        }
    }

    BulkData recordBulkCachingCommandIntent(LynxDekaInterfaceCommand<?> command) {
        this.warnIfClosed();
        return this.recordBulkCachingCommandIntent(command, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BulkData recordBulkCachingCommandIntent(LynxDekaInterfaceCommand<?> command, String tag) {
        this.warnIfClosed();
        Object object = this.bulkCachingLock;
        synchronized (object) {
            List<LynxDekaInterfaceCommand<?>> commands = this.bulkCachingHistory.get(tag);
            if (this.bulkCachingMode == BulkCachingMode.AUTO) {
                if (commands == null) {
                    commands = new ArrayList();
                    this.bulkCachingHistory.put(tag, commands);
                }
                for (LynxDekaInterfaceCommand<?> otherCommand : commands) {
                    if (otherCommand.getDestModuleAddress() != command.getDestModuleAddress() || otherCommand.getCommandNumber() != command.getCommandNumber() || !Arrays.equals(otherCommand.toPayloadByteArray(), command.toPayloadByteArray())) continue;
                    this.clearBulkCache();
                    break;
                }
            }
            if (this.lastBulkData == null) {
                this.getBulkData();
            }
            if (this.bulkCachingMode == BulkCachingMode.AUTO) {
                commands.add(command);
            }
            return this.lastBulkData;
        }
    }

    public void failSafe() throws RobotCoreException, InterruptedException, LynxNackException {
        this.warnIfClosed();
        LynxFailSafeCommand command = new LynxFailSafeCommand(this);
        command.send();
        this.forgetLastKnown();
    }

    public void attemptFailSafeAndIgnoreErrors() {
        try {
            this.failSafe();
        }
        catch (LynxNackException | RobotCoreException | InterruptedException | RuntimeException throwable) {
            // empty catch block
        }
    }

    public void enablePhoneCharging(boolean enable) throws RobotCoreException, InterruptedException, LynxNackException {
        this.warnIfClosed();
        LynxPhoneChargeControlCommand command = new LynxPhoneChargeControlCommand((LynxModuleIntf)this, enable);
        command.send();
    }

    public boolean isPhoneChargingEnabled() throws RobotCoreException, InterruptedException, LynxNackException {
        this.warnIfClosed();
        LynxPhoneChargeQueryCommand command = new LynxPhoneChargeQueryCommand(this);
        LynxPhoneChargeQueryResponse response = (LynxPhoneChargeQueryResponse)command.sendReceive();
        return response.isChargeEnabled();
    }

    public double getCurrent(CurrentUnit unit) {
        this.warnIfClosed();
        LynxGetADCCommand command = new LynxGetADCCommand(this, LynxGetADCCommand.Channel.BATTERY_CURRENT, LynxGetADCCommand.Mode.ENGINEERING);
        try {
            LynxGetADCResponse response = (LynxGetADCResponse)command.sendReceive();
            return unit.convert((double)response.getValue(), CurrentUnit.MILLIAMPS);
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(0.0);
        }
    }

    public double getGpioBusCurrent(CurrentUnit unit) {
        this.warnIfClosed();
        LynxGetADCCommand command = new LynxGetADCCommand(this, LynxGetADCCommand.Channel.GPIO_CURRENT, LynxGetADCCommand.Mode.ENGINEERING);
        try {
            LynxGetADCResponse response = (LynxGetADCResponse)command.sendReceive();
            return unit.convert((double)response.getValue(), CurrentUnit.MILLIAMPS);
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(0.0);
        }
    }

    public double getI2cBusCurrent(CurrentUnit unit) {
        this.warnIfClosed();
        LynxGetADCCommand command = new LynxGetADCCommand(this, LynxGetADCCommand.Channel.I2C_BUS_CURRENT, LynxGetADCCommand.Mode.ENGINEERING);
        try {
            LynxGetADCResponse response = (LynxGetADCResponse)command.sendReceive();
            return unit.convert((double)response.getValue(), CurrentUnit.MILLIAMPS);
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(0.0);
        }
    }

    public double getInputVoltage(VoltageUnit unit) {
        this.warnIfClosed();
        LynxGetADCCommand command = new LynxGetADCCommand(this, LynxGetADCCommand.Channel.BATTERY_MONITOR, LynxGetADCCommand.Mode.ENGINEERING);
        try {
            LynxGetADCResponse response = (LynxGetADCResponse)command.sendReceive();
            return unit.convert((double)response.getValue(), VoltageUnit.MILLIVOLTS);
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(0.0);
        }
    }

    public double getAuxiliaryVoltage(VoltageUnit unit) {
        this.warnIfClosed();
        LynxGetADCCommand command = new LynxGetADCCommand(this, LynxGetADCCommand.Channel.FIVE_VOLT_MONITOR, LynxGetADCCommand.Mode.ENGINEERING);
        try {
            LynxGetADCResponse response = (LynxGetADCResponse)command.sendReceive();
            return unit.convert((double)response.getValue(), VoltageUnit.MILLIVOLTS);
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(0.0);
        }
    }

    public double getTemperature(TempUnit unit) {
        this.warnIfClosed();
        LynxGetADCCommand command = new LynxGetADCCommand(this, LynxGetADCCommand.Channel.CONTROLLER_TEMPERATURE, LynxGetADCCommand.Mode.ENGINEERING);
        try {
            LynxGetADCResponse response = (LynxGetADCResponse)command.sendReceive();
            return unit.fromCelsius((double)response.getValue() / 10.0);
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public LynxModuleImuType getImuType() {
        this.warnIfClosed();
        if (!LynxConstants.revHubTypeCanHaveImu((int)this.getRevProductNumber())) {
            return LynxModuleImuType.NONE;
        }
        try (LynxI2cDeviceSynch rawImuI2c = LynxFirmwareVersionManager.createLynxI2cDeviceSynch((Context)AppUtil.getDefContext(), this, 0);){
            LynxModuleImuType result = LynxModuleImuType.NONE;
            rawImuI2c.setI2cAddress(BNO055IMU.I2CADDR_DEFAULT);
            if (BNO055Util.imuIsPresent(rawImuI2c, false)) {
                result = LynxModuleImuType.BNO055;
            }
            if (result == LynxModuleImuType.NONE && this.lynxUsbDevice.getSerialNumber().isEmbedded() && this.isParent() && BHI260IMU.imuIsPresent(rawImuI2c)) {
                result = LynxModuleImuType.BHI260;
            }
            if (result == LynxModuleImuType.NONE && this.isNotResponding) {
                result = LynxModuleImuType.UNKNOWN;
            }
            LynxModuleImuType lynxModuleImuType = result;
            return lynxModuleImuType;
        }
    }

    public void setDebug(DebugGroup group, DebugVerbosity verbosity) throws InterruptedException {
        this.warnIfClosed();
        try {
            LynxSetDebugLogLevelCommand command = new LynxSetDebugLogLevelCommand(this, group, verbosity);
            command.send();
        }
        catch (LynxNackException | RuntimeException e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T acquireI2cLockWhile(Supplier<T> supplier) throws InterruptedException, RobotCoreException, LynxNackException {
        this.warnIfClosed();
        Object object = this.i2cLock;
        synchronized (object) {
            return supplier.get();
        }
    }

    @Override
    public void acquireNetworkTransmissionLock(@NonNull LynxMessage message) throws InterruptedException {
        this.warnIfClosed();
        this.lynxUsbDevice.acquireNetworkTransmissionLock(message);
    }

    @Override
    public void releaseNetworkTransmissionLock(@NonNull LynxMessage message) throws InterruptedException {
        this.warnIfClosed();
        this.lynxUsbDevice.releaseNetworkTransmissionLock(message);
    }

    @Override
    public void sendCommand(LynxMessage command) throws InterruptedException, LynxUnsupportedCommandException {
        this.warnIfClosed();
        if (command.isDangerous() && OpModeManagerImpl.shouldPreventDangerousHardwareAccess()) {
            ((LynxRespondable)command).onNackReceived(new LynxNack((LynxModuleIntf)this, LynxNack.StandardReasonCode.CANCELLED_FOR_SAFETY));
            return;
        }
        command.setMessageNumber(this.getNewMessageNumber());
        int msgnumCur = command.getMessageNumber();
        LynxDatagram datagram = new LynxDatagram(command);
        command.setSerialization(datagram);
        boolean moduleWillReply = command.isAckable() || command.isResponseExpected();
        this.unfinishedCommands.put(msgnumCur, (LynxRespondable)command);
        this.lynxUsbDevice.transmit(command);
        if (!moduleWillReply) {
            this.finishedWithMessage(command);
        }
    }

    @Override
    public void retransmit(LynxMessage message) throws InterruptedException {
        this.warnIfClosed();
        RobotLog.vv((String)TAG, (String)"retransmitting: mod=%d cmd=0x%02x msg#=%d ref#=%d ", (Object[])new Object[]{this.getModuleAddress(), message.getCommandNumber(), message.getMessageNumber(), message.getReferenceNumber()});
        this.lynxUsbDevice.transmit(message);
    }

    @Override
    public void finishedWithMessage(LynxMessage message) {
        if (LynxUsbDeviceImpl.DEBUG_LOG_DATAGRAMS_FINISH) {
            RobotLog.vv((String)TAG, (String)"finishing mod=%d msg#=%d", (Object[])new Object[]{message.getModuleAddress(), message.getMessageNumber()});
        }
        int messageNumber = message.getMessageNumber();
        this.unfinishedCommands.remove(messageNumber);
        message.forgetSerialization();
    }

    public void pretendFinishExtantCommands() throws InterruptedException {
        this.warnIfClosed();
        for (LynxRespondable ackable : this.unfinishedCommands.values()) {
            ackable.pretendFinish();
        }
    }

    public void onIncomingDatagramReceived(LynxDatagram datagram) {
        this.warnIfClosed();
        this.noteDatagramReceived();
        try {
            MessageClassAndCtor pair = this.commandClasses.get(datagram.getCommandNumber());
            if (pair != null) {
                if (datagram.isResponse()) {
                    pair = responseClasses.get(pair.clazz);
                }
                if (pair != null) {
                    LynxMessage incomingMessage = pair.ctor.newInstance(this);
                    incomingMessage.setSerialization(datagram);
                    incomingMessage.loadFromSerialization();
                    if (LynxUsbDeviceImpl.DEBUG_LOG_MESSAGES) {
                        RobotLog.vv((String)TAG, (String)"rec'd: mod=%d cmd=0x%02x(%s) msg#=%d ref#=%d", (Object[])new Object[]{datagram.getSourceModuleAddress(), datagram.getPacketId(), incomingMessage.getClass().getSimpleName(), incomingMessage.getMessageNumber(), incomingMessage.getReferenceNumber()});
                    }
                    if (incomingMessage.isAck() || incomingMessage.isNack()) {
                        LynxRespondable ackdCommand = this.unfinishedCommands.get(datagram.getReferenceNumber());
                        if (ackdCommand != null) {
                            if (incomingMessage.isNack()) {
                                ackdCommand.onNackReceived((LynxNack)incomingMessage);
                            } else {
                                ackdCommand.onAckReceived((LynxAck)incomingMessage);
                            }
                            this.finishedWithMessage(ackdCommand);
                        } else {
                            RobotLog.ee((String)TAG, (String)"unable to find originating LynxRespondable for mod=%d msg#=%d ref#=%d", (Object[])new Object[]{datagram.getSourceModuleAddress(), datagram.getMessageNumber(), datagram.getReferenceNumber()});
                        }
                    } else {
                        LynxRespondable originatingCommand = this.unfinishedCommands.get(datagram.getReferenceNumber());
                        if (originatingCommand != null) {
                            Assert.assertTrue((boolean)incomingMessage.isResponse());
                            originatingCommand.onResponseReceived((LynxResponse)incomingMessage);
                            this.finishedWithMessage(originatingCommand);
                        } else {
                            RobotLog.ee((String)TAG, (String)"unable to find originating command for packetid=0x%04x msg#=%d ref#=%d", (Object[])new Object[]{datagram.getPacketId(), datagram.getMessageNumber(), datagram.getReferenceNumber()});
                        }
                    }
                }
            } else {
                RobotLog.ee((String)TAG, (String)"no command class known for command=0x%02x", (Object[])new Object[]{datagram.getCommandNumber()});
            }
        }
        catch (IllegalAccessException | InstantiationException | RuntimeException | InvocationTargetException e) {
            RobotLog.ee((String)TAG, (Throwable)e, (String)"internal error in LynxModule.noteIncomingDatagramReceived()");
        }
    }

    public void abandonUnfinishedCommands() {
        this.warnIfClosed();
        this.unfinishedCommands.clear();
    }

    protected void nackUnfinishedCommands() {
        this.warnIfClosed();
        while (!this.unfinishedCommands.isEmpty()) {
            for (LynxRespondable respondable : this.unfinishedCommands.values()) {
                RobotLog.vv((String)TAG, (String)"force-nacking unfinished command=%s mod=%d msg#=%d", (Object[])new Object[]{respondable.getClass().getSimpleName(), respondable.getModuleAddress(), respondable.getMessageNumber()});
                LynxNack nack = new LynxNack((LynxModuleIntf)this, respondable.isResponseExpected() ? LynxNack.StandardReasonCode.ABANDONED_WAITING_FOR_RESPONSE : LynxNack.StandardReasonCode.ABANDONED_WAITING_FOR_ACK);
                respondable.onNackReceived(nack);
                this.finishedWithMessage(respondable);
            }
        }
    }

    static {
        LynxModule.addStandardMessage(LynxAck.class);
        LynxModule.addStandardMessage(LynxNack.class);
        LynxModule.addStandardMessage(LynxKeepAliveCommand.class);
        LynxModule.addStandardMessage(LynxGetModuleStatusCommand.class);
        LynxModule.addStandardMessage(LynxFailSafeCommand.class);
        LynxModule.addStandardMessage(LynxSetNewModuleAddressCommand.class);
        LynxModule.addStandardMessage(LynxQueryInterfaceCommand.class);
        LynxModule.addStandardMessage(LynxSetNewModuleAddressCommand.class);
        LynxModule.addStandardMessage(LynxSetModuleLEDColorCommand.class);
        LynxModule.addStandardMessage(LynxGetModuleLEDColorCommand.class);
        LynxModule.correlateStandardResponse(LynxGetModuleStatusCommand.class);
        LynxModule.correlateStandardResponse(LynxQueryInterfaceCommand.class);
        LynxModule.correlateStandardResponse(LynxGetModuleLEDColorCommand.class);
    }

    protected static class MessageClassAndCtor {
        public Class<? extends LynxMessage> clazz;
        public Constructor<? extends LynxMessage> ctor;

        protected MessageClassAndCtor() {
        }

        public void assignCtor() throws NoSuchMethodException {
            try {
                this.ctor = this.clazz.getConstructor(LynxModule.class);
            }
            catch (NoSuchMethodException ignored) {
                try {
                    this.ctor = this.clazz.getConstructor(LynxModuleIntf.class);
                }
                catch (NoSuchMethodException e) {
                    this.ctor = null;
                }
            }
        }
    }

    public static enum BulkCachingMode {
        OFF,
        MANUAL,
        AUTO;

    }

    public static interface BlinkerPolicy {
        public List<Blinker.Step> getIdlePattern(LynxModule var1);

        public List<Blinker.Step> getVisuallyIdentifyPattern(LynxModule var1);
    }

    public static enum DebugGroup {
        NONE(0),
        MAIN(1),
        TOHOST(2),
        FROMHOST(3),
        ADC(4),
        PWMSERVO(5),
        MODULELED(6),
        DIGITALIO(7),
        I2C(8),
        MOTOR0(9),
        MOTOR1(10),
        MOTOR2(11),
        MOTOR3(12);

        public final byte bVal;

        private DebugGroup(int b) {
            this.bVal = (byte)b;
        }

        public static DebugGroup fromInt(int b) {
            for (DebugGroup debugGroup : DebugGroup.values()) {
                if (debugGroup.bVal != (byte)b) continue;
                return debugGroup;
            }
            return NONE;
        }
    }

    public static enum DebugVerbosity {
        OFF(0),
        LOW(1),
        MEDIUM(2),
        HIGH(3);

        public final byte bVal;

        private DebugVerbosity(int b) {
            this.bVal = (byte)b;
        }

        public static DebugVerbosity fromInt(int b) {
            for (DebugVerbosity verbosity : DebugVerbosity.values()) {
                if (verbosity.bVal != (byte)b) continue;
                return verbosity;
            }
            return OFF;
        }
    }

    public static class BulkData {
        private final LynxGetBulkInputDataResponse resp;
        private final boolean fake;

        private BulkData(LynxGetBulkInputDataResponse resp, boolean fake) {
            this.resp = resp;
            this.fake = fake;
        }

        public boolean getDigitalChannelState(int digitalInputZ) {
            return this.resp.getDigitalInput(digitalInputZ);
        }

        public int getMotorCurrentPosition(int motorZ) {
            return this.resp.getEncoder(motorZ);
        }

        public int getMotorVelocity(int motorZ) {
            return this.resp.getVelocity(motorZ);
        }

        public boolean isMotorBusy(int motorZ) {
            return !this.resp.isAtTarget(motorZ);
        }

        public boolean isMotorOverCurrent(int motorZ) {
            return this.resp.isOverCurrent(motorZ);
        }

        public double getAnalogInputVoltage(int inputZ) {
            return this.getAnalogInputVoltage(inputZ, VoltageUnit.VOLTS);
        }

        public double getAnalogInputVoltage(int inputZ, VoltageUnit unit) {
            return unit.convert((double)this.resp.getAnalogInput(inputZ), VoltageUnit.MILLIVOLTS);
        }

        public boolean isFake() {
            return this.fake;
        }
    }

    public static class CountModuleAddressBlinkerPolicy
    extends BreathingBlinkerPolicy {
        @Override
        public List<Blinker.Step> getIdlePattern(LynxModule lynxModule) {
            ArrayList<Blinker.Step> steps = new ArrayList<Blinker.Step>();
            if (lynxModule.getModuleAddress() == 173) {
                steps.add(new Blinker.Step(-16711936, 1L, TimeUnit.SECONDS));
                return steps;
            }
            int msLivenessLong = 5000;
            int msLivenessShort = 500;
            steps.add(new Blinker.Step(-16711936, (long)(msLivenessLong - msLivenessShort), TimeUnit.MILLISECONDS));
            steps.add(new Blinker.Step(-16777216, (long)msLivenessShort, TimeUnit.MILLISECONDS));
            int slotsRemaining = 16 - steps.size();
            int blinkCount = Math.min(lynxModule.getModuleAddress(), slotsRemaining / 2);
            for (int i = 0; i < blinkCount; ++i) {
                steps.add(new Blinker.Step(-16776961, (long)msLivenessShort, TimeUnit.MILLISECONDS));
                steps.add(new Blinker.Step(-16777216, (long)msLivenessShort, TimeUnit.MILLISECONDS));
            }
            return steps;
        }
    }

    public static class BreathingBlinkerPolicy
    implements BlinkerPolicy {
        @Override
        public List<Blinker.Step> getIdlePattern(LynxModule lynxModule) {
            int iStep;
            float[] hsv = new float[]{0.0f, 0.0f, 0.0f};
            Color.colorToHSV((int)-16711681, (float[])hsv);
            final float hue = hsv[0];
            float saturation = 1.0f;
            int iStepLast = 8;
            int msIncrement = 125;
            final ArrayList<Blinker.Step> steps = new ArrayList<Blinker.Step>();
            Consumer<Integer> makeStep = new Consumer<Integer>(){

                public void accept(Integer iStep) {
                    float min = 0.05f;
                    float max = 1.0f;
                    float value = (float)iStep.intValue() / 8.0f * (max - min) + min;
                    value = 1.0f - (float)Math.sqrt(1.0f - value);
                    int color = Color.HSVToColor((float[])new float[]{hue, 1.0f, value});
                    steps.add(new Blinker.Step(color, 125L, TimeUnit.MILLISECONDS));
                }
            };
            for (iStep = 0; iStep <= 8; ++iStep) {
                makeStep.accept((Object)iStep);
            }
            for (iStep = 7; iStep > 0; --iStep) {
                makeStep.accept((Object)iStep);
            }
            return steps;
        }

        @Override
        public List<Blinker.Step> getVisuallyIdentifyPattern(LynxModule lynxModule) {
            ArrayList<Blinker.Step> steps = new ArrayList<Blinker.Step>();
            int msIncrement = 150;
            steps.add(new Blinker.Step(-16711681, (long)msIncrement, TimeUnit.MILLISECONDS));
            steps.add(new Blinker.Step(-16777216, (long)(msIncrement / 2), TimeUnit.MILLISECONDS));
            steps.add(new Blinker.Step(-65281, (long)msIncrement, TimeUnit.MILLISECONDS));
            steps.add(new Blinker.Step(-16777216, (long)(msIncrement / 2), TimeUnit.MILLISECONDS));
            return steps;
        }
    }
}

