/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx;

import android.content.Context;
import com.qualcomm.hardware.R;
import com.qualcomm.hardware.lynx.LynxController;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxNackException;
import com.qualcomm.hardware.lynx.LynxUsbUtil;
import com.qualcomm.hardware.lynx.commands.core.LynxGetPWMConfigurationCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetPWMConfigurationResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetPWMEnableCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetPWMEnableResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetPWMPulseWidthCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetPWMPulseWidthResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxSetPWMConfigurationCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxSetPWMEnableCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxSetPWMPulseWidthCommand;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.PWMOutputController;
import com.qualcomm.robotcore.hardware.PWMOutputControllerEx;
import com.qualcomm.robotcore.util.LastKnown;
import com.qualcomm.robotcore.util.SerialNumber;

@Deprecated
public class LynxPwmOutputController
extends LynxController
implements PWMOutputController,
PWMOutputControllerEx {
    public static final String TAG = "LynxPwmOutputController";
    public static final int apiPortFirst = 0;
    public static final int apiPortLast = 3;
    protected LastKnown<Integer>[] lastKnownOutputTimes = LastKnown.createArray((int)4);
    protected LastKnown<Integer>[] lastKnownPulseWidthPeriods = LastKnown.createArray((int)4);

    @Override
    protected String getTag() {
        return TAG;
    }

    public LynxPwmOutputController(Context context, LynxModule module) throws RobotCoreException, InterruptedException {
        super(context, module);
        this.finishConstruction();
    }

    @Override
    public void initializeHardware() {
        for (int port = 0; port <= 3; ++port) {
            this.setPwmDisable(port);
            this.internalSetPulseWidthPeriod(port - 0, 20000);
        }
    }

    @Override
    public void floatHardware() {
        for (int port = 0; port <= 3; ++port) {
            this.setPwmDisable(port);
        }
    }

    @Override
    public String getDeviceName() {
        return this.context.getString(R.string.lynxPwmOutputControllerDisplayName);
    }

    @Override
    public SerialNumber getSerialNumber() {
        return this.getModule().getSerialNumber();
    }

    public synchronized void setPulseWidthOutputTime(int port, int usDuration) {
        this.validatePort(port);
        this.internalSetPulseWidthOutputTime(port += 0, usDuration);
        this.setPwmEnable(port + 0);
    }

    void internalSetPulseWidthOutputTime(int portZ, int usDuration) {
        if (this.lastKnownOutputTimes[portZ].updateValue((Object)usDuration)) {
            LynxSetPWMPulseWidthCommand command = new LynxSetPWMPulseWidthCommand(this.getModule(), portZ, usDuration);
            try {
                command.send();
            }
            catch (LynxNackException | InterruptedException | RuntimeException e) {
                this.handleException(e);
            }
        }
    }

    public synchronized void setPulseWidthPeriod(int port, int usPeriod) {
        this.validatePort(port);
        this.internalSetPulseWidthPeriod(port += 0, usPeriod);
        this.setPwmEnable(port + 0);
    }

    void internalSetPulseWidthPeriod(int portZ, int usPeriod) {
        if (this.lastKnownOutputTimes[portZ].updateValue((Object)usPeriod)) {
            LynxSetPWMConfigurationCommand command = new LynxSetPWMConfigurationCommand(this.getModule(), portZ, usPeriod);
            try {
                command.send();
            }
            catch (LynxNackException | InterruptedException | RuntimeException e) {
                this.handleException(e);
            }
        }
    }

    public synchronized int getPulseWidthOutputTime(int port) {
        this.validatePort(port);
        LynxGetPWMPulseWidthCommand command = new LynxGetPWMPulseWidthCommand(this.getModule(), port += 0);
        try {
            LynxGetPWMPulseWidthResponse response = (LynxGetPWMPulseWidthResponse)command.sendReceive();
            return response.getPulseWidth();
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(0);
        }
    }

    public synchronized int getPulseWidthPeriod(int port) {
        this.validatePort(port);
        LynxGetPWMConfigurationCommand command = new LynxGetPWMConfigurationCommand(this.getModule(), port += 0);
        try {
            LynxGetPWMConfigurationResponse response = (LynxGetPWMConfigurationResponse)command.sendReceive();
            return response.getFramePeriod();
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(0);
        }
    }

    public synchronized void setPwmEnable(int port) {
        this.validatePort(port);
        this.internalSetPwmEnable(port += 0, true);
    }

    public synchronized void setPwmDisable(int port) {
        this.validatePort(port);
        this.internalSetPwmEnable(port += 0, false);
    }

    public synchronized boolean isPwmEnabled(int port) {
        this.validatePort(port);
        return this.internalGetPwmEnable(port += 0);
    }

    private void internalSetPwmEnable(int portZ, boolean enable) {
        LynxSetPWMEnableCommand command = new LynxSetPWMEnableCommand(this.getModule(), portZ, enable);
        try {
            command.send();
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
        }
    }

    private boolean internalGetPwmEnable(int portZ) {
        LynxGetPWMEnableCommand command = new LynxGetPWMEnableCommand(this.getModule(), portZ);
        try {
            LynxGetPWMEnableResponse response = (LynxGetPWMEnableResponse)command.sendReceive();
            return response.isEnabled();
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(true);
        }
    }

    private void validatePort(int port) {
        if (port < 0 || port > 3) {
            throw new IllegalArgumentException(String.format("port %d is invalid; valid ports are %d..%d", port, 0, 3));
        }
    }
}

