/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx;

import android.content.Context;
import androidx.annotation.NonNull;
import com.qualcomm.hardware.R;
import com.qualcomm.hardware.lynx.LynxController;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxNackException;
import com.qualcomm.hardware.lynx.LynxUsbUtil;
import com.qualcomm.hardware.lynx.commands.core.LynxGetServoEnableCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetServoEnableResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetServoPulseWidthCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetServoPulseWidthResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxSetServoConfigurationCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxSetServoEnableCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxSetServoPulseWidthCommand;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.PwmControl;
import com.qualcomm.robotcore.hardware.ServoController;
import com.qualcomm.robotcore.hardware.ServoControllerEx;
import com.qualcomm.robotcore.hardware.configuration.typecontainers.ServoConfigurationType;
import com.qualcomm.robotcore.util.LastKnown;
import com.qualcomm.robotcore.util.Range;

public class LynxServoController
extends LynxController
implements ServoController,
ServoControllerEx {
    public static final String TAG = "LynxServoController";
    public static final int apiServoFirst = 0;
    public static final int apiServoLast = 5;
    public static final double apiPositionFirst = 0.0;
    public static final double apiPositionLast = 1.0;
    protected final LastKnown<Double>[] lastKnownCommandedPosition = LastKnown.createArray((int)6);
    protected final LastKnown<Boolean>[] lastKnownEnabled = LastKnown.createArray((int)6);
    protected PwmControl.PwmRange[] pwmRanges = new PwmControl.PwmRange[6];
    protected PwmControl.PwmRange[] defaultPwmRanges = new PwmControl.PwmRange[6];

    @Override
    protected String getTag() {
        return TAG;
    }

    public LynxServoController(Context context, LynxModule module) throws RobotCoreException, InterruptedException {
        super(context, module);
        for (int i = 0; i < this.pwmRanges.length; ++i) {
            this.pwmRanges[i] = PwmControl.PwmRange.defaultRange;
            this.defaultPwmRanges[i] = PwmControl.PwmRange.defaultRange;
        }
        this.finishConstruction();
    }

    @Override
    public void initializeHardware() {
        for (int servo = 0; servo <= 5; ++servo) {
            this.pwmRanges[servo - 0] = null;
            this.setServoPwmRange(servo, this.defaultPwmRanges[servo - 0]);
        }
        this.floatHardware();
        this.forgetLastKnown();
    }

    @Override
    public void floatHardware() {
        this.pwmDisable();
    }

    @Override
    public void forgetLastKnown() {
        LastKnown.invalidateArray(this.lastKnownCommandedPosition);
        LastKnown.invalidateArray(this.lastKnownEnabled);
    }

    @Override
    public String getDeviceName() {
        return this.context.getString(R.string.lynxServoControllerDisplayName);
    }

    public synchronized void pwmEnable() {
        for (int servoZ = 0; servoZ < 6; ++servoZ) {
            this.internalSetPwmEnable(servoZ, true);
        }
    }

    public synchronized void pwmDisable() {
        for (int servoZ = 0; servoZ < 6; ++servoZ) {
            this.internalSetPwmEnable(servoZ, false);
        }
    }

    public synchronized ServoController.PwmStatus getPwmStatus() {
        Boolean enabled = null;
        for (int servoZ = 0; servoZ < 6; ++servoZ) {
            boolean localEnabled = this.internalGetPwmEnable(servoZ);
            if (enabled == null) {
                enabled = localEnabled;
                continue;
            }
            if (enabled == localEnabled) continue;
            return ServoController.PwmStatus.MIXED;
        }
        return enabled != false ? ServoController.PwmStatus.ENABLED : ServoController.PwmStatus.DISABLED;
    }

    public synchronized void setServoPwmEnable(int servo) {
        this.validateServo(servo);
        this.internalSetPwmEnable(servo += 0, true);
    }

    public synchronized void setServoPwmDisable(int servo) {
        this.validateServo(servo);
        this.internalSetPwmEnable(servo += 0, false);
    }

    public synchronized boolean isServoPwmEnabled(int servo) {
        this.validateServo(servo);
        return this.internalGetPwmEnable(servo += 0);
    }

    public void setServoType(int servo, ServoConfigurationType servoType) {
        PwmControl.PwmRange newDefaultPwmRange;
        this.validateServo(servo);
        this.defaultPwmRanges[servo += 0] = newDefaultPwmRange = new PwmControl.PwmRange(servoType.getUsPulseLower(), servoType.getUsPulseUpper(), servoType.getUsFrame());
        this.setServoPwmRange(servo, newDefaultPwmRange);
    }

    private void internalSetPwmEnable(int servoZ, boolean enable) {
        if (this.lastKnownEnabled[servoZ].updateValue((Object)enable)) {
            if (!enable) {
                this.lastKnownCommandedPosition[servoZ].invalidate();
            }
            LynxSetServoEnableCommand command = new LynxSetServoEnableCommand(this.getModule(), servoZ, enable);
            try {
                command.send();
            }
            catch (LynxNackException | InterruptedException | RuntimeException e) {
                this.handleException(e);
            }
        }
    }

    private boolean internalGetPwmEnable(int servoZ) {
        Boolean result = (Boolean)this.lastKnownEnabled[servoZ].getValue();
        if (result != null) {
            return result;
        }
        LynxGetServoEnableCommand command = new LynxGetServoEnableCommand(this.getModule(), servoZ);
        try {
            LynxGetServoEnableResponse response = (LynxGetServoEnableResponse)command.sendReceive();
            result = response.isEnabled();
            this.lastKnownEnabled[servoZ].setValue((Object)result);
            return result;
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(true);
        }
    }

    public synchronized void setServoPosition(int servo, double position) {
        this.validateServo(servo);
        this.validateApiServoPosition(position);
        if (this.lastKnownCommandedPosition[servo += 0].updateValue((Object)position)) {
            double pwm = Range.scale((double)position, (double)0.0, (double)1.0, (double)this.pwmRanges[servo].usPulseLower, (double)this.pwmRanges[servo].usPulseUpper);
            pwm = Range.clip((double)pwm, (double)1.0, (double)65535.0);
            LynxSetServoPulseWidthCommand command = new LynxSetServoPulseWidthCommand(this.getModule(), servo, (int)pwm);
            try {
                command.send();
            }
            catch (LynxNackException | InterruptedException | RuntimeException e) {
                this.handleException(e);
            }
            this.internalSetPwmEnable(servo, true);
        }
    }

    public synchronized double getServoPosition(int servo) {
        this.validateServo(servo);
        Double result = (Double)this.lastKnownCommandedPosition[servo += 0].getValue();
        if (result != null) {
            return result;
        }
        LynxGetServoPulseWidthCommand command = new LynxGetServoPulseWidthCommand(this.getModule(), servo);
        try {
            LynxGetServoPulseWidthResponse response = (LynxGetServoPulseWidthResponse)command.sendReceive();
            result = Range.scale((double)response.getPulseWidth(), (double)this.pwmRanges[servo].usPulseLower, (double)this.pwmRanges[servo].usPulseUpper, (double)0.0, (double)1.0);
            result = Range.clip((double)result, (double)0.0, (double)1.0);
            this.lastKnownCommandedPosition[servo].setValue((Object)result);
            return result;
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(0.0);
        }
    }

    public synchronized void setServoPwmRange(int servo, @NonNull PwmControl.PwmRange range) {
        this.validateServo(servo);
        if (!range.equals((Object)this.pwmRanges[servo += 0])) {
            this.pwmRanges[servo] = range;
            LynxSetServoConfigurationCommand command = new LynxSetServoConfigurationCommand(this.getModule(), servo, (int)range.usFrame);
            try {
                command.send();
            }
            catch (LynxNackException | InterruptedException | RuntimeException e) {
                this.handleException(e);
            }
        }
    }

    @NonNull
    public synchronized PwmControl.PwmRange getServoPwmRange(int servo) {
        this.validateServo(servo);
        return this.pwmRanges[servo += 0];
    }

    private void validateServo(int servo) {
        if (servo < 0 || servo > 5) {
            throw new IllegalArgumentException(String.format("Servo %d is invalid; valid servos are %d..%d", servo, 0, 5));
        }
    }

    private void validateApiServoPosition(double position) {
        if (!(0.0 <= position) || !(position <= 1.0)) {
            throw new IllegalArgumentException(String.format("illegal servo position %f; must be in interval [%f,%f]", position, 0.0, 1.0));
        }
    }
}

