/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx;

import androidx.annotation.NonNull;
import com.qualcomm.hardware.lynx.LynxUsbDeviceImpl;
import com.qualcomm.hardware.lynx.commands.LynxMessage;
import com.qualcomm.hardware.lynx.commands.standard.LynxKeepAliveCommand;
import com.qualcomm.robotcore.eventloop.opmode.OpModeManagerImpl;
import com.qualcomm.robotcore.util.RobotLog;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MessageKeyedLock {
    private final String name;
    private final Lock lock;
    private final Lock acquisitionsLock = new ReentrantLock(true);
    private volatile boolean tryingToHangAcquisitions = false;
    private volatile boolean throwOnAcquisitionAttempt;
    private final Condition condition;
    private volatile LynxMessage lockOwner;
    private int lockCount;
    private long lockAquisitionTime;
    private long nanoLockAquisitionTimeMax;

    public MessageKeyedLock(String name) {
        this(name, 500);
    }

    public MessageKeyedLock(String name, int msAquisitionTimeout) {
        this.lock = new ReentrantLock();
        this.name = name;
        this.condition = this.lock.newCondition();
        this.lockOwner = null;
        this.lockCount = 0;
        this.lockAquisitionTime = 0L;
        this.nanoLockAquisitionTimeMax = (long)msAquisitionTimeout * 1000000L;
    }

    private void logv(String format, Object ... args) {
        RobotLog.v((String)"%s: %s", (Object[])new Object[]{this.name, String.format(format, args)});
    }

    private void loge(String format, Object ... args) {
        RobotLog.e((String)"%s: %s", (Object[])new Object[]{this.name, String.format(format, args)});
    }

    public void reset() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            this.lockOwner = null;
            this.lockCount = 0;
            this.lockAquisitionTime = 0L;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(@NonNull LynxMessage message) throws InterruptedException {
        if (message == null) {
            throw new IllegalArgumentException("MessageKeyedLock.acquire: null message");
        }
        if (this.throwOnAcquisitionAttempt && !(message instanceof LynxKeepAliveCommand)) {
            throw new OpModeManagerImpl.ForceStopException();
        }
        if (this.tryingToHangAcquisitions) {
            this.acquisitionsLock.lock();
        } else {
            this.acquisitionsLock.lockInterruptibly();
        }
        try {
            this.lock.lockInterruptibly();
        }
        catch (Exception e) {
            this.acquisitionsLock.unlock();
            throw e;
        }
        try {
            if (this.lockOwner != message) {
                while (this.lockOwner != null) {
                    long now = System.nanoTime();
                    if (now - this.lockAquisitionTime > this.nanoLockAquisitionTimeMax) {
                        this.loge("#### abandoning lock: old=%s(%d)", this.lockOwner.getClass().getSimpleName(), this.lockOwner.getMessageNumber());
                        this.loge("                      new=%s(%d)", message.getClass().getSimpleName(), message.getMessageNumber());
                        break;
                    }
                    this.condition.await(this.nanoLockAquisitionTimeMax / 4L, TimeUnit.NANOSECONDS);
                }
                this.lockCount = 0;
                this.lockAquisitionTime = System.nanoTime();
                this.lockOwner = message;
                if (LynxUsbDeviceImpl.DEBUG_LOG_DATAGRAMS_LOCK) {
                    this.logv("lock %s msg#=%d", this.lockOwner.getClass().getSimpleName(), this.lockOwner.getMessageNumber());
                }
            } else {
                this.logv("lock recursively acquired", new Object[0]);
            }
            ++this.lockCount;
        }
        finally {
            this.lock.unlock();
            this.acquisitionsLock.unlock();
        }
    }

    public void release(@NonNull LynxMessage message) throws InterruptedException {
        if (message == null) {
            throw new IllegalArgumentException("MessageKeyedLock.release: null message");
        }
        this.lock.lockInterruptibly();
        try {
            if (this.lockOwner == message) {
                if (--this.lockCount == 0) {
                    if (LynxUsbDeviceImpl.DEBUG_LOG_DATAGRAMS_LOCK) {
                        this.logv("unlock %s msg#=%d", this.lockOwner.getClass().getSimpleName(), this.lockOwner.getMessageNumber());
                    }
                    this.lockOwner = null;
                    this.condition.signalAll();
                } else {
                    this.logv("lock recursively released", new Object[0]);
                }
            } else if (this.lockOwner != null) {
                this.loge("#### incorrect owner releasing message keyed lock: ignored: old=%s(%d:%d)", this.lockOwner.getClass().getSimpleName(), this.lockOwner.getModuleAddress(), this.lockOwner.getMessageNumber());
                this.loge("                                                            new=%s(%d:%d)", message.getClass().getSimpleName(), message.getModuleAddress(), message.getMessageNumber());
            } else {
                this.loge("#### releasing ownerless message keyed lock: ignored: %s", message.getClass().getSimpleName());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void lockAcquisitions() {
        if (LynxUsbDeviceImpl.DEBUG_LOG_DATAGRAMS_LOCK) {
            this.logv("***ALL FUTURE ACQUISITION ATTEMPTS FROM THREADS OTHER THAN %s WILL NOW HANG!***", Thread.currentThread().getName());
        }
        this.acquisitionsLock.lock();
        this.tryingToHangAcquisitions = true;
    }

    public void throwOnLockAcquisitions(boolean shouldthrow) {
        this.throwOnAcquisitionAttempt = shouldthrow;
    }
}

