/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.qualcomm.hardware.lynx.LynxUnsupportedCommandException;
import com.qualcomm.hardware.lynx.commands.LynxMessage;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.util.TypeConversion;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.firstinspires.ftc.robotcore.internal.hardware.TimeWindow;

public class LynxDatagram {
    public static final ByteOrder LYNX_ENDIAN = ByteOrder.LITTLE_ENDIAN;
    public static final int cbFrameBytesAndPacketLength = 4;
    public static final byte[] frameBytes = new byte[]{68, 75};
    private short packetLength;
    private byte destModuleAddress = 0;
    private byte sourceModuleAddress = 0;
    private byte messageNumber = 0;
    private byte referenceNumber = 0;
    private short packetId = 0;
    private byte[] payloadData = new byte[0];
    private byte checksum;
    @Nullable
    private TimeWindow payloadTimeWindow;

    public static boolean beginsWithFraming(byte[] data) {
        return data.length >= frameBytes.length && data[0] == frameBytes[0] && data[1] == frameBytes[1];
    }

    public static boolean beginsWithFraming(ByteBuffer buffer) {
        return buffer.get() == frameBytes[0] && buffer.get() == frameBytes[1];
    }

    public LynxDatagram() {
    }

    public LynxDatagram(LynxMessage command) throws LynxUnsupportedCommandException {
        this();
        int commandNumber = command.getCommandNumber();
        command.getModule().validateCommand(command);
        this.setDestModuleAddress(command.getDestModuleAddress());
        this.setMessageNumber(command.getMessageNumber());
        this.setReferenceNumber(command.getReferenceNumber());
        this.setPacketId(commandNumber);
        this.setPayloadData(command.toPayloadByteArray());
    }

    public void setPayloadTimeWindow(TimeWindow payloadTimeWindow) {
        this.payloadTimeWindow = payloadTimeWindow;
    }

    @NonNull
    public TimeWindow getPayloadTimeWindow() {
        return this.payloadTimeWindow == null ? new TimeWindow() : this.payloadTimeWindow;
    }

    public int getPacketLength() {
        return TypeConversion.unsignedShortToInt((short)this.packetLength);
    }

    public void setPacketLength(int value) {
        this.packetLength = (byte)value;
    }

    public static int getFixedPacketLength() {
        return 11;
    }

    public int updatePacketLength() {
        int cb = LynxDatagram.getFixedPacketLength() + this.payloadData.length;
        this.setPacketLength(cb);
        return cb;
    }

    public int getDestModuleAddress() {
        return TypeConversion.unsignedByteToInt((byte)this.destModuleAddress);
    }

    public void setDestModuleAddress(int value) {
        this.destModuleAddress = (byte)value;
    }

    public int getSourceModuleAddress() {
        return TypeConversion.unsignedByteToInt((byte)this.sourceModuleAddress);
    }

    public void setSourceModuleAddress(int value) {
        this.sourceModuleAddress = (byte)value;
    }

    public int getMessageNumber() {
        return TypeConversion.unsignedByteToInt((byte)this.messageNumber);
    }

    public void setMessageNumber(int value) {
        this.messageNumber = (byte)value;
    }

    public int getReferenceNumber() {
        return TypeConversion.unsignedByteToInt((byte)this.referenceNumber);
    }

    public void setReferenceNumber(int value) {
        this.referenceNumber = (byte)value;
    }

    public int getPacketId() {
        return TypeConversion.unsignedShortToInt((short)this.packetId);
    }

    public void setPacketId(int value) {
        this.packetId = (short)value;
    }

    public boolean isResponse() {
        return this.getPacketId() >= 32768;
    }

    public int getCommandNumber() {
        return this.getPacketId() & 0xFFFF7FFF;
    }

    public byte[] getPayloadData() {
        return this.payloadData;
    }

    public void setPayloadData(byte[] data) {
        this.payloadData = data;
    }

    public int getChecksum() {
        return TypeConversion.unsignedByteToInt((byte)this.checksum);
    }

    public void setChecksum(int value) {
        this.checksum = (byte)value;
    }

    public byte computeChecksum() {
        byte result = 0;
        result = LynxDatagram.checksumBytes(result, frameBytes);
        result = LynxDatagram.checksumBytes(result, TypeConversion.shortToByteArray((short)this.packetLength, (ByteOrder)LYNX_ENDIAN));
        result = (byte)(result + this.destModuleAddress);
        result = (byte)(result + this.sourceModuleAddress);
        result = (byte)(result + this.messageNumber);
        result = (byte)(result + this.referenceNumber);
        result = LynxDatagram.checksumBytes(result, TypeConversion.shortToByteArray((short)this.packetId, (ByteOrder)LYNX_ENDIAN));
        result = LynxDatagram.checksumBytes(result, this.payloadData);
        return result;
    }

    private static byte checksumBytes(byte result, byte[] data) {
        for (int ib = 0; ib < data.length; ++ib) {
            result = (byte)(result + data[ib]);
        }
        return result;
    }

    public boolean isChecksumValid() {
        return this.checksum == this.computeChecksum();
    }

    public byte[] toByteArray() {
        int cb = this.updatePacketLength();
        this.setChecksum(this.computeChecksum());
        ByteBuffer buffer = ByteBuffer.allocate(cb);
        buffer.order(LYNX_ENDIAN);
        buffer.put(frameBytes);
        buffer.putShort(this.packetLength);
        buffer.put(this.destModuleAddress);
        buffer.put(this.sourceModuleAddress);
        buffer.put(this.messageNumber);
        buffer.put(this.referenceNumber);
        buffer.putShort(this.packetId);
        buffer.put(this.payloadData);
        buffer.put(this.checksum);
        return buffer.array();
    }

    public void fromByteArray(byte[] byteArray) throws RobotCoreException {
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        buffer.order(LYNX_ENDIAN);
        try {
            if (!LynxDatagram.beginsWithFraming(buffer)) {
                throw this.illegalDatagram();
            }
            this.packetLength = buffer.getShort();
            this.destModuleAddress = buffer.get();
            this.sourceModuleAddress = buffer.get();
            this.messageNumber = buffer.get();
            this.referenceNumber = buffer.get();
            this.packetId = buffer.getShort();
            int cbPayload = this.getPacketLength() - LynxDatagram.getFixedPacketLength();
            this.payloadData = new byte[cbPayload];
            buffer.get(this.payloadData);
            this.checksum = buffer.get();
        }
        catch (BufferUnderflowException e) {
            throw RobotCoreException.createChained((Exception)e, (String)"Lynx datagram buffer underflow", (Object[])new Object[0]);
        }
    }

    private RobotCoreException illegalDatagram() {
        return new RobotCoreException("illegal Lynx datagram format");
    }
}

