/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands;

import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.commands.LynxCommand;
import com.qualcomm.hardware.lynx.commands.LynxInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.LynxInterfaceResponse;
import com.qualcomm.hardware.lynx.commands.LynxResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.firstinspires.ftc.robotcore.internal.system.Assert;

public class LynxInterface {
    public static final int ERRONEOUS_COMMAND_NUMBER = 0;
    public static final int ERRONEOUS_INDEX = 0;
    private String interfaceName;
    private Integer baseCommandNumber = 0;
    private Class<? extends LynxInterfaceCommand>[] commands;
    private Map<Class<? extends LynxInterfaceCommand>, Integer> commandIndices;
    private Map<Class<? extends LynxInterfaceResponse>, Integer> responseIndices;
    private boolean wasNacked;

    public LynxInterface(String interfaceName, Class<? extends LynxInterfaceCommand> ... commands) {
        this.interfaceName = interfaceName;
        this.commands = commands;
        this.commandIndices = new HashMap<Class<? extends LynxInterfaceCommand>, Integer>();
        this.responseIndices = new HashMap<Class<? extends LynxInterfaceResponse>, Integer>();
        this.wasNacked = false;
        for (int i = 0; i < this.commands.length; ++i) {
            Class<? extends LynxInterfaceCommand> commandClass = this.commands[i];
            if (commandClass == null) continue;
            this.commandIndices.put(commandClass, i);
            try {
                Class<LynxResponse> responseClass = LynxCommand.getResponseClass(commandClass);
                Assert.assertTrue((responseClass != null ? 1 : 0) != 0);
                this.responseIndices.put(responseClass, i);
                LynxModule.correlateResponse(commandClass, responseClass);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public int getCommandCount() {
        return this.commands.length;
    }

    public void setBaseCommandNumber(Integer baseCommandNumber) {
        this.baseCommandNumber = baseCommandNumber;
    }

    public void setWasNacked(boolean nacked) {
        this.wasNacked = nacked;
    }

    public boolean wasNacked() {
        return this.wasNacked;
    }

    public Integer getBaseCommandNumber() {
        return this.baseCommandNumber;
    }

    public int getCommandIndex(Class<? extends LynxInterfaceCommand> clazz) {
        return this.commandIndices.get(clazz);
    }

    public int getResponseIndex(Class<? extends LynxInterfaceResponse> clazz) {
        return this.responseIndices.get(clazz);
    }

    public List<Class<? extends LynxInterfaceCommand>> getCommandClasses() {
        return Arrays.asList(this.commands);
    }
}

