/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.LynxModuleWarningManager;
import com.qualcomm.hardware.lynx.LynxNackException;
import com.qualcomm.hardware.lynx.LynxUnsupportedCommandException;
import com.qualcomm.hardware.lynx.commands.LynxMessage;
import com.qualcomm.hardware.lynx.commands.standard.LynxAck;
import com.qualcomm.hardware.lynx.commands.standard.LynxNack;
import com.qualcomm.robotcore.util.RobotLog;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.firstinspires.ftc.robotcore.internal.hardware.TimeWindow;

public abstract class LynxRespondable<RESPONSE extends LynxMessage>
extends LynxMessage {
    private volatile boolean isAckOrResponseReceived = false;
    private volatile LynxNack nackReceived = null;
    private volatile RESPONSE response = null;
    private final CountDownLatch ackOrNackReceived = new CountDownLatch(1);
    private final CountDownLatch responseOrNackReceived = new CountDownLatch(1);
    @Nullable
    private final RESPONSE defaultResponse;

    public LynxRespondable(LynxModuleIntf module) {
        super(module);
        this.defaultResponse = null;
    }

    public LynxRespondable(LynxModuleIntf module, @NonNull RESPONSE defaultResponse) {
        super(module);
        this.defaultResponse = defaultResponse;
        ((LynxMessage)this.defaultResponse).setPayloadTimeWindow(new TimeWindow());
    }

    @Override
    public void onPretendTransmit() throws InterruptedException {
        super.onPretendTransmit();
        this.pretendFinish();
    }

    public boolean hasBeenAcknowledged() {
        return this.isAckOrResponseReceived() || this.isNackReceived();
    }

    public boolean isAckOrResponseReceived() {
        return this.isAckOrResponseReceived;
    }

    public boolean isNackReceived() {
        return this.nackReceived != null;
    }

    public LynxNack getNackReceived() {
        return this.nackReceived;
    }

    @Override
    public boolean isAckable() {
        return true;
    }

    @Override
    public final boolean isResponseExpected() {
        return this.defaultResponse != null;
    }

    public void pretendFinish() throws InterruptedException {
        this.isAckOrResponseReceived = true;
        if (this.isResponseExpected()) {
            this.response = this.defaultResponse;
            this.onResponseReceived();
        }
        if (this.module != null) {
            this.module.finishedWithMessage(this);
        }
        this.ackOrNackReceived.countDown();
    }

    public void onAckReceived(LynxAck ack) {
        if (!this.isAckOrResponseReceived) {
            this.isAckOrResponseReceived = true;
            this.setAttentionRequired(ack.isAttentionRequired());
            this.ackOrNackReceived.countDown();
        }
    }

    protected void setAttentionRequired(boolean attentionRequired) {
        this.module.setAttentionRequired(attentionRequired);
    }

    public void onResponseReceived(LynxMessage response) {
        this.response = response;
        this.onResponseReceived();
    }

    private void onResponseReceived() {
        if (this.isResponseExpected()) {
            this.isAckOrResponseReceived = true;
            this.responseOrNackReceived.countDown();
        } else {
            RobotLog.e((String)"internal error: unexpected response received for msg#=%d", (Object[])new Object[]{this.getMessageNumber()});
        }
    }

    public void onNackReceived(LynxNack nack) {
        switch (nack.getNackReasonCodeAsEnum()) {
            case COMMAND_IMPL_PENDING: 
            case I2C_NO_RESULTS_PENDING: 
            case I2C_OPERATION_IN_PROGRESS: 
            case ABANDONED_WAITING_FOR_ACK: 
            case ABANDONED_WAITING_FOR_RESPONSE: 
            case BATTERY_TOO_LOW_TO_RUN_MOTOR: 
            case BATTERY_TOO_LOW_TO_RUN_SERVO: {
                break;
            }
            default: {
                RobotLog.v((String)"nack rec'd mod=%d msg#=%d ref#=%d reason=%s:%d", (Object[])new Object[]{this.getModuleAddress(), this.getMessageNumber(), this.getReferenceNumber(), nack.getNackReasonCode().toString(), nack.getNackReasonCode().getValue()});
            }
        }
        this.nackReceived = nack;
        this.ackOrNackReceived.countDown();
        this.responseOrNackReceived.countDown();
    }

    public void send() throws InterruptedException, LynxNackException {
        if (this.ackOrNackReceived.getCount() == 0L || this.responseOrNackReceived.getCount() == 0L) {
            throw new RuntimeException("A LynxRespondable can only be sent once");
        }
        this.acquireNetworkLock();
        try {
            try {
                this.module.sendCommand(this);
            }
            catch (LynxUnsupportedCommandException e) {
                this.throwNackForUnsupportedCommand(e);
            }
            this.awaitAckResponseOrNack();
            this.throwIfNack();
        }
        finally {
            this.releaseNetworkLock();
        }
    }

    public RESPONSE sendReceive() throws InterruptedException, LynxNackException {
        if (this.ackOrNackReceived.getCount() == 0L || this.responseOrNackReceived.getCount() == 0L) {
            throw new RuntimeException("A LynxRespondable can only be sent once");
        }
        this.acquireNetworkLock();
        try {
            this.module.sendCommand(this);
            this.awaitAckResponseOrNack();
            RESPONSE RESPONSE = this.responseOrThrow();
            return RESPONSE;
        }
        catch (LynxNackException e) {
            if (e.getNack().getNackReasonCode().isUnsupportedReason() && this.usePretendResponseIfRealModuleDoesntSupport() && this.defaultResponse != null) {
                RESPONSE RESPONSE = this.defaultResponse;
                return RESPONSE;
            }
            throw e;
        }
        catch (LynxUnsupportedCommandException e) {
            if (this.usePretendResponseIfRealModuleDoesntSupport() && this.defaultResponse != null) {
                RESPONSE RESPONSE = this.defaultResponse;
                return RESPONSE;
            }
            this.throwNackForUnsupportedCommand(e);
            RESPONSE RESPONSE = null;
            return RESPONSE;
        }
        finally {
            this.releaseNetworkLock();
        }
    }

    protected boolean usePretendResponseIfRealModuleDoesntSupport() {
        return false;
    }

    protected void throwNackForUnsupportedCommand(LynxUnsupportedCommandException e) throws LynxNackException {
        this.nackReceived = new LynxNack(this.getModule(), LynxNack.StandardReasonCode.PACKET_TYPE_ID_UNKNOWN);
        throw new LynxNackException(this, "%s: command %s(#0x%04x) not supported by mod#=%d", this.getClass().getSimpleName(), e.getClazz().getSimpleName(), e.getCommandNumber(), this.getModuleAddress());
    }

    protected RESPONSE responseOrThrow() throws LynxNackException {
        if (this.isNackReceived()) {
            throw new LynxNackException(this, "%s: nack received: %s:%d", this.getClass().getSimpleName(), this.nackReceived.getNackReasonCode().toString(), this.nackReceived.getNackReasonCode().getValue());
        }
        return this.response;
    }

    protected void throwIfNack() throws LynxNackException {
        if (this.isNackReceived()) {
            throw new LynxNackException(this, "%s: nack received: %s:%d", this.getClass().getSimpleName(), this.nackReceived.getNackReasonCode().toString(), this.nackReceived.getNackReasonCode().getValue());
        }
    }

    protected int getMsAwaitInterval() {
        return 250;
    }

    protected int getMsRetransmissionInterval() {
        return 100;
    }

    protected void awaitAndRetransmit(CountDownLatch latch, LynxNack.ReasonCode nackCode, String message) throws InterruptedException {
        long nsDeadline = System.nanoTime() + (long)this.getMsAwaitInterval() * 1000000L;
        int msWaitInterval = this.getMsAwaitInterval();
        int msRetransmit = this.getMsRetransmissionInterval();
        if (this.module.isNotResponding()) {
            if (this.module instanceof LynxModule && this.module.isOpen()) {
                LynxModuleWarningManager.getInstance().reportModuleUnresponsive((LynxModule)this.module);
            }
            this.onNackReceived(new LynxNack(this.module, nackCode));
            this.module.finishedWithMessage(this);
            return;
        }
        while (true) {
            long nsRemaining;
            if ((nsRemaining = nsDeadline - System.nanoTime()) <= 0L) {
                this.onNackReceived(new LynxNack(this.module, nackCode));
                if (this.module instanceof LynxModule && this.module.isOpen()) {
                    RobotLog.ee((String)"LynxModule", (String)"timeout: abandoning waiting %dms for %s: cmd=%s mod=%d msg#=%d", (Object[])new Object[]{msWaitInterval, message, this.getClass().getSimpleName(), this.getModuleAddress(), this.getMessageNumber()});
                    RobotLog.ee((String)"LynxModule", (String)"Marking module #%d as unresponsive until we receive some data back", (Object[])new Object[]{this.getModuleAddress()});
                    LynxModuleWarningManager.getInstance().reportModuleUnresponsive((LynxModule)this.module);
                }
                this.module.noteNotResponding();
                this.module.finishedWithMessage(this);
                return;
            }
            int msRemaining = (int)(nsRemaining / 1000000L);
            int msWait = Math.min(msRemaining, msRetransmit);
            if (latch.await(msWait, TimeUnit.MILLISECONDS)) {
                return;
            }
            this.module.retransmit(this);
        }
    }

    protected void awaitAckResponseOrNack() throws InterruptedException {
        if (this.isResponseExpected()) {
            this.awaitAndRetransmit(this.responseOrNackReceived, LynxNack.StandardReasonCode.ABANDONED_WAITING_FOR_RESPONSE, "response");
        } else {
            this.awaitAndRetransmit(this.ackOrNackReceived, LynxNack.StandardReasonCode.ABANDONED_WAITING_FOR_ACK, "ack");
        }
    }
}

