/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.LynxInterfaceResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetADCResponse;
import java.nio.ByteBuffer;

public class LynxGetADCCommand
extends LynxDekaInterfaceCommand<LynxGetADCResponse> {
    private static final int cbPayload = 2;
    private byte channel;
    private byte mode;

    public LynxGetADCCommand(LynxModuleIntf module) {
        super(module, new LynxGetADCResponse(module));
    }

    public LynxGetADCCommand(LynxModuleIntf module, Channel channel, Mode mode) {
        this(module);
        this.channel = channel.bVal;
        this.mode = mode.bVal;
    }

    public static Class<? extends LynxInterfaceResponse> getResponseClass() {
        return LynxGetADCResponse.class;
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(2).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.channel);
        buffer.put(this.mode);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.channel = buffer.get();
        this.mode = buffer.get();
    }

    @Override
    public boolean isDangerous() {
        return false;
    }

    public static enum Channel {
        USER0(0),
        USER1(1),
        USER2(2),
        USER3(3),
        GPIO_CURRENT(4),
        I2C_BUS_CURRENT(5),
        SERVO_CURRENT(6),
        BATTERY_CURRENT(7),
        MOTOR0_CURRENT(8),
        MOTOR1_CURRENT(9),
        MOTOR2_CURRENT(10),
        MOTOR3_CURRENT(11),
        FIVE_VOLT_MONITOR(12),
        BATTERY_MONITOR(13),
        CONTROLLER_TEMPERATURE(14);

        public final byte bVal;

        private Channel(int bVal) {
            this.bVal = (byte)bVal;
        }

        public static Channel motorCurrent(int port) {
            switch (port) {
                case 0: {
                    return MOTOR0_CURRENT;
                }
                case 1: {
                    return MOTOR1_CURRENT;
                }
                case 2: {
                    return MOTOR2_CURRENT;
                }
                case 3: {
                    return MOTOR3_CURRENT;
                }
            }
            throw new IllegalArgumentException(String.format("illegal motor port %d", port));
        }

        public static Channel user(int port) {
            switch (port) {
                case 0: {
                    return USER0;
                }
                case 1: {
                    return USER1;
                }
                case 2: {
                    return USER2;
                }
                case 3: {
                    return USER3;
                }
            }
            throw new IllegalArgumentException(String.format("illegal user port %d", port));
        }
    }

    public static enum Mode {
        ENGINEERING(0),
        RAW(1);

        public final byte bVal;

        private Mode(int bVal) {
            this.bVal = (byte)bVal;
        }
    }
}

