/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceResponse;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import com.qualcomm.robotcore.util.TypeConversion;
import java.nio.ByteBuffer;

public class LynxGetBulkInputDataResponse
extends LynxDekaInterfaceResponse {
    public final int cbPayload = 34;
    byte digitalInputs = 0;
    int[] encoders = new int[4];
    byte motorStatus = 0;
    short[] velocities = new short[4];
    short[] analogInputs = new short[4];

    public LynxGetBulkInputDataResponse(LynxModuleIntf module) {
        super(module);
    }

    public boolean getDigitalInput(int digitalInputZ) {
        LynxConstants.validateDigitalIOZ((int)digitalInputZ);
        int bit = 1 << digitalInputZ;
        return (this.digitalInputs & bit) != 0;
    }

    public int getAllDigitalInputs() {
        return TypeConversion.unsignedByteToInt((byte)this.digitalInputs);
    }

    public int getEncoder(int motorZ) {
        LynxConstants.validateMotorZ((int)motorZ);
        return this.encoders[motorZ];
    }

    public int getVelocity(int motorZ) {
        LynxConstants.validateMotorZ((int)motorZ);
        return this.velocities[motorZ];
    }

    public int getMotorStatus() {
        return TypeConversion.unsignedByteToInt((byte)this.motorStatus);
    }

    public boolean isAtTarget(int motorZ) {
        LynxConstants.validateMotorZ((int)motorZ);
        int bit = 1 << motorZ + 4;
        return (this.motorStatus & bit) != 0;
    }

    public boolean isOverCurrent(int motorZ) {
        LynxConstants.validateMotorZ((int)motorZ);
        int bit = 1 << motorZ;
        return (this.motorStatus & bit) != 0;
    }

    public int getAnalogInput(int inputZ) {
        LynxConstants.validateAnalogInputZ((int)inputZ);
        return this.analogInputs[inputZ];
    }

    @Override
    public byte[] toPayloadByteArray() {
        int i;
        ByteBuffer buffer = ByteBuffer.allocate(34).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.digitalInputs);
        for (i = 0; i < this.encoders.length; ++i) {
            buffer.putInt(this.encoders[i]);
        }
        buffer.put(this.motorStatus);
        for (i = 0; i < this.velocities.length; ++i) {
            buffer.putShort(this.velocities[i]);
        }
        for (i = 0; i < this.analogInputs.length; ++i) {
            buffer.putShort(this.analogInputs[i]);
        }
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        int i;
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.digitalInputs = buffer.get();
        for (i = 0; i < this.encoders.length; ++i) {
            this.encoders[i] = buffer.getInt();
        }
        this.motorStatus = buffer.get();
        for (i = 0; i < this.velocities.length; ++i) {
            this.velocities[i] = buffer.getShort();
        }
        for (i = 0; i < this.analogInputs.length; ++i) {
            this.analogInputs[i] = buffer.getShort();
        }
    }
}

