/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.LynxInterfaceResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetDIODirectionResponse;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import java.nio.ByteBuffer;

public class LynxGetDIODirectionCommand
extends LynxDekaInterfaceCommand<LynxGetDIODirectionResponse> {
    private static final int cbPayload = 1;
    private int pin;

    public LynxGetDIODirectionCommand(LynxModuleIntf module) {
        super(module, new LynxGetDIODirectionResponse(module));
    }

    public LynxGetDIODirectionCommand(LynxModuleIntf module, int pin) {
        this(module);
        LynxConstants.validateDigitalIOZ((int)pin);
        this.pin = pin;
    }

    public static Class<? extends LynxInterfaceResponse> getResponseClass() {
        return LynxGetDIODirectionResponse.class;
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(1).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put((byte)this.pin);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.pin = buffer.get();
    }

    @Override
    public boolean isDangerous() {
        return false;
    }
}

