/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.LynxInterfaceResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorPIDFControlLoopCoefficientsResponse;
import com.qualcomm.robotcore.hardware.DcMotor;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import java.nio.ByteBuffer;

public class LynxGetMotorPIDFControlLoopCoefficientsCommand
extends LynxDekaInterfaceCommand<LynxGetMotorPIDFControlLoopCoefficientsResponse> {
    private static final int cbPayload = 2;
    private byte motor;
    private byte mode;

    public LynxGetMotorPIDFControlLoopCoefficientsCommand(LynxModuleIntf module) {
        this(module, 0, DcMotor.RunMode.RUN_USING_ENCODER);
    }

    public LynxGetMotorPIDFControlLoopCoefficientsCommand(LynxModuleIntf module, int motorZ, DcMotor.RunMode mode) {
        super(module, new LynxGetMotorPIDFControlLoopCoefficientsResponse(module));
        LynxConstants.validateMotorZ((int)motorZ);
        this.motor = (byte)motorZ;
        switch (mode) {
            case RUN_USING_ENCODER: {
                this.mode = 1;
                break;
            }
            case RUN_TO_POSITION: {
                this.mode = (byte)2;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("illegal mode: %s", mode.toString()));
            }
        }
    }

    public static Class<? extends LynxInterfaceResponse> getResponseClass() {
        return LynxGetMotorPIDFControlLoopCoefficientsResponse.class;
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(2).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.motor);
        buffer.put(this.mode);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.motor = buffer.get();
        this.mode = buffer.get();
    }

    @Override
    public boolean isDangerous() {
        return false;
    }
}

