/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.LynxInterfaceResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetPWMConfigurationResponse;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import java.nio.ByteBuffer;

public class LynxGetPWMConfigurationCommand
extends LynxDekaInterfaceCommand<LynxGetPWMConfigurationResponse> {
    public static final int cbPayload = 1;
    private byte channel;

    public LynxGetPWMConfigurationCommand(LynxModuleIntf module) {
        super(module, new LynxGetPWMConfigurationResponse(module));
    }

    public LynxGetPWMConfigurationCommand(LynxModuleIntf module, int channelZ) {
        this(module);
        LynxConstants.validatePwmChannelZ((int)channelZ);
        this.channel = (byte)channelZ;
    }

    public static Class<? extends LynxInterfaceResponse> getResponseClass() {
        return LynxGetPWMConfigurationResponse.class;
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(1).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.channel);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.channel = buffer.get();
    }

    @Override
    public boolean isDangerous() {
        return false;
    }
}

