/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.LynxInterfaceResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetServoConfigurationResponse;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import java.nio.ByteBuffer;

public class LynxGetServoConfigurationCommand
extends LynxDekaInterfaceCommand<LynxGetServoConfigurationResponse> {
    public static final int cbPayload = 1;
    private byte channel;

    public LynxGetServoConfigurationCommand(LynxModuleIntf module) {
        super(module, new LynxGetServoConfigurationResponse(module));
    }

    public LynxGetServoConfigurationCommand(LynxModuleIntf module, int channelZ) {
        this(module);
        LynxConstants.validateServoChannelZ((int)channelZ);
        this.channel = (byte)channelZ;
    }

    public static Class<? extends LynxInterfaceResponse> getResponseClass() {
        return LynxGetServoConfigurationResponse.class;
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(1).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.channel);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.channel = buffer.get();
    }

    @Override
    public boolean isDangerous() {
        return false;
    }
}

