/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxAck;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import java.nio.ByteBuffer;

public class LynxI2cConfigureChannelCommand
extends LynxDekaInterfaceCommand<LynxAck> {
    public static final int cbPayload = 2;
    private byte i2cBus;
    private byte speedCode;

    public LynxI2cConfigureChannelCommand(LynxModuleIntf module) {
        super(module);
    }

    public LynxI2cConfigureChannelCommand(LynxModuleIntf module, int busZ, SpeedCode speedCode) {
        this(module);
        LynxConstants.validateI2cBusZ((int)busZ);
        this.i2cBus = (byte)busZ;
        this.speedCode = speedCode.bVal;
    }

    public SpeedCode getSpeedCode() {
        return SpeedCode.fromByte(this.speedCode);
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(2).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.i2cBus);
        buffer.put(this.speedCode);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.i2cBus = buffer.get();
        this.speedCode = buffer.get();
    }

    @Override
    public boolean isDangerous() {
        return false;
    }

    public static enum SpeedCode {
        UNKNOWN(-1),
        STANDARD_100K(0),
        FAST_400K(1),
        FASTPLUS_1M(2),
        HIGH_3_4M(3);

        public byte bVal;

        private SpeedCode(int value) {
            this.bVal = (byte)value;
        }

        public static SpeedCode fromByte(int bVal) {
            for (SpeedCode code : SpeedCode.values()) {
                if (code.bVal != bVal) continue;
                return code;
            }
            return UNKNOWN;
        }
    }
}

