/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxI2cResponse;
import java.nio.ByteBuffer;

public class LynxI2cReadStatusQueryResponse
extends LynxI2cResponse {
    public static final int cbPayload = 2;
    private byte cbRead;
    private byte[] payload;

    public LynxI2cReadStatusQueryResponse(LynxModuleIntf module) {
        super(module);
    }

    public LynxI2cReadStatusQueryResponse(LynxModuleIntf module, int cbExpected) {
        super(module);
        this.payload = new byte[cbExpected];
    }

    public byte[] getBytes() {
        return this.payload;
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(2).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.i2cStatus);
        buffer.put(this.cbRead);
        buffer.put(this.payload);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.i2cStatus = buffer.get();
        this.cbRead = buffer.get();
        this.payload = new byte[this.cbRead];
        buffer.get(this.payload);
    }
}

