/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceResponse;
import com.qualcomm.robotcore.util.RobotLog;

public abstract class LynxI2cResponse
extends LynxDekaInterfaceResponse {
    protected byte i2cStatus = 0;

    public LynxI2cResponse(LynxModuleIntf module) {
        super(module);
    }

    public byte getI2cStatus() {
        return this.i2cStatus;
    }

    public boolean isAddressAcknowledged() {
        return LynxI2cResponse.isAddressAcknowledged(this.getI2cStatus());
    }

    public boolean isDataAcknowledged() {
        return LynxI2cResponse.isDataAcknowledged(this.getI2cStatus());
    }

    public boolean isArbitrationLost() {
        return LynxI2cResponse.isArbitrationLost(this.getI2cStatus());
    }

    public boolean isClockTimeout() {
        return LynxI2cResponse.isClockTimeout(this.getI2cStatus());
    }

    public boolean isStatusOk() {
        return LynxI2cResponse.isStatusOk(this.getI2cStatus());
    }

    public void logResponse() {
        if (this.getI2cStatus() != 0) {
            RobotLog.v((String)"addr=%s data=%s arb=%s clock=%s", (Object[])new Object[]{this.isAddressAcknowledged(), this.isDataAcknowledged(), this.isArbitrationLost(), this.isClockTimeout()});
        }
    }

    public static boolean isAddressAcknowledged(byte status) {
        return (status & 1) == 0;
    }

    public static boolean isDataAcknowledged(byte status) {
        return (status & 2) == 0;
    }

    public static boolean isArbitrationLost(byte status) {
        return (status & 4) != 0;
    }

    public static boolean isClockTimeout(byte status) {
        return (status & 8) != 0;
    }

    public static boolean isStatusOk(byte status) {
        return (status & 0xF) == 0;
    }
}

