/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxAck;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import java.nio.ByteBuffer;

public class LynxI2cWriteSingleByteCommand
extends LynxDekaInterfaceCommand<LynxAck> {
    public static final int cbPayload = 3;
    private byte i2cBus;
    private byte i2cAddr7Bit;
    private byte bValue;

    public LynxI2cWriteSingleByteCommand(LynxModuleIntf module) {
        super(module);
    }

    public LynxI2cWriteSingleByteCommand(LynxModuleIntf module, int busZ, I2cAddr i2cAddr, int bValue) {
        this(module);
        LynxConstants.validateI2cBusZ((int)busZ);
        this.i2cBus = (byte)busZ;
        this.i2cAddr7Bit = (byte)i2cAddr.get7Bit();
        this.bValue = (byte)bValue;
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(3).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.i2cBus);
        buffer.put(this.i2cAddr7Bit);
        buffer.put(this.bValue);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.i2cBus = buffer.get();
        this.i2cAddr7Bit = buffer.get();
        this.bValue = buffer.get();
    }

    @Override
    public boolean isDangerous() {
        return false;
    }
}

