/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import androidx.annotation.NonNull;
import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxAck;
import com.qualcomm.robotcore.util.TypeConversion;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class LynxInjectDataLogHintCommand
extends LynxDekaInterfaceCommand<LynxAck> {
    public static final int cbFixed = 1;
    public static final int cbMaxText = 100;
    public static final Charset charset = Charset.forName("UTF-8");
    private byte[] payload;

    public LynxInjectDataLogHintCommand(LynxModuleIntf module) {
        super(module);
    }

    public LynxInjectDataLogHintCommand(LynxModuleIntf module, @NonNull String hintText) {
        this(module);
        this.setHintText(hintText);
    }

    public void setHintText(@NonNull String text) {
        if (text.length() > 100) {
            text = text.substring(0, 100);
        }
        while (true) {
            this.payload = text.getBytes(charset);
            if (this.payload.length <= 100) break;
            text = text.substring(0, text.length() - 1);
        }
    }

    @NonNull
    public String getHintText() {
        if (this.payload != null) {
            return new String(this.payload, charset);
        }
        return "";
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(1 + this.payload.length).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put((byte)this.payload.length);
        buffer.put(this.payload);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        int cbPayload = TypeConversion.unsignedByteToInt((byte)buffer.get());
        this.payload = new byte[cbPayload];
        buffer.get(this.payload);
    }

    @Override
    public boolean isDangerous() {
        return false;
    }
}

