/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxAck;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import com.qualcomm.robotcore.util.TypeConversion;
import java.nio.ByteBuffer;

public class LynxSetMotorChannelCurrentAlertLevelCommand
extends LynxDekaInterfaceCommand<LynxAck> {
    public final int cbPayload = 3;
    private byte motor;
    private short mACurrentLimit;

    public LynxSetMotorChannelCurrentAlertLevelCommand(LynxModuleIntf module) {
        super(module);
    }

    public LynxSetMotorChannelCurrentAlertLevelCommand(LynxModuleIntf module, int motorZ, int mACurrentLimit) {
        this(module);
        LynxConstants.validateMotorZ((int)motorZ);
        this.motor = (byte)motorZ;
        this.mACurrentLimit = (short)mACurrentLimit;
        if (TypeConversion.unsignedShortToInt((short)this.mACurrentLimit) != mACurrentLimit) {
            throw new IllegalArgumentException(String.format("illegal current limit: %d mA", mACurrentLimit));
        }
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(3).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.motor);
        buffer.putShort(this.mACurrentLimit);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.motor = buffer.get();
        this.mACurrentLimit = buffer.getShort();
    }

    @Override
    public boolean isDangerous() {
        return false;
    }
}

