/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxAck;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import java.nio.ByteBuffer;

public class LynxSetMotorChannelEnableCommand
extends LynxDekaInterfaceCommand<LynxAck> {
    public final int cbPayload = 2;
    private byte motor;
    private byte enabled;

    public LynxSetMotorChannelEnableCommand(LynxModuleIntf module) {
        super(module);
    }

    public LynxSetMotorChannelEnableCommand(LynxModuleIntf module, int motorZ, boolean enabled) {
        this(module);
        LynxConstants.validateMotorZ((int)motorZ);
        this.motor = (byte)motorZ;
        this.enabled = enabled ? (byte)1 : 0;
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(2).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.motor);
        buffer.put(this.enabled);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.motor = buffer.get();
        this.enabled = buffer.get();
    }

    @Override
    public boolean isDangerous() {
        return false;
    }
}

