/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxAck;
import com.qualcomm.robotcore.hardware.DcMotor;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import java.nio.ByteBuffer;

public class LynxSetMotorChannelModeCommand
extends LynxDekaInterfaceCommand<LynxAck> {
    public final int cbPayload = 3;
    private byte motor;
    private byte mode;
    private byte floatAtZero;

    public LynxSetMotorChannelModeCommand(LynxModuleIntf module) {
        super(module);
    }

    public LynxSetMotorChannelModeCommand(LynxModuleIntf module, int motorZ, DcMotor.RunMode mode, DcMotor.ZeroPowerBehavior floatOrBrake) {
        this(module);
        LynxConstants.validateMotorZ((int)motorZ);
        this.motor = (byte)motorZ;
        this.mode = LynxConstants.runModeToLynxMotorMode((DcMotor.RunMode)mode);
        this.floatAtZero = floatOrBrake == DcMotor.ZeroPowerBehavior.BRAKE ? (byte)0 : 1;
    }

    public DcMotor.RunMode getMode() {
        switch (this.mode) {
            default: {
                return DcMotor.RunMode.RUN_WITHOUT_ENCODER;
            }
            case 1: {
                return DcMotor.RunMode.RUN_USING_ENCODER;
            }
            case 2: 
        }
        return DcMotor.RunMode.RUN_TO_POSITION;
    }

    public DcMotor.ZeroPowerBehavior getZeroPowerBehavior() {
        return this.floatAtZero == 0 ? DcMotor.ZeroPowerBehavior.BRAKE : DcMotor.ZeroPowerBehavior.FLOAT;
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(3).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.motor);
        buffer.put(this.mode);
        buffer.put(this.floatAtZero);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.motor = buffer.get();
        this.mode = buffer.get();
        this.floatAtZero = buffer.get();
    }

    @Override
    public boolean isDangerous() {
        return false;
    }
}

