/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxAck;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import java.nio.ByteBuffer;

public class LynxSetMotorConstantPowerCommand
extends LynxDekaInterfaceCommand<LynxAck> {
    public static final int cbPayload = 3;
    public static final int apiPowerLast = Short.MAX_VALUE;
    public static final int apiPowerFirst = -32767;
    private byte motor;
    private short power;

    public LynxSetMotorConstantPowerCommand(LynxModuleIntf module) {
        super(module);
    }

    public LynxSetMotorConstantPowerCommand(LynxModuleIntf module, int motorZ, int power) {
        this(module);
        LynxConstants.validateMotorZ((int)motorZ);
        if (power < -32767 || power > Short.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("illegal power: %d", power));
        }
        this.motor = (byte)motorZ;
        this.power = (short)power;
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(3).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.motor);
        buffer.putShort(this.power);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.motor = buffer.get();
        this.power = buffer.getShort();
    }

    @Override
    public boolean isDangerous() {
        return this.power != 0;
    }
}

