/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.core;

import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.core.LynxDekaInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxAck;
import java.nio.ByteBuffer;

public class LynxSetSingleDIOOutputCommand
extends LynxDekaInterfaceCommand<LynxAck> {
    public final int cbPayload = 2;
    private byte pin;
    private byte value;

    public LynxSetSingleDIOOutputCommand(LynxModuleIntf module) {
        super(module);
    }

    public LynxSetSingleDIOOutputCommand(LynxModuleIntf module, int pin, boolean value) {
        this(module);
        this.pin = (byte)pin;
        this.value = value ? (byte)1 : 0;
    }

    @Override
    public byte[] toPayloadByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(2).order(LynxDatagram.LYNX_ENDIAN);
        buffer.put(this.pin);
        buffer.put(this.value);
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.pin = buffer.get();
        this.value = buffer.get();
    }

    @Override
    public boolean isDangerous() {
        return false;
    }
}

