/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.standard;

import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.standard.LynxQueryInterfaceCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxStandardResponse;
import com.qualcomm.robotcore.util.TypeConversion;
import com.qualcomm.robotcore.util.Util;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LynxQueryInterfaceResponse
extends LynxStandardResponse {
    short commandNumberFirst = 0;
    short numberOfCommands = 0;

    public LynxQueryInterfaceResponse(LynxModule module) {
        super(module);
    }

    public int getCommandNumberFirst() {
        return TypeConversion.unsignedShortToInt((short)this.commandNumberFirst);
    }

    public int getNumberOfCommands() {
        return TypeConversion.unsignedShortToInt((short)this.numberOfCommands);
    }

    public static int getStandardCommandNumber() {
        return LynxQueryInterfaceCommand.getStandardCommandNumber() | 0x8000;
    }

    @Override
    public int getCommandNumber() {
        return LynxQueryInterfaceResponse.getStandardCommandNumber();
    }

    @Override
    public byte[] toPayloadByteArray() {
        return Util.concatenateByteArrays((byte[])TypeConversion.shortToByteArray((short)this.commandNumberFirst, (ByteOrder)LynxDatagram.LYNX_ENDIAN), (byte[])TypeConversion.shortToByteArray((short)this.numberOfCommands, (ByteOrder)LynxDatagram.LYNX_ENDIAN));
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb);
        buffer.order(LynxDatagram.LYNX_ENDIAN);
        this.commandNumberFirst = buffer.getShort();
        this.numberOfCommands = buffer.getShort();
    }
}

