/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx.commands.standard;

import android.graphics.Color;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.standard.LynxAck;
import com.qualcomm.hardware.lynx.commands.standard.LynxStandardCommand;
import com.qualcomm.robotcore.hardware.Blinker;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class LynxSetModuleLEDPatternCommand
extends LynxStandardCommand<LynxAck> {
    Steps steps = new Steps();
    public static final int maxStepCount = 16;

    public LynxSetModuleLEDPatternCommand(LynxModule module) {
        super(module);
    }

    public LynxSetModuleLEDPatternCommand(LynxModule module, Steps steps) {
        this(module);
        this.steps = steps;
    }

    public static void serializeStep(Blinker.Step step, ByteBuffer buffer) {
        int msDuration = step.getDurationMs();
        int tenthsDuration = (int)Math.round((double)msDuration / 100.0);
        int color = step.getColor();
        buffer.put((byte)Math.min(255, tenthsDuration));
        buffer.put((byte)Color.blue((int)color));
        buffer.put((byte)Color.green((int)color));
        buffer.put((byte)Color.red((int)color));
    }

    public static void deserializeStep(Blinker.Step step, ByteBuffer buffer) {
        byte tenths = buffer.get();
        int ms = tenths * 100;
        step.setDuration((long)ms, TimeUnit.MILLISECONDS);
        byte b = buffer.get();
        byte g = buffer.get();
        byte r = buffer.get();
        step.setColor(Color.rgb((int)r, (int)g, (int)b));
    }

    public static int cbSerializeStep() {
        return 4;
    }

    public static int getStandardCommandNumber() {
        return 32524;
    }

    @Override
    public int getCommandNumber() {
        return LynxSetModuleLEDPatternCommand.getStandardCommandNumber();
    }

    @Override
    public byte[] toPayloadByteArray() {
        int cbPayload = this.steps.cbSerialize();
        ByteBuffer buffer = ByteBuffer.allocate(cbPayload).order(LynxDatagram.LYNX_ENDIAN);
        for (Blinker.Step step : this.steps) {
            LynxSetModuleLEDPatternCommand.serializeStep(step, buffer);
        }
        if (this.steps.size() < 16) {
            LynxSetModuleLEDPatternCommand.serializeStep(Blinker.Step.nullStep(), buffer);
        }
        return buffer.array();
    }

    @Override
    public void fromPayloadByteArray(byte[] rgb) {
        ByteBuffer buffer = ByteBuffer.wrap(rgb).order(LynxDatagram.LYNX_ENDIAN);
        this.steps = new Steps();
        while (buffer.remaining() >= LynxSetModuleLEDPatternCommand.cbSerializeStep()) {
            Blinker.Step step = new Blinker.Step();
            LynxSetModuleLEDPatternCommand.deserializeStep(step, buffer);
            this.steps.add(step);
        }
    }

    @Override
    public boolean isDangerous() {
        return false;
    }

    public static class Steps
    implements Iterable<Blinker.Step> {
        ArrayList<Blinker.Step> steps = new ArrayList(16);

        public void add(Blinker.Step step) {
            if (this.steps.size() < 16) {
                this.steps.add(step);
            }
        }

        public void add(int index, Blinker.Step step) {
            if (index < 16) {
                this.steps.add(index, step);
            }
        }

        @Override
        public Iterator<Blinker.Step> iterator() {
            return this.steps.iterator();
        }

        public int size() {
            return this.steps.size();
        }

        public int cbSerialize() {
            if (this.size() == 16) {
                return this.steps.size() * LynxSetModuleLEDPatternCommand.cbSerializeStep();
            }
            return (this.steps.size() + 1) * LynxSetModuleLEDPatternCommand.cbSerializeStep();
        }
    }
}

