/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.maxbotix;

import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.I2cDeviceSynch;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchDevice;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.I2cWaitControl;
import com.qualcomm.robotcore.hardware.configuration.annotations.DeviceProperties;
import com.qualcomm.robotcore.hardware.configuration.annotations.I2cDeviceType;
import com.qualcomm.robotcore.util.TypeConversion;
import org.firstinspires.ftc.robotcore.external.navigation.DistanceUnit;

@I2cDeviceType
@DeviceProperties(xmlTag="MaxSonarI2CXL", name="MaxSonar I2CXL")
public class MaxSonarI2CXL
extends I2cDeviceSynchDevice<I2cDeviceSynch> {
    protected static final byte DEFAULT_I2C_ADDR = -32;
    protected static final byte CHANGE_I2C_ADDR_UNLOCK_1 = -86;
    protected static final byte CHANGE_I2C_ADDR_UNLOCK_2 = -91;
    protected static final byte CMD_PING = 81;
    protected static final byte NUM_RANGE_BYTES = 2;
    protected static int DEFAULT_SONAR_PROPAGATION_DELAY_MS = 50;
    protected double lastDistance = -1.0;
    protected long lastPingTime;

    public MaxSonarI2CXL(I2cDeviceSynch deviceClient) {
        super((I2cDeviceSynchSimple)deviceClient, true);
        ((I2cDeviceSynch)this.deviceClient).setI2cAddress(I2cAddr.create8bit((int)-32));
        ((I2cDeviceSynch)this.deviceClient).engage();
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.MaxBotix;
    }

    protected synchronized boolean doInitialize() {
        return true;
    }

    public String getDeviceName() {
        return "MaxSonar I2CXL";
    }

    protected void ping() {
        ((I2cDeviceSynch)this.deviceClient).write8(81, I2cWaitControl.ATOMIC);
    }

    protected double getRangingResult(DistanceUnit units) {
        short cm = TypeConversion.byteArrayToShort((byte[])((I2cDeviceSynch)this.deviceClient).read(2));
        return units.fromCm((double)cm);
    }

    public double getDistanceSync(DistanceUnit units) {
        return this.getDistanceSync(DEFAULT_SONAR_PROPAGATION_DELAY_MS, units);
    }

    public double getDistanceSync(int sonarPropagationDelayMs, DistanceUnit units) {
        this.ping();
        try {
            Thread.sleep(sonarPropagationDelayMs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return 0.0;
        }
        return this.getRangingResult(units);
    }

    public double getDistanceAsync(DistanceUnit units) {
        return this.getDistanceAsync(DEFAULT_SONAR_PROPAGATION_DELAY_MS, units);
    }

    public double getDistanceAsync(int sonarPropagationDelayMs, DistanceUnit units) {
        long curTime = System.currentTimeMillis();
        if (curTime - this.lastPingTime > (long)sonarPropagationDelayMs) {
            this.lastDistance = this.getRangingResult(units);
            this.ping();
            this.lastPingTime = System.currentTimeMillis();
        }
        return this.lastDistance;
    }

    public void setI2cAddress(I2cAddr i2cAddr) {
        ((I2cDeviceSynch)this.deviceClient).setI2cAddress(i2cAddr);
    }

    public I2cAddr getI2cAddress() {
        return ((I2cDeviceSynch)this.deviceClient).getI2cAddress();
    }

    public void writeI2cAddrToSensorEEPROM(byte addr) {
        byte[] bytes = new byte[]{-86, -91, addr};
        ((I2cDeviceSynch)this.deviceClient).write(bytes);
    }
}

