/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.modernrobotics;

import com.qualcomm.robotcore.hardware.GyroSensor;
import com.qualcomm.robotcore.hardware.Gyroscope;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.I2cAddrConfig;
import com.qualcomm.robotcore.hardware.I2cDeviceSynch;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchDevice;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.I2cWaitControl;
import com.qualcomm.robotcore.hardware.IntegratingGyroscope;
import com.qualcomm.robotcore.hardware.TimestampedData;
import com.qualcomm.robotcore.hardware.usb.RobotUsbDevice;
import com.qualcomm.robotcore.util.TypeConversion;
import java.nio.ByteOrder;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.AngularVelocity;
import org.firstinspires.ftc.robotcore.external.navigation.AxesOrder;
import org.firstinspires.ftc.robotcore.external.navigation.AxesReference;
import org.firstinspires.ftc.robotcore.external.navigation.Axis;
import org.firstinspires.ftc.robotcore.external.navigation.Orientation;

public class ModernRoboticsI2cGyro
extends I2cDeviceSynchDevice<I2cDeviceSynch>
implements GyroSensor,
Gyroscope,
IntegratingGyroscope,
I2cAddrConfig {
    public static final I2cAddr ADDRESS_I2C_DEFAULT = I2cAddr.create8bit((int)32);
    protected float degreesPerSecondPerDigit = 0.00875f;
    protected HeadingMode headingMode = HeadingMode.HEADING_CARTESIAN;
    protected float degreesPerZAxisTick;

    public ModernRoboticsI2cGyro(I2cDeviceSynch deviceClient, boolean deviceClientIsOwned) {
        super((I2cDeviceSynchSimple)deviceClient, deviceClientIsOwned);
        this.setOptimalReadWindow();
        ((I2cDeviceSynch)this.deviceClient).setI2cAddress(ADDRESS_I2C_DEFAULT);
        super.registerArmingStateCallback(false);
        ((I2cDeviceSynch)this.deviceClient).engage();
    }

    protected void setOptimalReadWindow() {
        I2cDeviceSynch.ReadWindow readWindow = new I2cDeviceSynch.ReadWindow((int)Register.READ_WINDOW_FIRST.bVal, Register.READ_WINDOW_LAST.bVal - Register.READ_WINDOW_FIRST.bVal + 1, I2cDeviceSynch.ReadMode.REPEAT);
        ((I2cDeviceSynch)this.deviceClient).setReadWindow(readWindow);
    }

    protected synchronized boolean doInitialize() {
        this.writeCommand(Command.NORMAL);
        this.resetZAxisIntegrator();
        this.setZAxisScalingCoefficient(256);
        this.headingMode = HeadingMode.HEADING_CARTESIAN;
        return true;
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.ModernRobotics;
    }

    public String getDeviceName() {
        RobotUsbDevice.FirmwareVersion firmwareVersion = new RobotUsbDevice.FirmwareVersion((int)this.read8(Register.FIRMWARE_REV));
        return String.format(Locale.getDefault(), "Modern Robotics Gyroscope %s", firmwareVersion);
    }

    public byte read8(Register reg) {
        return ((I2cDeviceSynch)this.deviceClient).read8((int)reg.bVal);
    }

    public void write8(Register reg, byte value) {
        ((I2cDeviceSynch)this.deviceClient).write8((int)reg.bVal, (int)value);
    }

    public short readShort(Register reg) {
        return TypeConversion.byteArrayToShort((byte[])((I2cDeviceSynch)this.deviceClient).read((int)reg.bVal, 2), (ByteOrder)ByteOrder.LITTLE_ENDIAN);
    }

    public void writeShort(Register reg, short value) {
        ((I2cDeviceSynch)this.deviceClient).write((int)reg.bVal, TypeConversion.shortToByteArray((short)value, (ByteOrder)ByteOrder.LITTLE_ENDIAN));
    }

    public void writeCommand(Command command) {
        ((I2cDeviceSynch)this.deviceClient).waitForWriteCompletions(I2cWaitControl.ATOMIC);
        this.write8(Register.COMMAND, command.bVal);
    }

    public Command readCommand() {
        return Command.fromByte(this.read8(Register.COMMAND));
    }

    public Set<Axis> getAngularVelocityAxes() {
        HashSet<Axis> result = new HashSet<Axis>();
        result.add(Axis.X);
        result.add(Axis.Y);
        result.add(Axis.Z);
        return result;
    }

    public Set<Axis> getAngularOrientationAxes() {
        HashSet<Axis> result = new HashSet<Axis>();
        result.add(Axis.Z);
        return result;
    }

    public AngularVelocity getAngularVelocity(AngleUnit unit) {
        TimestampedData data = ((I2cDeviceSynch)this.deviceClient).readTimeStamped((int)Register.RAW_X_VAL.bVal, 6);
        short rawX = TypeConversion.byteArrayToShort((byte[])data.data, (int)0, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        short rawY = TypeConversion.byteArrayToShort((byte[])data.data, (int)2, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        short rawZ = TypeConversion.byteArrayToShort((byte[])data.data, (int)4, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        float degPerSecondX = (float)rawX * this.degreesPerSecondPerDigit;
        float degPerSecondY = (float)rawY * this.degreesPerSecondPerDigit;
        float degPerSecondZ = (float)rawZ * this.degreesPerSecondPerDigit;
        return new AngularVelocity(AngleUnit.DEGREES, degPerSecondX, degPerSecondY, degPerSecondZ, data.nanoTime).toAngleUnit(unit);
    }

    public Orientation getAngularOrientation(AxesReference reference, AxesOrder order, AngleUnit angleUnit) {
        TimestampedData data = ((I2cDeviceSynch)this.deviceClient).readTimeStamped((int)Register.INTEGRATED_Z_VALUE.bVal, 2);
        short integratedZ = TypeConversion.byteArrayToShort((byte[])data.data, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        float cartesian = AngleUnit.normalizeDegrees((float)this.degreesZFromIntegratedZ(integratedZ));
        return new Orientation(AxesReference.INTRINSIC, AxesOrder.ZYX, AngleUnit.DEGREES, cartesian, 0.0f, 0.0f, data.nanoTime).toAxesReference(reference).toAxesOrder(order).toAngleUnit(angleUnit);
    }

    public synchronized void setHeadingMode(HeadingMode headingMode) {
        this.headingMode = headingMode;
    }

    public HeadingMode getHeadingMode() {
        return this.headingMode;
    }

    public int rawX() {
        return this.readShort(Register.RAW_X_VAL);
    }

    public int rawY() {
        return this.readShort(Register.RAW_Y_VAL);
    }

    public int rawZ() {
        return this.readShort(Register.RAW_Z_VAL);
    }

    public int getZAxisOffset() {
        return this.readShort(Register.Z_AXIS_OFFSET);
    }

    public void setZAxisOffset(short offset) {
        this.writeShort(Register.Z_AXIS_OFFSET, offset);
    }

    public int getZAxisScalingCoefficient() {
        return TypeConversion.unsignedShortToInt((short)this.readShort(Register.Z_AXIS_SCALE_COEF));
    }

    public void setZAxisScalingCoefficient(int zAxisScalingCoefficient) {
        this.writeShort(Register.Z_AXIS_SCALE_COEF, (short)zAxisScalingCoefficient);
        this.degreesPerZAxisTick = 256.0f / (float)zAxisScalingCoefficient;
    }

    public int getIntegratedZValue() {
        return this.readShort(Register.INTEGRATED_Z_VALUE);
    }

    public synchronized int getHeading() {
        float cartesian = this.normalize0359(this.degreesZFromIntegratedZ(this.getIntegratedZValue()));
        if (this.headingMode == HeadingMode.HEADING_CARDINAL) {
            return this.truncate(cartesian == 0.0f ? cartesian : Math.abs(cartesian - 360.0f));
        }
        return this.truncate(cartesian);
    }

    protected int truncate(float angle) {
        return (int)angle;
    }

    protected float normalize0359(float degrees) {
        return (degrees = AngleUnit.normalizeDegrees((float)degrees)) < 0.0f ? degrees + 360.0f : degrees;
    }

    protected float degreesZFromIntegratedZ(int integratedZ) {
        return (float)integratedZ * this.degreesPerZAxisTick;
    }

    public void resetZAxisIntegrator() {
        this.writeCommand(Command.RESET_Z_AXIS);
    }

    public String status() {
        return String.format(Locale.getDefault(), "%s on %s", this.getDeviceName(), this.getConnectionInfo());
    }

    public void calibrate() {
        this.writeCommand(Command.CALIBRATE);
    }

    public boolean isCalibrating() {
        return this.readCommand() == Command.CALIBRATE;
    }

    public void setI2cAddress(I2cAddr newAddress) {
        ((I2cDeviceSynch)this.deviceClient).setI2cAddress(newAddress);
    }

    public I2cAddr getI2cAddress() {
        return ((I2cDeviceSynch)this.deviceClient).getI2cAddress();
    }

    @Deprecated
    public double getRotationFraction() {
        this.notSupported();
        return 0.0;
    }

    @Deprecated
    public MeasurementMode getMeasurementMode() {
        return this.isCalibrating() ? MeasurementMode.GYRO_CALIBRATING : MeasurementMode.GYRO_NORMAL;
    }

    protected void notSupported() {
        throw new UnsupportedOperationException("This method is not supported for " + this.getDeviceName());
    }

    public static enum HeadingMode {
        HEADING_CARTESIAN,
        HEADING_CARDINAL;

    }

    public static enum Register {
        READ_WINDOW_FIRST(0),
        FIRMWARE_REV(0),
        MANUFACTURE_CODE(1),
        SENSOR_ID(2),
        COMMAND(3),
        HEADING_DATA(4),
        INTEGRATED_Z_VALUE(6),
        RAW_X_VAL(8),
        RAW_Y_VAL(10),
        RAW_Z_VAL(12),
        Z_AXIS_OFFSET(14),
        Z_AXIS_SCALE_COEF(16),
        READ_WINDOW_LAST(Register.Z_AXIS_SCALE_COEF.bVal + 1),
        UNKNOWN(-1);

        public byte bVal;

        private Register(int value) {
            this.bVal = (byte)value;
        }

        public static Register fromByte(byte bVal) {
            for (Register register : Register.values()) {
                if (register.bVal != bVal) continue;
                return register;
            }
            return UNKNOWN;
        }
    }

    public static enum Command {
        NORMAL(0),
        CALIBRATE(78),
        RESET_Z_AXIS(82),
        WRITE_EEPROM(87),
        UNKNOWN(-1);

        public byte bVal;

        private Command(int value) {
            this.bVal = (byte)value;
        }

        public static Command fromByte(byte bVal) {
            for (Command command : Command.values()) {
                if (command.bVal != bVal) continue;
                return command;
            }
            return UNKNOWN;
        }
    }

    @Deprecated
    public static enum MeasurementMode {
        GYRO_CALIBRATION_PENDING,
        GYRO_CALIBRATING,
        GYRO_NORMAL;

    }
}

