/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.modernrobotics;

import com.qualcomm.robotcore.hardware.DistanceSensor;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.I2cAddrConfig;
import com.qualcomm.robotcore.hardware.I2cDeviceSynch;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchDevice;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.I2cWaitControl;
import com.qualcomm.robotcore.hardware.OpticalDistanceSensor;
import com.qualcomm.robotcore.hardware.configuration.annotations.DeviceProperties;
import com.qualcomm.robotcore.hardware.configuration.annotations.I2cDeviceType;
import com.qualcomm.robotcore.hardware.usb.RobotUsbDevice;
import com.qualcomm.robotcore.util.Range;
import com.qualcomm.robotcore.util.TypeConversion;
import java.util.Locale;
import org.firstinspires.ftc.robotcore.external.navigation.DistanceUnit;

@I2cDeviceType
@DeviceProperties(name="@string/mr_range_name", description="@string/mr_range_description", xmlTag="ModernRoboticsI2cRangeSensor", builtIn=true)
public class ModernRoboticsI2cRangeSensor
extends I2cDeviceSynchDevice<I2cDeviceSynch>
implements DistanceSensor,
OpticalDistanceSensor,
I2cAddrConfig {
    public static final I2cAddr ADDRESS_I2C_DEFAULT = I2cAddr.create8bit((int)40);
    protected static final double apiLevelMin = 0.0;
    protected static final double apiLevelMax = 1.0;
    public double aParam = 5.11595056535567;
    public double bParam = 457.048400147437;
    public double cParam = -0.8061002068394054;
    public double dParam = 0.004048820370701007;
    public int rawOpticalMinValid = 3;
    protected static final int cmUltrasonicMax = 255;

    public ModernRoboticsI2cRangeSensor(I2cDeviceSynch deviceClient, boolean deviceClientIsOwned) {
        super((I2cDeviceSynchSimple)deviceClient, deviceClientIsOwned);
        this.setOptimalReadWindow();
        ((I2cDeviceSynch)this.deviceClient).setI2cAddress(ADDRESS_I2C_DEFAULT);
        super.registerArmingStateCallback(false);
        ((I2cDeviceSynch)this.deviceClient).engage();
    }

    protected void setOptimalReadWindow() {
        I2cDeviceSynch.ReadWindow readWindow = new I2cDeviceSynch.ReadWindow((int)Register.FIRST.bVal, Register.LAST.bVal - Register.FIRST.bVal + 1, I2cDeviceSynch.ReadMode.REPEAT);
        ((I2cDeviceSynch)this.deviceClient).setReadWindow(readWindow);
    }

    protected synchronized boolean doInitialize() {
        return true;
    }

    public double getDistance(DistanceUnit unit) {
        double cm;
        int rawOptical = this.rawOptical();
        if (rawOptical >= this.rawOpticalMinValid) {
            cm = this.cmFromOptical(rawOptical);
        } else {
            cm = this.cmUltrasonic();
            if (cm == 255.0) {
                return Double.MAX_VALUE;
            }
        }
        return unit.fromUnit(DistanceUnit.CM, cm);
    }

    protected double cmFromOptical(int rawOptical) {
        return (this.dParam + Math.log((-this.aParam + (double)rawOptical) / this.bParam)) / this.cParam;
    }

    public double cmUltrasonic() {
        return this.rawUltrasonic();
    }

    public double cmOptical() {
        int rawOptical = this.rawOptical();
        if (rawOptical >= this.rawOpticalMinValid) {
            return this.cmFromOptical(rawOptical);
        }
        return Double.MAX_VALUE;
    }

    public double getLightDetected() {
        return Range.clip((double)Range.scale((double)this.getRawLightDetected(), (double)0.0, (double)this.getRawLightDetectedMax(), (double)0.0, (double)1.0), (double)0.0, (double)1.0);
    }

    public double getRawLightDetected() {
        return this.rawOptical();
    }

    public double getRawLightDetectedMax() {
        return 255.0;
    }

    public void enableLed(boolean enable) {
    }

    public String status() {
        return String.format(Locale.getDefault(), "%s on %s", this.getDeviceName(), this.getConnectionInfo());
    }

    public int rawUltrasonic() {
        return this.readUnsignedByte(Register.ULTRASONIC);
    }

    public int rawOptical() {
        return this.readUnsignedByte(Register.OPTICAL);
    }

    public void setI2cAddress(I2cAddr newAddress) {
        ((I2cDeviceSynch)this.deviceClient).setI2cAddress(newAddress);
    }

    public I2cAddr getI2cAddress() {
        return ((I2cDeviceSynch)this.deviceClient).getI2cAddress();
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.ModernRobotics;
    }

    public String getDeviceName() {
        return String.format(Locale.getDefault(), "Modern Robotics Range Sensor %s", new RobotUsbDevice.FirmwareVersion((int)this.read8(Register.FIRMWARE_REV)));
    }

    public byte read8(Register reg) {
        return ((I2cDeviceSynch)this.deviceClient).read8((int)reg.bVal);
    }

    public void write8(Register reg, byte value) {
        this.write8(reg, value, I2cWaitControl.NONE);
    }

    public void write8(Register reg, byte value, I2cWaitControl waitControl) {
        ((I2cDeviceSynch)this.deviceClient).write8((int)reg.bVal, (int)value, waitControl);
    }

    protected int readUnsignedByte(Register reg) {
        return TypeConversion.unsignedByteToInt((byte)this.read8(reg));
    }

    public static enum Register {
        FIRST(0),
        FIRMWARE_REV(0),
        MANUFACTURE_CODE(1),
        SENSOR_ID(2),
        ULTRASONIC(4),
        OPTICAL(5),
        LAST(Register.OPTICAL.bVal),
        UNKNOWN(-1);

        public byte bVal;

        private Register(int bVal) {
            this.bVal = (byte)bVal;
        }
    }
}

