/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.modernrobotics.comm;

import android.annotation.SuppressLint;
import androidx.annotation.Nullable;
import com.qualcomm.hardware.modernrobotics.comm.ModernRoboticsDatagram;
import com.qualcomm.hardware.modernrobotics.comm.ModernRoboticsRequest;
import com.qualcomm.hardware.modernrobotics.comm.ModernRoboticsResponse;
import com.qualcomm.robotcore.hardware.usb.RobotUsbDevice;
import com.qualcomm.robotcore.util.RobotLog;
import java.util.concurrent.TimeUnit;
import org.firstinspires.ftc.robotcore.internal.hardware.TimeWindow;
import org.firstinspires.ftc.robotcore.internal.system.Deadline;
import org.firstinspires.ftc.robotcore.internal.usb.exception.RobotUsbException;
import org.firstinspires.ftc.robotcore.internal.usb.exception.RobotUsbProtocolException;
import org.firstinspires.ftc.robotcore.internal.usb.exception.RobotUsbTimeoutException;
import org.firstinspires.ftc.robotcore.internal.usb.exception.RobotUsbTooManySequentialErrorsException;

@SuppressLint(value={"DefaultLocale"})
public class ModernRoboticsReaderWriter {
    public static final String TAG = "MRReaderWriter";
    public static boolean DEBUG = false;
    public static int MS_INTER_BYTE_TIMEOUT = 10;
    public static int MS_USB_HUB_LATENCY = 2;
    public static int MS_REQUEST_RESPONSE_TIMEOUT = 50 + MS_USB_HUB_LATENCY * 2;
    public static int MS_GARBAGE_COLLECTION_SPURT = 40;
    public static int MS_RESYNCH_TIMEOUT = 1000;
    public static int MS_FAILURE_WAIT = 40;
    public static int MS_COMM_ERROR_WAIT = 100;
    public static int MS_MAX_TIMEOUT = 100;
    public static int MAX_SEQUENTIAL_USB_ERROR_COUNT = 5;
    public static final String COMM_FAILURE_READ = "comm failure read";
    public static final String COMM_FAILURE_WRITE = "comm failure write";
    public static final String COMM_TIMEOUT_READ = "comm timeout awaiting response (read)";
    public static final String COMM_TIMEOUT_WRITE = "comm timeout awaiting response (write)";
    public static final String COMM_ERROR_READ = "comm error read";
    public static final String COMM_ERROR_WRITE = "comm error write";
    public static final String COMM_SYNC_LOST = "comm sync lost";
    public static final String COMM_PAYLOAD_ERROR_READ = "comm payload error read";
    public static final String COMM_PAYLOAD_ERROR_WRITE = "comm payload error write";
    public static final String COMM_TYPE_ERROR_READ = "comm type error read";
    public static final String COMM_TYPE_ERROR_WRITE = "comm type error write";
    protected final RobotUsbDevice device;
    protected int usbSequentialCommReadErrorCount = 0;
    protected int usbSequentialCommWriteErrorCount = 0;
    protected int usbReadRetryCount = 4;
    protected int usbWriteRetryCount = 4;
    protected int msUsbReadRetryInterval = 20;
    protected int msUsbWriteRetryInterval = 20;
    protected boolean isSynchronized = false;
    protected Deadline responseDeadline = new Deadline((long)MS_RESYNCH_TIMEOUT, TimeUnit.MILLISECONDS);
    protected ModernRoboticsDatagram.AllocationContext<ModernRoboticsRequest> requestAllocationContext = new ModernRoboticsDatagram.AllocationContext();
    protected ModernRoboticsDatagram.AllocationContext<ModernRoboticsResponse> responseAllocationContext = new ModernRoboticsDatagram.AllocationContext();

    public ModernRoboticsReaderWriter(RobotUsbDevice device) {
        this.device = device;
        this.device.setDebugRetainBuffers(true);
    }

    public void throwIfTooManySequentialCommErrors() throws RobotUsbTooManySequentialErrorsException {
        if (this.device.isOpen() && (this.usbSequentialCommReadErrorCount > MAX_SEQUENTIAL_USB_ERROR_COUNT || this.usbSequentialCommWriteErrorCount > MAX_SEQUENTIAL_USB_ERROR_COUNT)) {
            throw new RobotUsbTooManySequentialErrorsException("%s: too many sequential USB comm errors on device", new Object[]{this.device.getSerialNumber()});
        }
    }

    public void close() {
        this.device.close();
    }

    public void read(boolean retry, int address, byte[] buffer, @Nullable TimeWindow payloadTimeWindow) throws RobotUsbException, InterruptedException {
        if (DEBUG) {
            RobotLog.vv((String)TAG, (String)"%s: read(addr=%d cb=%d)", (Object[])new Object[]{this.device.getSerialNumber(), address, buffer.length});
        }
        RobotUsbException exception = null;
        for (int i = 0; i < this.usbReadRetryCount; ++i) {
            if (i > 0) {
                RobotLog.ee((String)TAG, (String)"%s: retry #%d read(addr=%d cb=%d)", (Object[])new Object[]{this.device.getSerialNumber(), i, address, buffer.length});
            }
            try {
                this.readOnce(address, buffer, payloadTimeWindow);
            }
            catch (RobotUsbException e) {
                if (!this.device.isOpen()) {
                    return;
                }
                if (!retry) {
                    RobotLog.ee((String)TAG, (String)"%s: ignoring failed read(addr=%d cb=%d)", (Object[])new Object[]{this.device.getSerialNumber(), address, buffer.length});
                    return;
                }
                Thread.sleep(this.msUsbReadRetryInterval);
                this.device.resetAndFlushBuffers();
                exception = e;
                continue;
            }
            return;
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected void readOnce(int address, byte[] buffer, @Nullable TimeWindow payloadTimeWindow) throws RobotUsbException, InterruptedException {
        block11: {
            ModernRoboticsRequest request = null;
            ModernRoboticsResponse response = null;
            try {
                request = ModernRoboticsRequest.newInstance(this.requestAllocationContext, 0);
                request.setRead(0);
                request.setAddress(address);
                request.setPayloadLength(buffer.length);
                this.device.write(request.data);
                try {
                    response = this.readResponse(request, payloadTimeWindow);
                    if (response.isFailure()) {
                        Thread.sleep(MS_FAILURE_WAIT);
                        this.logAndThrowProtocol(request, response, COMM_FAILURE_READ);
                        break block11;
                    }
                    if (response.isRead() && response.getFunction() == 0 && response.getAddress() == address && response.getPayloadLength() == buffer.length) {
                        this.usbSequentialCommReadErrorCount = 0;
                        System.arraycopy(response.data, 5, buffer, 0, buffer.length);
                        break block11;
                    }
                    Thread.sleep(MS_COMM_ERROR_WAIT);
                    this.logAndThrowProtocol(request, response, COMM_ERROR_READ);
                }
                catch (RobotUsbTimeoutException e) {
                    Thread.sleep(MS_COMM_ERROR_WAIT);
                    this.logAndRethrowTimeout(e, request, this.timeoutMessage(COMM_TIMEOUT_READ, e));
                }
            }
            catch (RobotUsbException e) {
                ++this.usbSequentialCommReadErrorCount;
                throw e;
            }
            finally {
                if (response != null) {
                    response.close();
                }
                if (request != null) {
                    request.close();
                }
            }
        }
    }

    public void write(int address, byte[] buffer) throws RobotUsbException, InterruptedException {
        if (DEBUG) {
            RobotLog.vv((String)TAG, (String)"%s: write(addr=%d cb=%d)", (Object[])new Object[]{this.device.getSerialNumber(), address, buffer.length});
        }
        RobotUsbException exception = null;
        for (int i = 0; i < this.usbWriteRetryCount; ++i) {
            if (i > 0) {
                RobotLog.ee((String)TAG, (String)"%s: retry #%d write(addr=%d cb=%d)", (Object[])new Object[]{this.device.getSerialNumber(), i, address, buffer.length});
            }
            try {
                this.writeOnce(address, buffer);
            }
            catch (RobotUsbException e) {
                if (!this.device.isOpen()) {
                    return;
                }
                Thread.sleep(this.msUsbWriteRetryInterval);
                this.device.resetAndFlushBuffers();
                exception = e;
                continue;
            }
            return;
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected void writeOnce(int address, byte[] buffer) throws RobotUsbException, InterruptedException {
        block11: {
            ModernRoboticsRequest request = null;
            ModernRoboticsResponse response = null;
            try {
                request = ModernRoboticsRequest.newInstance(this.requestAllocationContext, buffer.length);
                request.setWrite(0);
                request.setAddress(address);
                request.setPayload(buffer);
                this.device.write(request.data);
                try {
                    response = this.readResponse(request, null);
                    if (response.isFailure()) {
                        Thread.sleep(MS_FAILURE_WAIT);
                        this.logAndThrowProtocol(request, response, COMM_FAILURE_WRITE);
                        break block11;
                    }
                    if (response.isWrite() && response.getFunction() == 0 && response.getAddress() == address && response.getPayloadLength() == 0) {
                        this.usbSequentialCommWriteErrorCount = 0;
                        break block11;
                    }
                    Thread.sleep(MS_COMM_ERROR_WAIT);
                    this.logAndThrowProtocol(request, response, COMM_ERROR_WRITE);
                }
                catch (RobotUsbTimeoutException e) {
                    Thread.sleep(MS_COMM_ERROR_WAIT);
                    this.logAndRethrowTimeout(e, request, this.timeoutMessage(COMM_TIMEOUT_WRITE, e));
                }
            }
            catch (RobotUsbException e) {
                ++this.usbSequentialCommWriteErrorCount;
                throw e;
            }
            finally {
                if (response != null) {
                    response.close();
                }
                if (request != null) {
                    request.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModernRoboticsResponse readResponse(ModernRoboticsRequest request, @Nullable TimeWindow payloadTimeWindow) throws RobotUsbException, InterruptedException {
        this.responseDeadline.reset();
        while (!this.responseDeadline.hasExpired()) {
            if (!this.device.mightBeAtUsbPacketStart()) {
                this.isSynchronized = false;
            }
            ModernRoboticsResponse header = ModernRoboticsResponse.newInstance(this.responseAllocationContext, 0);
            try {
                int cbPayloadExpected;
                if (!this.isSynchronized) {
                    byte[] singleByte = new byte[1];
                    byte[] headerSuffix = new byte[3];
                    this.device.skipToLikelyUsbPacketStart();
                    if (this.readSingleByte(singleByte, MS_REQUEST_RESPONSE_TIMEOUT, null, "sync0") != ModernRoboticsResponse.syncBytes[0] || this.readSingleByte(singleByte, 0, null, "sync1") != ModernRoboticsResponse.syncBytes[1]) continue;
                    this.readIncomingBytes(headerSuffix, 0, headerSuffix.length, 0, null, "syncSuffix");
                    System.arraycopy(ModernRoboticsResponse.syncBytes, 0, header.data, 0, 2);
                    System.arraycopy(headerSuffix, 0, header.data, 2, headerSuffix.length);
                } else {
                    this.readIncomingBytes(header.data, 0, header.data.length, MS_REQUEST_RESPONSE_TIMEOUT, null, "header");
                    if (!header.syncBytesValid()) {
                        this.logAndThrowProtocol(request, header, COMM_SYNC_LOST);
                    }
                }
                if (!(header.isFailure() || request.isRead() == header.isRead() && request.getFunction() == header.getFunction())) {
                    this.logAndThrowProtocol(request, header, request.isWrite() ? COMM_TYPE_ERROR_WRITE : COMM_TYPE_ERROR_READ);
                }
                int n = header.isFailure() ? 0 : (cbPayloadExpected = request.isWrite() ? 0 : request.getPayloadLength());
                if (cbPayloadExpected != header.getPayloadLength()) {
                    this.logAndThrowProtocol(request, header, request.isWrite() ? COMM_PAYLOAD_ERROR_WRITE : COMM_PAYLOAD_ERROR_READ);
                }
                ModernRoboticsResponse result = ModernRoboticsResponse.newInstance(this.responseAllocationContext, header.getPayloadLength());
                System.arraycopy(header.data, 0, result.data, 0, header.data.length);
                this.readIncomingBytes(result.data, header.data.length, header.getPayloadLength(), 0, payloadTimeWindow, "payload");
                this.isSynchronized = true;
                ModernRoboticsResponse modernRoboticsResponse = result;
                return modernRoboticsResponse;
            }
            finally {
                if (header == null) continue;
                header.close();
            }
        }
        throw new RobotUsbTimeoutException(this.responseDeadline.startTimeNanoseconds(), "timeout waiting %d ms for response", new Object[]{this.responseDeadline.getDuration(TimeUnit.MILLISECONDS)});
    }

    protected void readIncomingBytes(byte[] buffer, int ibFirst, int cbToRead, int msExtraTimeout, @Nullable TimeWindow timeWindow, String debugContext) throws RobotUsbException, InterruptedException {
        if (cbToRead > 0) {
            long msReadTimeout = MS_INTER_BYTE_TIMEOUT * (cbToRead + 2) + msExtraTimeout + MS_GARBAGE_COLLECTION_SPURT;
            msReadTimeout = Math.min(msReadTimeout, (long)MS_MAX_TIMEOUT);
            long nsTimerStart = System.nanoTime();
            int cbRead = this.device.read(buffer, ibFirst, cbToRead, msReadTimeout, timeWindow);
            if (cbRead != cbToRead) {
                if (cbRead == 0) {
                    throw new RobotUsbTimeoutException(nsTimerStart, "%s: unable to read %d bytes in %d ms", new Object[]{debugContext, cbToRead, msReadTimeout});
                }
                this.logAndThrowProtocol("readIncomingBytes(%s) cbToRead=%d cbRead=%d", debugContext, cbToRead, cbRead);
            }
        }
    }

    protected byte readSingleByte(byte[] buffer, int msExtraTimeout, @Nullable TimeWindow timeWindow, String debugContext) throws RobotUsbException, InterruptedException {
        this.readIncomingBytes(buffer, 0, 1, msExtraTimeout, timeWindow, debugContext);
        return buffer[0];
    }

    protected String timeoutMessage(String root, RobotUsbTimeoutException e) {
        return String.format("%s: %s", root, e.getMessage());
    }

    protected void doExceptionBookkeeping() {
        this.isSynchronized = false;
    }

    protected void logAndRethrowTimeout(RobotUsbTimeoutException e, ModernRoboticsRequest request, String message) throws RobotUsbTimeoutException {
        ModernRoboticsRequest requestHeader = ModernRoboticsRequest.newInstance(this.requestAllocationContext, 0);
        System.arraycopy(request.data, 0, requestHeader.data, 0, requestHeader.data.length);
        RobotLog.ee((String)TAG, (String)"%s: %s request=%s", (Object[])new Object[]{this.device.getSerialNumber(), message, ModernRoboticsReaderWriter.bufferToString(requestHeader.data)});
        this.device.logRetainedBuffers(e.nsTimerStart, e.nsTimerExpire, TAG, "recent data on %s", new Object[]{this.device.getSerialNumber()});
        this.doExceptionBookkeeping();
        throw e;
    }

    protected void logAndThrowProtocol(String format, Object ... args) throws RobotUsbProtocolException {
        String message = String.format(format, args);
        RobotLog.ee((String)TAG, (String)"%s: %s", (Object[])new Object[]{this.device.getSerialNumber(), message});
        this.doExceptionBookkeeping();
        throw new RobotUsbProtocolException(message);
    }

    protected void logAndThrowProtocol(ModernRoboticsRequest request, ModernRoboticsResponse response, String message) throws RobotUsbProtocolException {
        ModernRoboticsRequest requestHeader = ModernRoboticsRequest.newInstance(this.requestAllocationContext, 0);
        System.arraycopy(request.data, 0, requestHeader.data, 0, requestHeader.data.length);
        ModernRoboticsResponse responseHeader = ModernRoboticsResponse.newInstance(this.responseAllocationContext, 0);
        System.arraycopy(response.data, 0, responseHeader.data, 0, responseHeader.data.length);
        RobotLog.ee((String)TAG, (String)"%s: %s: request:%s response:%s", (Object[])new Object[]{this.device.getSerialNumber(), message, ModernRoboticsReaderWriter.bufferToString(requestHeader.data), ModernRoboticsReaderWriter.bufferToString(responseHeader.data)});
        this.doExceptionBookkeeping();
        throw new RobotUsbProtocolException(message);
    }

    protected static String bufferToString(byte[] buffer) {
        StringBuilder result = new StringBuilder();
        result.append("[");
        if (buffer.length > 0) {
            result.append(String.format("%02x", buffer[0]));
        }
        int cbMax = 16;
        int cb = Math.min(buffer.length, cbMax);
        for (int ib = 1; ib < cb; ++ib) {
            result.append(String.format(" %02x", buffer[ib]));
        }
        if (cb < buffer.length) {
            result.append(" ...");
        }
        result.append("]");
        return result.toString();
    }
}

