/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.modernrobotics.comm;

import android.content.Context;
import com.qualcomm.hardware.HardwareFactory;
import com.qualcomm.hardware.R;
import com.qualcomm.hardware.modernrobotics.comm.ModernRoboticsReaderWriter;
import com.qualcomm.hardware.modernrobotics.comm.ReadWriteRunnable;
import com.qualcomm.hardware.modernrobotics.comm.ReadWriteRunnableSegment;
import com.qualcomm.robotcore.eventloop.SyncdDevice;
import com.qualcomm.robotcore.hardware.usb.RobotUsbDevice;
import com.qualcomm.robotcore.hardware.usb.RobotUsbModule;
import com.qualcomm.robotcore.util.ElapsedTime;
import com.qualcomm.robotcore.util.GlobalWarningSource;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.SerialNumber;
import com.qualcomm.robotcore.util.ThreadPool;
import com.qualcomm.robotcore.util.TypeConversion;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.firstinspires.ftc.robotcore.internal.hardware.TimeWindow;
import org.firstinspires.ftc.robotcore.internal.usb.exception.RobotUsbDeviceClosedException;
import org.firstinspires.ftc.robotcore.internal.usb.exception.RobotUsbException;
import org.firstinspires.ftc.robotcore.internal.usb.exception.RobotUsbProtocolException;
import org.firstinspires.ftc.robotcore.internal.usb.exception.RobotUsbStuckUsbWriteException;
import org.firstinspires.ftc.robotcore.internal.usb.exception.RobotUsbTimeoutException;

public class ReadWriteRunnableStandard
implements ReadWriteRunnable {
    public static final String TAG = "ReadWriteRunnable";
    protected final byte[] localDeviceReadCache = new byte[256];
    protected final byte[] localDeviceWriteCache = new byte[256];
    protected Map<Integer, ReadWriteRunnableSegment> segments = new HashMap<Integer, ReadWriteRunnableSegment>();
    protected ConcurrentLinkedQueue<Integer> segmentReadQueue = new ConcurrentLinkedQueue();
    protected ConcurrentLinkedQueue<Integer> segmentWriteQueue = new ConcurrentLinkedQueue();
    protected final Context context;
    protected final SerialNumber serialNumber;
    protected RobotUsbDevice robotUsbDevice;
    protected ModernRoboticsReaderWriter usbHandler;
    protected int startAddress;
    protected int monitorLength;
    protected boolean pruneBufferAfterRead;
    protected volatile boolean fullWriteNeeded;
    protected int ibActiveFirst;
    protected byte[] activeBuffer;
    protected TimeWindow activeBufferTimeWindow;
    protected CountDownLatch runningInterlock = new CountDownLatch(1);
    protected volatile boolean running = false;
    protected volatile SyncdDevice.ShutdownReason shutdownReason = SyncdDevice.ShutdownReason.NORMAL;
    protected volatile boolean shutdownComplete = false;
    private volatile boolean writeNeeded = false;
    protected final Object acceptingWritesLock = new Object();
    protected volatile boolean acceptingWrites = false;
    protected volatile boolean suppressReads = false;
    protected final Object readSupressionLock = new Object();
    protected ReadWriteRunnable.Callback callback;
    protected RobotUsbModule owner;
    protected final boolean debugLogging;
    protected static boolean DEBUG_SEGMENTS = false;

    public ReadWriteRunnableStandard(Context context, SerialNumber serialNumber, RobotUsbDevice device, int monitorLength, int startAddress, boolean debug) {
        this.context = context;
        this.serialNumber = serialNumber;
        this.startAddress = startAddress;
        this.monitorLength = monitorLength;
        this.fullWriteNeeded = false;
        this.pruneBufferAfterRead = true;
        this.debugLogging = debug;
        this.callback = new ReadWriteRunnable.EmptyCallback();
        this.owner = null;
        this.robotUsbDevice = device;
        this.usbHandler = new ModernRoboticsReaderWriter(device);
    }

    @Override
    public void setCallback(ReadWriteRunnable.Callback callback) {
        this.callback = callback;
    }

    public void setOwner(RobotUsbModule owner) {
        this.owner = owner;
    }

    public RobotUsbModule getOwner() {
        return this.owner;
    }

    @Override
    public boolean writeNeeded() {
        return this.writeNeeded;
    }

    @Override
    public void resetWriteNeeded() {
        this.writeNeeded = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(int address, byte[] data) {
        Object object = this.acceptingWritesLock;
        synchronized (object) {
            if (!this.acceptingWrites) return;
            byte[] byArray = this.localDeviceWriteCache;
            synchronized (this.localDeviceWriteCache) {
                System.arraycopy(data, 0, this.localDeviceWriteCache, address, data.length);
                this.writeNeeded = true;
                if (address >= this.startAddress) return;
                this.fullWriteNeeded = true;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suppressReads(boolean suppress) {
        Object object = this.readSupressionLock;
        synchronized (object) {
            this.suppressReads = suppress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readFromWriteCache(int address, int size) {
        byte[] byArray = this.localDeviceWriteCache;
        synchronized (this.localDeviceWriteCache) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return Arrays.copyOfRange(this.localDeviceWriteCache, address, address + size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read(int address, int size) {
        byte[] byArray = this.localDeviceReadCache;
        synchronized (this.localDeviceReadCache) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return Arrays.copyOfRange(this.localDeviceReadCache, address, address + size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeUsing(ExecutorService service) {
        ReadWriteRunnableStandard readWriteRunnableStandard = this;
        synchronized (readWriteRunnableStandard) {
            service.execute(this);
            this.awaitRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ReadWriteRunnableStandard readWriteRunnableStandard = this;
        synchronized (readWriteRunnableStandard) {
            if (this.running) {
                this.robotUsbDevice.requestReadInterrupt(true);
                this.running = false;
                while (!this.shutdownComplete) {
                    Thread.yield();
                }
            }
        }
    }

    @Override
    public ReadWriteRunnableSegment createSegment(int key, int address, int size) {
        ReadWriteRunnableSegment segment = new ReadWriteRunnableSegment(key, address, size);
        this.segments.put(key, segment);
        return segment;
    }

    @Override
    public void destroySegment(int key) {
        this.segments.remove(key);
    }

    @Override
    public ReadWriteRunnableSegment getSegment(int key) {
        return this.segments.get(key);
    }

    @Override
    public void queueSegmentRead(int key) {
        this.queueIfNotAlreadyQueued(key, this.segmentReadQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueSegmentWrite(int key) {
        Object object = this.acceptingWritesLock;
        synchronized (object) {
            if (this.acceptingWrites) {
                this.queueIfNotAlreadyQueued(key, this.segmentWriteQueue);
            }
        }
    }

    protected void awaitRunning() {
        try {
            this.runningInterlock.await();
        }
        catch (InterruptedException ignored) {
            while (this.runningInterlock.getCount() != 0L) {
                Thread.yield();
            }
            Thread.currentThread().interrupt();
        }
    }

    protected void setFullActive() {
        this.ibActiveFirst = 0;
        this.activeBuffer = new byte[this.monitorLength + this.startAddress];
        this.activeBufferTimeWindow = new TimeWindow();
    }

    protected boolean isFullActive() {
        return this.ibActiveFirst == 0 && this.startAddress > 0;
    }

    protected void setSuffixActive() {
        this.ibActiveFirst = this.startAddress;
        this.activeBuffer = new byte[this.monitorLength];
        this.activeBufferTimeWindow = new TimeWindow();
    }

    @Override
    public void run() {
        if (this.shutdownComplete) {
            return;
        }
        ThreadPool.logThreadLifeCycle((String)String.format("r/w loop: %s", HardwareFactory.getDeviceDisplayName(this.context, this.serialNumber)), (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ReadWriteRunnableStandard.this.fullWriteNeeded = false;
                ReadWriteRunnableStandard.this.pruneBufferAfterRead = true;
                ReadWriteRunnableStandard.this.setFullActive();
                ElapsedTime timer = new ElapsedTime();
                String timerString = "Device " + ReadWriteRunnableStandard.this.serialNumber;
                ReadWriteRunnableStandard.this.running = true;
                try {
                    ReadWriteRunnableStandard.this.callback.startupComplete();
                }
                catch (InterruptedException e) {
                    ReadWriteRunnableStandard.this.running = false;
                }
                ReadWriteRunnableStandard.this.runningInterlock.countDown();
                try {
                    while (ReadWriteRunnableStandard.this.running) {
                        if (ReadWriteRunnableStandard.this.debugLogging) {
                            timer.log(timerString);
                            timer.reset();
                        }
                        ReadWriteRunnableStandard.this.doReadCycle();
                        ReadWriteRunnableStandard.this.doWriteCycle();
                        ReadWriteRunnableStandard.this.usbHandler.throwIfTooManySequentialCommErrors();
                        if (ReadWriteRunnableStandard.this.robotUsbDevice.isOpen()) continue;
                        throw new RobotUsbDeviceClosedException("%s: closed", new Object[]{ReadWriteRunnableStandard.this.robotUsbDevice.getSerialNumber()});
                    }
                }
                catch (InterruptedException e) {
                    RobotLog.logExceptionHeader((String)ReadWriteRunnableStandard.TAG, (Exception)e, (String)"thread interrupt while communicating with %s", (Object[])new Object[]{HardwareFactory.getDeviceDisplayName(ReadWriteRunnableStandard.this.context, ReadWriteRunnableStandard.this.serialNumber)});
                }
                catch (RuntimeException | RobotUsbException e) {
                    if (e.getClass() != RobotUsbDeviceClosedException.class) {
                        RobotLog.ee((String)ReadWriteRunnableStandard.TAG, (Throwable)e, (String)"exception while communicating with %s", (Object[])new Object[]{HardwareFactory.getDeviceDisplayName(ReadWriteRunnableStandard.this.context, ReadWriteRunnableStandard.this.serialNumber)});
                    }
                    String format = ReadWriteRunnableStandard.this.context.getString(ReadWriteRunnableStandard.this.robotUsbDevice.isAttached() ? R.string.warningProblemCommunicatingWithUSBDevice : R.string.warningUSBDeviceDetached);
                    ReadWriteRunnableStandard.this.setOwnerWarningMessage(format, HardwareFactory.getDeviceDisplayName(ReadWriteRunnableStandard.this.context, ReadWriteRunnableStandard.this.serialNumber));
                    ReadWriteRunnableStandard.this.shutdownReason = e.getClass() == RobotUsbTimeoutException.class || e.getClass() == RobotUsbStuckUsbWriteException.class ? SyncdDevice.ShutdownReason.ABNORMAL_ATTEMPT_REOPEN : SyncdDevice.ShutdownReason.ABNORMAL;
                }
                finally {
                    ReadWriteRunnableStandard.this.usbHandler.close();
                    ReadWriteRunnableStandard.this.running = false;
                    try {
                        ReadWriteRunnableStandard.this.callback.shutdownComplete();
                    }
                    catch (InterruptedException e) {}
                    ReadWriteRunnableStandard.this.shutdownComplete = true;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void doReadCycle() throws InterruptedException, RobotUsbException {
        Object object = this.readSupressionLock;
        // MONITORENTER : object
        if (!this.suppressReads) {
            try {
                this.usbHandler.read(!this.isFullActive(), this.ibActiveFirst, this.activeBuffer, this.activeBufferTimeWindow);
                while (!this.segmentReadQueue.isEmpty()) {
                    ReadWriteRunnableSegment segment = this.segments.get(this.segmentReadQueue.remove());
                    byte[] readBuffer = new byte[segment.getReadBuffer().length];
                    this.usbHandler.read(segment.getRetryOnReadFailure(), segment.getAddress(), readBuffer, segment.getTimeWindow());
                    try {
                        segment.getReadLock().lock();
                        System.arraycopy(readBuffer, 0, segment.getReadBuffer(), 0, segment.getReadBuffer().length);
                        if (!DEBUG_SEGMENTS) continue;
                        this.dumpBuffers("segment " + segment.getAddress() + " read", readBuffer);
                    }
                    finally {
                        segment.getReadLock().unlock();
                    }
                }
            }
            catch (RobotUsbProtocolException e) {
                RobotLog.w((String)String.format("could not read %s: %s", HardwareFactory.getDeviceDisplayName(this.context, this.serialNumber), e.getMessage()));
            }
            byte[] byArray = this.localDeviceReadCache;
            // MONITORENTER : this.localDeviceReadCache
            System.arraycopy(this.activeBuffer, 0, this.localDeviceReadCache, this.ibActiveFirst, this.activeBuffer.length);
            // MONITOREXIT : byArray
        }
        // MONITOREXIT : object
        if (this.debugLogging) {
            this.dumpBuffers("read", this.localDeviceReadCache);
        }
        this.callback.readComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteCycle() throws InterruptedException, RobotUsbException {
        byte[] byArray = this.localDeviceWriteCache;
        synchronized (this.localDeviceWriteCache) {
            if (this.fullWriteNeeded) {
                this.setFullActive();
                this.fullWriteNeeded = false;
                this.pruneBufferAfterRead = true;
            } else if (this.pruneBufferAfterRead) {
                this.setSuffixActive();
                this.pruneBufferAfterRead = false;
            }
            System.arraycopy(this.localDeviceWriteCache, this.ibActiveFirst, this.activeBuffer, 0, this.activeBuffer.length);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                if (this.writeNeeded()) {
                    this.usbHandler.write(this.ibActiveFirst, this.activeBuffer);
                    this.resetWriteNeeded();
                }
                while (!this.segmentWriteQueue.isEmpty()) {
                    byte[] writeBuffer;
                    ReadWriteRunnableSegment segment = this.segments.get(this.segmentWriteQueue.remove());
                    try {
                        segment.getWriteLock().lock();
                        writeBuffer = Arrays.copyOf(segment.getWriteBuffer(), segment.getWriteBuffer().length);
                    }
                    finally {
                        segment.getWriteLock().unlock();
                    }
                    this.usbHandler.write(segment.getAddress(), writeBuffer);
                }
            }
            catch (RobotUsbProtocolException e) {
                RobotLog.w((String)String.format("could not write to %s: %s", HardwareFactory.getDeviceDisplayName(this.context, this.serialNumber), e.getMessage()));
            }
            if (this.debugLogging) {
                this.dumpBuffers("write", this.localDeviceWriteCache);
            }
            this.callback.writeComplete();
            return;
        }
    }

    void setOwnerWarningMessage(String format, Object ... args) {
        String message = String.format(format, args);
        if (this.owner != null && this.owner instanceof GlobalWarningSource) {
            ((GlobalWarningSource)this.owner).setGlobalWarning(message);
        } else {
            RobotLog.addGlobalWarningMessage((String)message);
        }
    }

    public SyncdDevice.ShutdownReason getShutdownReason() {
        return this.shutdownReason;
    }

    boolean hasPendingWrites() {
        return this.writeNeeded || !this.segmentWriteQueue.isEmpty();
    }

    @Override
    public void drainPendingWrites() {
        while (this.running && this.hasPendingWrites()) {
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAcceptingWrites(boolean acceptingWrites) {
        Object object = this.acceptingWritesLock;
        synchronized (object) {
            this.acceptingWrites = acceptingWrites;
        }
    }

    @Override
    public boolean getAcceptingWrites() {
        return this.acceptingWrites;
    }

    protected void dumpBuffers(String name, byte[] byteArray) {
        RobotLog.v((String)("Dumping " + name + " buffers for " + this.serialNumber));
        StringBuilder s = new StringBuilder(1024);
        for (int i = 0; i < this.startAddress + this.monitorLength; ++i) {
            s.append(String.format(" %02x", TypeConversion.unsignedByteToInt((byte)byteArray[i])));
            if ((i + 1) % 16 != 0) continue;
            s.append("\n");
        }
        RobotLog.v((String)s.toString());
    }

    protected void queueIfNotAlreadyQueued(int key, ConcurrentLinkedQueue<Integer> queue) {
        if (!queue.contains(key)) {
            queue.add(key);
        }
    }
}

