/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.modernrobotics.comm;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.qualcomm.hardware.modernrobotics.comm.ModernRoboticsDatagram;
import com.qualcomm.hardware.modernrobotics.comm.ModernRoboticsRequest;
import com.qualcomm.hardware.modernrobotics.comm.ModernRoboticsResponse;
import com.qualcomm.robotcore.hardware.DeviceManager;
import com.qualcomm.robotcore.hardware.usb.RobotUsbDevice;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.SerialNumber;
import org.firstinspires.ftc.robotcore.internal.collections.CircularByteBuffer;
import org.firstinspires.ftc.robotcore.internal.collections.MarkedItemQueue;
import org.firstinspires.ftc.robotcore.internal.hardware.TimeWindow;
import org.firstinspires.ftc.robotcore.internal.system.Misc;

public class RobotUsbDevicePretendModernRobotics
implements RobotUsbDevice {
    protected RobotUsbDevice.FirmwareVersion firmwareVersion = new RobotUsbDevice.FirmwareVersion();
    protected CircularByteBuffer circularByteBuffer = new CircularByteBuffer(0);
    protected MarkedItemQueue markedItemQueue = new MarkedItemQueue();
    protected boolean interruptRequested = false;
    protected SerialNumber serialNumber;
    protected DeviceManager.UsbDeviceType deviceType = DeviceManager.UsbDeviceType.FTDI_USB_UNKNOWN_DEVICE;
    protected boolean debugRetainBuffers = false;
    protected ModernRoboticsDatagram.AllocationContext<ModernRoboticsRequest> requestAllocationContext = new ModernRoboticsDatagram.AllocationContext();
    protected ModernRoboticsDatagram.AllocationContext<ModernRoboticsResponse> responseAllocationContext = new ModernRoboticsDatagram.AllocationContext();

    public RobotUsbDevicePretendModernRobotics(SerialNumber serialNumber) {
        this.serialNumber = serialNumber;
    }

    @NonNull
    public SerialNumber getSerialNumber() {
        return this.serialNumber;
    }

    @NonNull
    public String getProductName() {
        return Misc.formatForUser((String)"pretend %s", (Object[])new Object[]{this.deviceType});
    }

    public void setDeviceType(@NonNull DeviceManager.UsbDeviceType deviceType) {
        this.deviceType = deviceType;
    }

    @NonNull
    public DeviceManager.UsbDeviceType getDeviceType() {
        return this.deviceType;
    }

    public void close() {
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isAttached() {
        return true;
    }

    public void setDebugRetainBuffers(boolean retain) {
        this.debugRetainBuffers = retain;
    }

    public boolean getDebugRetainBuffers() {
        return this.debugRetainBuffers;
    }

    public void logRetainedBuffers(long nsOrigin, long nsTimerExpire, String tag, String format, Object ... args) {
        RobotLog.ee((String)tag, (String)format, (Object[])args);
    }

    public void setBaudRate(int i) {
    }

    public void setDataCharacteristics(byte b, byte b1, byte b2) {
    }

    public void setLatencyTimer(int i) {
    }

    public void setBreak(boolean enable) {
    }

    public void skipToLikelyUsbPacketStart() {
        int cbUnmarked = this.markedItemQueue.removeUpToNextMarkedItemOrEnd();
        this.circularByteBuffer.skip(cbUnmarked);
    }

    public boolean mightBeAtUsbPacketStart() {
        return this.markedItemQueue.isAtMarkedItem() || this.markedItemQueue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] bytes) {
        ModernRoboticsRequest request = null;
        ModernRoboticsResponse response = null;
        try {
            request = ModernRoboticsRequest.from(this.requestAllocationContext, bytes);
            if (0 != request.getFunction()) {
                throw new IllegalArgumentException("undefined function: " + request.getFunction());
            }
            if (request.isWrite()) {
                response = ModernRoboticsResponse.newInstance(this.responseAllocationContext, 0);
                response.setWrite(request.getFunction());
                response.setAddress(request.getAddress());
            } else {
                response = ModernRoboticsResponse.newInstance(this.responseAllocationContext, request.getPayloadLength());
                response.setRead(request.getFunction());
                response.setAddress(request.getAddress());
                response.setPayloadLength(request.getPayloadLength());
                response.clearPayload();
            }
            this.circularByteBuffer.write(response.data);
            this.markedItemQueue.addMarkedItem();
            this.markedItemQueue.addUnmarkedItems(response.data.length - 1);
            try {
                Thread.sleep(3L, 500000);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (request != null) {
                request.close();
            }
        }
    }

    public int read(byte[] bytes, int ibFirst, int cbToRead, long timeout, @Nullable TimeWindow timeWindow) {
        int cbRead = this.circularByteBuffer.read(bytes, ibFirst, cbToRead);
        this.markedItemQueue.removeItems(cbRead);
        if (timeWindow != null) {
            timeWindow.clear();
        }
        return cbRead;
    }

    public void resetAndFlushBuffers() {
        this.circularByteBuffer.clear();
        this.markedItemQueue.clear();
    }

    @NonNull
    public RobotUsbDevice.FirmwareVersion getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void setFirmwareVersion(RobotUsbDevice.FirmwareVersion version) {
        this.firmwareVersion = version;
    }

    public void requestReadInterrupt(boolean interruptRequested) {
        this.interruptRequested = interruptRequested;
    }

    public RobotUsbDevice.USBIdentifiers getUsbIdentifiers() {
        RobotUsbDevice.USBIdentifiers result = new RobotUsbDevice.USBIdentifiers();
        result.vendorId = 1027;
        result.productId = 0;
        result.bcdDevice = 0;
        return result;
    }
}

