/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.rev;

import com.qualcomm.hardware.broadcom.BroadcomColorSensor;
import com.qualcomm.hardware.broadcom.BroadcomColorSensorImpl;
import com.qualcomm.robotcore.hardware.ColorRangeSensor;
import com.qualcomm.robotcore.hardware.ControlSystem;
import com.qualcomm.robotcore.hardware.DistanceSensor;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.OpticalDistanceSensor;
import com.qualcomm.robotcore.hardware.configuration.annotations.DeviceProperties;
import com.qualcomm.robotcore.hardware.configuration.annotations.I2cDeviceType;
import com.qualcomm.robotcore.util.Range;
import java.nio.ByteOrder;
import java.util.Locale;
import org.firstinspires.ftc.robotcore.external.navigation.DistanceUnit;

@I2cDeviceType
@DeviceProperties(name="@string/rev_color_sensor_v3_name", description="@string/rev_color_sensor_v3_description", xmlTag="RevColorSensorV3", compatibleControlSystems={ControlSystem.REV_HUB}, builtIn=true)
public class RevColorSensorV3
extends BroadcomColorSensorImpl
implements DistanceSensor,
OpticalDistanceSensor,
ColorRangeSensor {
    protected static final double apiLevelMin = 0.0;
    protected static final double apiLevelMax = 1.0;
    double aParam = 325.961;
    double binvParam = -0.75934;
    double cParam = 26.98;
    double maxDist = 6.0;

    public RevColorSensorV3(I2cDeviceSynchSimple deviceClient, boolean deviceClientIsOwned) {
        super(BroadcomColorSensor.Parameters.createForAPDS9151(), deviceClient, deviceClientIsOwned);
    }

    @Override
    public String getDeviceName() {
        return "Rev Color Sensor v3";
    }

    @Override
    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.Broadcom;
    }

    public double getLightDetected() {
        return Range.clip((double)Range.scale((double)this.getRawLightDetected(), (double)0.0, (double)this.getRawLightDetectedMax(), (double)0.0, (double)1.0), (double)0.0, (double)1.0);
    }

    public double getRawLightDetected() {
        return this.rawOptical();
    }

    public double getRawLightDetectedMax() {
        return ((BroadcomColorSensor.Parameters)this.parameters).proximitySaturation;
    }

    public String status() {
        return String.format(Locale.getDefault(), "%s on %s", this.getDeviceName(), this.getConnectionInfo());
    }

    public double getDistance(DistanceUnit unit) {
        int rawOptical = this.rawOptical();
        double inOptical = this.inFromOptical(rawOptical);
        return unit.fromUnit(DistanceUnit.INCH, inOptical);
    }

    protected double inFromOptical(int rawOptical) {
        if ((double)rawOptical <= this.cParam) {
            return this.maxDist;
        }
        double dist = Math.pow(((double)rawOptical - this.cParam) / this.aParam, this.binvParam);
        return Math.min(dist, this.maxDist);
    }

    public int rawOptical() {
        return this.readUnsignedShort(BroadcomColorSensor.Register.PS_DATA, ByteOrder.LITTLE_ENDIAN) & 0x7FF;
    }
}

