/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.rev;

import com.qualcomm.hardware.rev.RevImuOrientationOnRobot;
import org.firstinspires.ftc.robotcore.external.matrices.MatrixF;
import org.firstinspires.ftc.robotcore.external.navigation.Orientation;
import org.firstinspires.ftc.robotcore.external.navigation.Quaternion;

public class RevHubOrientationOnRobot
extends RevImuOrientationOnRobot {
    public RevHubOrientationOnRobot(LogoFacingDirection logoFacingDirection, UsbFacingDirection usbFacingDirection) {
        this(RevHubOrientationOnRobot.friendlyApiToOrientation(logoFacingDirection, usbFacingDirection));
    }

    public RevHubOrientationOnRobot(Orientation rotation) {
        this(Quaternion.fromMatrix((MatrixF)rotation.getRotationMatrix(), (long)0L));
    }

    public RevHubOrientationOnRobot(Quaternion rotation) {
        super(rotation);
    }

    protected static Orientation friendlyApiToOrientation(LogoFacingDirection logoFacingDirection, UsbFacingDirection usbFacingDirection) {
        if (logoFacingDirection == LogoFacingDirection.UP) {
            if (usbFacingDirection == UsbFacingDirection.UP) {
                RevHubOrientationOnRobot.throwIllegalHubOrientationException();
            } else if (usbFacingDirection == UsbFacingDirection.DOWN) {
                RevHubOrientationOnRobot.throwIllegalHubOrientationException();
            } else {
                if (usbFacingDirection == UsbFacingDirection.FORWARD) {
                    return RevHubOrientationOnRobot.zyxOrientation(0.0, 0.0, 0.0);
                }
                if (usbFacingDirection == UsbFacingDirection.BACKWARD) {
                    return RevHubOrientationOnRobot.zyxOrientation(180.0, 0.0, 0.0);
                }
                if (usbFacingDirection == UsbFacingDirection.LEFT) {
                    return RevHubOrientationOnRobot.zyxOrientation(90.0, 0.0, 0.0);
                }
                if (usbFacingDirection == UsbFacingDirection.RIGHT) {
                    return RevHubOrientationOnRobot.zyxOrientation(-90.0, 0.0, 0.0);
                }
            }
        } else if (logoFacingDirection == LogoFacingDirection.DOWN) {
            if (usbFacingDirection == UsbFacingDirection.UP) {
                RevHubOrientationOnRobot.throwIllegalHubOrientationException();
            } else if (usbFacingDirection == UsbFacingDirection.DOWN) {
                RevHubOrientationOnRobot.throwIllegalHubOrientationException();
            } else {
                if (usbFacingDirection == UsbFacingDirection.FORWARD) {
                    return RevHubOrientationOnRobot.zyxOrientation(0.0, 180.0, 0.0);
                }
                if (usbFacingDirection == UsbFacingDirection.BACKWARD) {
                    return RevHubOrientationOnRobot.zyxOrientation(180.0, 180.0, 0.0);
                }
                if (usbFacingDirection == UsbFacingDirection.LEFT) {
                    return RevHubOrientationOnRobot.zyxOrientation(90.0, 180.0, 0.0);
                }
                if (usbFacingDirection == UsbFacingDirection.RIGHT) {
                    return RevHubOrientationOnRobot.zyxOrientation(-90.0, 180.0, 0.0);
                }
            }
        } else if (logoFacingDirection == LogoFacingDirection.FORWARD) {
            if (usbFacingDirection == UsbFacingDirection.UP) {
                return RevHubOrientationOnRobot.xyzOrientation(90.0, 180.0, 0.0);
            }
            if (usbFacingDirection == UsbFacingDirection.DOWN) {
                return RevHubOrientationOnRobot.xyzOrientation(-90.0, 0.0, 0.0);
            }
            if (usbFacingDirection == UsbFacingDirection.FORWARD) {
                RevHubOrientationOnRobot.throwIllegalHubOrientationException();
            } else if (usbFacingDirection == UsbFacingDirection.BACKWARD) {
                RevHubOrientationOnRobot.throwIllegalHubOrientationException();
            } else {
                if (usbFacingDirection == UsbFacingDirection.LEFT) {
                    return RevHubOrientationOnRobot.xyzOrientation(-90.0, 0.0, 90.0);
                }
                if (usbFacingDirection == UsbFacingDirection.RIGHT) {
                    return RevHubOrientationOnRobot.xyzOrientation(-90.0, 0.0, -90.0);
                }
            }
        } else if (logoFacingDirection == LogoFacingDirection.BACKWARD) {
            if (usbFacingDirection == UsbFacingDirection.UP) {
                return RevHubOrientationOnRobot.xyzOrientation(90.0, 0.0, 0.0);
            }
            if (usbFacingDirection == UsbFacingDirection.DOWN) {
                return RevHubOrientationOnRobot.xyzOrientation(90.0, 0.0, 180.0);
            }
            if (usbFacingDirection == UsbFacingDirection.FORWARD) {
                RevHubOrientationOnRobot.throwIllegalHubOrientationException();
            } else if (usbFacingDirection == UsbFacingDirection.BACKWARD) {
                RevHubOrientationOnRobot.throwIllegalHubOrientationException();
            } else {
                if (usbFacingDirection == UsbFacingDirection.LEFT) {
                    return RevHubOrientationOnRobot.xyzOrientation(90.0, 0.0, 90.0);
                }
                if (usbFacingDirection == UsbFacingDirection.RIGHT) {
                    return RevHubOrientationOnRobot.xyzOrientation(90.0, 0.0, -90.0);
                }
            }
        } else if (logoFacingDirection == LogoFacingDirection.LEFT) {
            if (usbFacingDirection == UsbFacingDirection.UP) {
                return RevHubOrientationOnRobot.xyzOrientation(90.0, -90.0, 0.0);
            }
            if (usbFacingDirection == UsbFacingDirection.DOWN) {
                return RevHubOrientationOnRobot.xyzOrientation(-90.0, -90.0, 0.0);
            }
            if (usbFacingDirection == UsbFacingDirection.FORWARD) {
                return RevHubOrientationOnRobot.xyzOrientation(0.0, -90.0, 0.0);
            }
            if (usbFacingDirection == UsbFacingDirection.BACKWARD) {
                return RevHubOrientationOnRobot.xyzOrientation(0.0, -90.0, 180.0);
            }
            if (usbFacingDirection == UsbFacingDirection.LEFT) {
                RevHubOrientationOnRobot.throwIllegalHubOrientationException();
            } else if (usbFacingDirection == UsbFacingDirection.RIGHT) {
                RevHubOrientationOnRobot.throwIllegalHubOrientationException();
            }
        } else if (logoFacingDirection == LogoFacingDirection.RIGHT) {
            if (usbFacingDirection == UsbFacingDirection.UP) {
                return RevHubOrientationOnRobot.zyxOrientation(90.0, 0.0, 90.0);
            }
            if (usbFacingDirection == UsbFacingDirection.DOWN) {
                return RevHubOrientationOnRobot.zyxOrientation(-90.0, 0.0, -90.0);
            }
            if (usbFacingDirection == UsbFacingDirection.FORWARD) {
                return RevHubOrientationOnRobot.zyxOrientation(0.0, 90.0, 0.0);
            }
            if (usbFacingDirection == UsbFacingDirection.BACKWARD) {
                return RevHubOrientationOnRobot.zyxOrientation(180.0, -90.0, 0.0);
            }
            if (usbFacingDirection == UsbFacingDirection.LEFT) {
                RevHubOrientationOnRobot.throwIllegalHubOrientationException();
            } else if (usbFacingDirection == UsbFacingDirection.RIGHT) {
                RevHubOrientationOnRobot.throwIllegalHubOrientationException();
            }
        }
        throw new RuntimeException("The FTC SDK developers forgot about this combination, please file a bug report.");
    }

    private static void throwIllegalHubOrientationException() {
        throw new IllegalArgumentException("The specified REV Hub orientation is physically impossible");
    }

    public static Orientation zyxOrientation(double z, double y, double x) {
        return RevImuOrientationOnRobot.zyxOrientation(z, y, x);
    }

    public static Orientation xyzOrientation(double x, double y, double z) {
        return RevImuOrientationOnRobot.xyzOrientation(x, y, z);
    }

    public static enum LogoFacingDirection {
        UP,
        DOWN,
        FORWARD,
        BACKWARD,
        LEFT,
        RIGHT;

    }

    public static enum UsbFacingDirection {
        UP,
        DOWN,
        FORWARD,
        BACKWARD,
        LEFT,
        RIGHT;

    }
}

