/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.inspection;

import android.content.Context;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupMenu;
import android.widget.TextView;
import com.qualcomm.robotcore.robocol.Command;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.ThreadPool;
import com.qualcomm.robotcore.wifi.NetworkType;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.firstinspires.ftc.robotcore.internal.network.DeviceNameManagerFactory;
import org.firstinspires.ftc.robotcore.internal.network.NetworkConnectionHandler;
import org.firstinspires.ftc.robotcore.internal.network.StartResult;
import org.firstinspires.ftc.robotcore.internal.network.WifiDirectAgent;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.ui.ThemedActivity;
import org.firstinspires.ftc.robotcore.internal.ui.UILocation;
import org.firstinspires.inspection.InspectionProperty;
import org.firstinspires.inspection.InspectionState;
import org.firstinspires.inspection.InspectionStateValidation;
import org.firstinspires.inspection.R;

public abstract class InspectionActivity
extends ThemedActivity {
    public static final String TAG = "InspectionActivity";
    private static final String INSPECTION_TAG = "INSPECTION";
    private static final boolean SHOW_TRAFFIC_STATS = false;
    private static final AppUtil appUtil = AppUtil.getInstance();
    private static final String notApplicable = "N/A";
    private static final String notInstalled = "Not installed";
    private static final String installed = "Installed";
    private static final String fwUnavailable = "firmware version unavailable";
    protected final boolean remoteConfigure = appUtil.isDriverStation() && this.inspectingRobotController();
    ValidatedInspectionItem airplaneMode;
    ValidatedInspectionItem bluetooth;
    ValidatedInspectionItem location;
    ValidatedInspectionItem rcPassword;
    ValidatedInspectionItem wifiEnabled;
    ValidatedInspectionItem wifiConnected;
    ValidatedInspectionItem wifiName;
    ValidatedInspectionItem androidVersion;
    ValidatedInspectionItem isRCInstalled;
    ValidatedInspectionItem rcMatchesDSVersion;
    ValidatedInspectionItem isDSInstalled;
    ValidatedInspectionItem osVersion;
    ValidatedInspectionItem firmwareVersion1;
    ValidatedInspectionItem firmwareVersion2;
    TextView batteryLevel;
    View hubFirmwareExtraLineLayout;
    View hubFirmwarePrimaryLine_layout;
    TextView trafficCount;
    TextView bytesPerSecond;
    TextView trafficCountLabel;
    TextView bytesPerSecondLabel;
    TextView txtManufacturer;
    TextView txtModel;
    TextView txtAppVersion;
    TextView osVersionLabel;
    LinearLayout osVersionLayout;
    LinearLayout airplaneModeLayout;
    LinearLayout rcPasswordLayout;
    ImageView autoInspectQr;
    TextView invalidQr;
    Pattern teamNoRegex;
    Future refreshFuture = null;
    int textOk = AppUtil.getColor((int)R.color.text_okay);
    int textWarning = AppUtil.getColor((int)R.color.text_warning);
    int textError = AppUtil.getColor((int)R.color.text_error);
    StartResult nameManagerStartResult = new StartResult();
    private boolean properWifiConnectedState;

    public String getTag() {
        return TAG;
    }

    protected FrameLayout getBackBar() {
        return (FrameLayout)this.findViewById(R.id.backbar);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_inspection);
        this.isRCInstalled = new ValidatedInspectionItem(R.id.txtIsRCInstalled, R.id.txtIsRCInstalled_img);
        this.rcMatchesDSVersion = new ValidatedInspectionItem(R.id.matchesDSVersion_txt, R.id.matchesDSVersion_img);
        this.isDSInstalled = new ValidatedInspectionItem(R.id.txtIsDSInstalled, R.id.txtIsDSInstalled_img);
        this.wifiName = new ValidatedInspectionItem(R.id.wifiName, R.id.wifiName_img);
        this.trafficCount = (TextView)this.findViewById(R.id.trafficCount);
        this.bytesPerSecond = (TextView)this.findViewById(R.id.bytesPerSecond);
        this.trafficCountLabel = (TextView)this.findViewById(R.id.trafficCountLabel);
        this.bytesPerSecondLabel = (TextView)this.findViewById(R.id.bytesPerSecondLabel);
        this.wifiEnabled = new ValidatedInspectionItem(R.id.wifiEnabled, R.id.wifiEnabled_img);
        this.batteryLevel = (TextView)this.findViewById(R.id.batteryLevel);
        this.androidVersion = new ValidatedInspectionItem(R.id.androidVersion, R.id.androidVersion_img);
        this.osVersion = new ValidatedInspectionItem(R.id.osVersion, R.id.osVersion_img);
        this.firmwareVersion1 = new ValidatedInspectionItem(R.id.hubFirmwarePrimaryLine, R.id.hubFirmware_img);
        this.firmwareVersion2 = new ValidatedInspectionItem(R.id.hubFirmwareExtraLine, R.id.hubFirmwareExtraLine_img);
        this.hubFirmwareExtraLineLayout = this.findViewById(R.id.hubFirmwareExtraLine_layout);
        this.hubFirmwarePrimaryLine_layout = this.findViewById(R.id.hubFirmwarePrimaryLine_layout);
        this.airplaneMode = new ValidatedInspectionItem(R.id.airplaneMode, R.id.airplaneMode_img);
        this.bluetooth = new ValidatedInspectionItem(R.id.bluetoothEnabled, R.id.bluetoothEnabled_img);
        this.location = new ValidatedInspectionItem(R.id.locationEnabled, R.id.locationEnabled_img);
        this.wifiConnected = new ValidatedInspectionItem(R.id.wifiConnected, R.id.wifiConnected_img);
        this.txtAppVersion = (TextView)this.findViewById(R.id.textDeviceName);
        this.rcPassword = new ValidatedInspectionItem(R.id.isDefaultPassword, R.id.isDefaultPassword_img);
        this.osVersionLabel = (TextView)this.findViewById(R.id.osVersionLabel);
        this.osVersionLayout = (LinearLayout)this.findViewById(R.id.osVersionLayout);
        this.airplaneModeLayout = (LinearLayout)this.findViewById(R.id.airplaneModeLayout);
        this.rcPasswordLayout = (LinearLayout)this.findViewById(R.id.rcPasswordLayout);
        this.autoInspectQr = (ImageView)this.findViewById(R.id.autoInspectQr);
        this.invalidQr = (TextView)this.findViewById(R.id.invalidQr);
        this.txtAppVersion.setText((CharSequence)(this.inspectingRobotController() ? this.getString(R.string.titleInspectionReportRC) : this.getString(R.string.titleInspectionReportDS)));
        if (!this.inspectingRobotController()) {
            this.rcPasswordLayout.setVisibility(8);
            this.hubFirmwarePrimaryLine_layout.setVisibility(8);
            this.hubFirmwareExtraLineLayout.setVisibility(8);
            this.autoInspectQr.setVisibility(8);
            this.invalidQr.setVisibility(8);
        }
        if (!this.inspectingRemoteDevice()) {
            this.rcMatchesDSVersion.setVisibility(8);
            this.findViewById(R.id.matchesDSVersionLabel).setVisibility(8);
            this.autoInspectQr.setVisibility(8);
            this.invalidQr.setVisibility(8);
        }
        this.txtManufacturer = (TextView)this.findViewById(R.id.txtManufacturer);
        this.txtModel = (TextView)this.findViewById(R.id.txtModel);
        this.teamNoRegex = Pattern.compile("^\\d{1,5}(-\\w)?-(RC|DS)\\z", 2);
        ImageButton buttonMenu = (ImageButton)this.findViewById(R.id.menu_buttons);
        buttonMenu.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PopupMenu popupMenu = new PopupMenu((Context)InspectionActivity.this, v);
                popupMenu.setOnMenuItemClickListener(new PopupMenu.OnMenuItemClickListener(){

                    public boolean onMenuItemClick(MenuItem item) {
                        return InspectionActivity.this.onOptionsItemSelected(item);
                    }
                });
                popupMenu.inflate(InspectionActivity.this.getMenu());
                popupMenu.show();
            }
        });
        DeviceNameManagerFactory.getInstance().start(this.nameManagerStartResult);
        this.properWifiConnectedState = false;
        NetworkType networkType = NetworkConnectionHandler.getNetworkType((Context)this);
        if (networkType == NetworkType.WIRELESSAP) {
            this.makeWirelessAPModeSane();
        }
        this.enableTrafficDataReporting(false);
        this.refresh();
    }

    protected void enableTrafficDataReporting(boolean enable) {
        if (enable) {
            this.trafficCount.setVisibility(0);
            this.bytesPerSecond.setVisibility(0);
            this.trafficCountLabel.setVisibility(0);
            this.bytesPerSecondLabel.setVisibility(0);
        } else {
            this.trafficCount.setVisibility(8);
            this.bytesPerSecond.setVisibility(8);
            this.trafficCountLabel.setVisibility(8);
            this.bytesPerSecondLabel.setVisibility(8);
        }
    }

    protected void makeWirelessAPModeSane() {
        TextView labelWifiName = (TextView)this.findViewById(R.id.labelWifiName);
        labelWifiName.setText((CharSequence)this.getString(R.string.wifiAccessPointLabel));
        this.properWifiConnectedState = true;
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(R.menu.inspection_menu_rcds_local, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.disconnect_from_wifidirect) {
            if (!this.remoteConfigure) {
                if (WifiDirectAgent.getInstance().disconnectFromWifiDirect()) {
                    this.showToast(this.getString(R.string.toastDisconnectedFromWifiDirect));
                } else {
                    this.showToast(this.getString(R.string.toastErrorDisconnectingFromWifiDirect));
                }
            } else {
                NetworkConnectionHandler.getInstance().sendCommand(new Command("CMD_DISCONNECT_FROM_WIFI_DIRECT"));
            }
            return true;
        }
        if (id2 == R.id.disable_bluetooth) {
            if (this.remoteConfigure) {
                NetworkConnectionHandler.getInstance().sendCommand(new Command("CMD_DISABLE_BLUETOOTH"));
            } else {
                AppUtil.getInstance().setBluetoothEnabled(false);
            }
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onResume() {
        super.onResume();
        this.startRefreshing();
    }

    protected void onPause() {
        super.onPause();
        this.stopRefreshing();
    }

    protected void onDestroy() {
        super.onDestroy();
        DeviceNameManagerFactory.getInstance().stop(this.nameManagerStartResult);
    }

    private void startRefreshing() {
        this.stopRefreshing();
        int msInterval = 5000;
        this.refreshFuture = ThreadPool.getDefaultScheduler().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                appUtil.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        InspectionActivity.this.refresh();
                    }
                });
            }
        }, msInterval, msInterval, TimeUnit.MILLISECONDS);
    }

    private void stopRefreshing() {
        if (this.refreshFuture != null) {
            this.refreshFuture.cancel(false);
            this.refreshFuture = null;
        }
    }

    private void refresh(ValidatedInspectionItem item, InspectionProperty property, String message, String ... formatArgs) {
        if (!property.valid) {
            final String context = this.getResources().getString(property.contextResourceId, (Object[])formatArgs);
            RobotLog.ee((String)INSPECTION_TAG, (String)context);
            item.img.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    appUtil.showToast(UILocation.BOTH, context, 1);
                }
            });
        } else {
            item.img.setOnClickListener(null);
        }
        item.txt.setText((CharSequence)message);
        item.img.setImageResource(property.valid ? R.drawable.ic_check_circle : (property.invalidAs == InspectionProperty.InvalidAs.WARNING ? R.drawable.ic_warning : R.drawable.ic_error));
    }

    private void refreshTrafficCount(TextView view, long rxData, long txData) {
        view.setText((CharSequence)String.format("%d/%d", rxData, txData));
    }

    private void refreshTrafficStats(InspectionState state) {
    }

    private void refresh(TextView view, long data) {
        view.setText((CharSequence)String.format("%d", data));
    }

    protected void refresh() {
        InspectionState state = new InspectionState();
        state.initializeLocal(DeviceNameManagerFactory.getInstance());
        this.refresh(state);
    }

    protected InspectionStateValidation getValidation(InspectionState state, boolean inspectingRc) {
        InspectionStateValidation validation = new InspectionStateValidation();
        validation.wifi = new InspectionProperty(state.wifiEnabled, R.string.wifiEnabledContext);
        validation.bluetooth = new InspectionProperty(!state.bluetoothOn, R.string.bluetoothOnContext);
        validation.localNetworks = new InspectionProperty(state.wifiConnected == this.properWifiConnectedState, R.string.noContext);
        validation.os = new InspectionProperty(this.isValidAndroidVersion(state), R.string.osContext);
        if (state.firmwareVersion == null || state.firmwareVersion.equals(notApplicable)) {
            validation.firmware = new InspectionProperty(true, R.string.firmwareContext);
        } else {
            String[] firmwareStrings = state.firmwareVersion.replace("Expansion Hub", "EH").replace("Control Hub", "CH").split("\n");
            validation.firmware = new InspectionProperty(this.isValidFirmwareVersion(firmwareStrings[0]), R.string.firmwareContext);
            if (firmwareStrings.length > 1) {
                validation.firmware = new InspectionProperty(validation.firmware.valid && this.isValidFirmwareVersion(firmwareStrings[1]), R.string.firmwareContext);
            }
        }
        validation.name = new InspectionProperty(this.isValidDeviceName(state), R.string.deviceNameContext);
        boolean inspectingControlHub = !"".equals(state.controlHubOsVersion);
        boolean inspectingDriverHub = !"".equals(state.driverHubOsVersion);
        validation.rev = new InspectionProperty(inspectingControlHub || inspectingDriverHub, R.string.noContext);
        if (validation.rev.valid) {
            validation.os = new InspectionProperty(inspectingControlHub && this.isValidControlHubOsVersion(state) || inspectingDriverHub && this.isValidDriverHubOsVersion(state), inspectingDriverHub ? R.string.driverHubOsContext : R.string.controlHubOsContext);
        }
        validation.password = new InspectionProperty(!state.isDefaultPassword || !inspectingControlHub, R.string.defaultPasswordContext);
        validation.airplaneMode = new InspectionProperty(state.airplaneModeOn || !validation.rev.valid, R.string.airplaneModeOnContext);
        boolean appIsObsolete = appUtil.appIsObsolete(appUtil.getYearMonthFromIso8601(state.appBuildTime));
        if (inspectingRc) {
            int resId = !state.robotControllerInstalled ? R.string.robotControllerIsNotInstalledContext : (state.majorSdkVersion < 10 ? R.string.sdkVersionMismatchContext : (appIsObsolete ? R.string.robotControllerIsObsoleteContext : R.string.noContext));
            validation.appVersion = new InspectionProperty(state.robotControllerInstalled && state.majorSdkVersion >= 10 && !appIsObsolete, resId, InspectionProperty.InvalidAs.WARNING);
            validation.otherApp = new InspectionProperty(!state.driverStationInstalled, R.string.driverStationInstalledOnRobotControllerContext);
            if (this.inspectingRemoteDevice()) {
                validation.versionsMatch = new InspectionProperty(state.majorSdkVersion == 10 && state.minorSdkVersion == 1, R.string.sdkVersionMismatchContext, InspectionProperty.InvalidAs.WARNING);
            }
        } else {
            validation.appVersion = new InspectionProperty(state.driverStationInstalled && state.majorSdkVersion >= 10 && !appIsObsolete, R.string.driverStationIsObsoleteContext, InspectionProperty.InvalidAs.WARNING);
            validation.otherApp = new InspectionProperty(!state.robotControllerInstalled, R.string.robotControllerInstalledOnDriverStationContext);
        }
        return validation;
    }

    protected void refresh(InspectionState state) {
        boolean inspectingDriverHub;
        InspectionStateValidation validated = this.getValidation(state, this.inspectingRobotController());
        this.refresh(this.wifiEnabled, validated.wifi, state.wifiEnabled ? "Yes" : "No", new String[0]);
        this.refreshTrafficStats(state);
        this.refresh(this.bluetooth, validated.bluetooth, state.bluetoothOn ? "Enabled" : "Disabled", new String[0]);
        this.refresh(this.wifiConnected, validated.localNetworks, state.wifiConnected ? "Yes" : "No", new String[0]);
        if (state.sdkInt >= 26) {
            this.refresh(this.location, new InspectionProperty(state.locationEnabled, R.string.locationEnabledContext), state.locationEnabled ? "Enabled" : "Disabled", new String[0]);
        } else {
            this.location.setVisibility(8);
            this.findViewById(R.id.locationLabel).setVisibility(8);
        }
        this.txtManufacturer.setText((CharSequence)state.manufacturer);
        this.txtModel.setText((CharSequence)state.model);
        this.refresh(this.androidVersion, new InspectionProperty(this.isValidAndroidVersion(state), R.string.osContext), state.osVersion, this.getValidAndroidVersionString());
        if (state.firmwareVersion == null || state.firmwareVersion.equals(notApplicable)) {
            this.refresh(this.firmwareVersion1, new InspectionProperty(false, R.string.firmwareContext), notApplicable, "");
            this.hubFirmwareExtraLineLayout.setVisibility(8);
        } else {
            String[] firmwareStrings = state.firmwareVersion.replace("Expansion Hub", "EH").replace("Control Hub", "CH").split("\n");
            this.refresh(this.firmwareVersion1, new InspectionProperty(this.isValidFirmwareVersion(firmwareStrings[0]), R.string.firmwareContext), firmwareStrings[0].replace(fwUnavailable, notApplicable), this.getValidFirmwareVersionString());
            if (firmwareStrings.length > 1) {
                this.refresh(this.firmwareVersion2, new InspectionProperty(this.isValidFirmwareVersion(firmwareStrings[1]), R.string.firmwareContext), firmwareStrings[1].replace(fwUnavailable, notApplicable), this.getValidFirmwareVersionString());
            } else {
                this.hubFirmwareExtraLineLayout.setVisibility(8);
            }
        }
        this.refresh(this.wifiName, validated.name, state.deviceName, new String[0]);
        this.batteryLevel.setText((CharSequence)(Math.round(state.batteryFraction * 100.0) + "%"));
        this.batteryLevel.setTextColor(state.batteryFraction > 0.6 ? this.textOk : this.textWarning);
        this.refresh(this.rcPassword, validated.password, state.isDefaultPassword ? "Default" : "Not default", new String[0]);
        boolean inspectingControlHub = !"".equals(state.controlHubOsVersion);
        boolean bl = inspectingDriverHub = !"".equals(state.driverHubOsVersion);
        if (!validated.rev.valid) {
            this.osVersionLayout.setVisibility(8);
        } else {
            this.osVersionLayout.setVisibility(0);
            if (inspectingControlHub) {
                this.osVersionLabel.setText(R.string.controlHubOsVersionLabel);
                this.refresh(this.osVersion, validated.os, state.controlHubOsVersion, "1.1.2");
            } else {
                this.osVersionLabel.setText(R.string.driverHubOsVersionLabel);
                this.refresh(this.osVersion, validated.os, state.driverHubOsVersion, "1.1.0");
            }
        }
        if (!inspectingControlHub) {
            this.rcPasswordLayout.setVisibility(8);
        }
        if (validated.rev.valid) {
            this.airplaneModeLayout.setVisibility(8);
        } else {
            this.airplaneModeLayout.setVisibility(0);
            this.refresh(this.airplaneMode, validated.airplaneMode, state.airplaneModeOn ? "Enabled" : "Disabled", new String[0]);
        }
        if (this.inspectingRobotController()) {
            this.refresh(this.isRCInstalled, validated.appVersion, AppUtil.getSdkVersionString((int)state.majorSdkVersion, (int)state.minorSdkVersion, (int)state.pointSdkVersion), String.format("%d.%d", state.majorSdkVersion, state.minorSdkVersion), String.format("%d.%d", 10, 1));
            this.refresh(this.isDSInstalled, validated.otherApp, state.driverStationInstalled ? installed : notInstalled, new String[0]);
            if (this.inspectingRemoteDevice()) {
                this.refresh(this.rcMatchesDSVersion, validated.versionsMatch, validated.versionsMatch.valid ? "Yes" : this.getString(R.string.dsVersionMismatch, new Object[]{10, 1}), String.format("%d.%d", state.majorSdkVersion, state.minorSdkVersion), String.format("%d.%d", 10, 1));
            }
        } else {
            this.refresh(this.isDSInstalled, validated.appVersion, AppUtil.getSdkVersionString((int)state.majorSdkVersion, (int)state.minorSdkVersion, (int)state.pointSdkVersion), new String[0]);
            this.refresh(this.isRCInstalled, validated.otherApp, state.robotControllerInstalled ? installed : notInstalled, new String[0]);
        }
    }

    public String getValidAndroidVersionString() {
        switch (this.getValidAndroidVersion()) {
            case 23: {
                return "Marshmallow (Android 6)";
            }
        }
        throw new RuntimeException("Unknown version code");
    }

    public int getValidAndroidVersion() {
        return 23;
    }

    public boolean isValidAndroidVersion(InspectionState state) {
        return state.sdkInt >= this.getValidAndroidVersion();
    }

    public boolean isValidControlHubOsVersion(InspectionState state) {
        return state.controlHubOsVersionNum >= 6;
    }

    public boolean isValidDriverHubOsVersion(InspectionState state) {
        return state.driverHubOsVersionNum >= 21;
    }

    public String getValidFirmwareVersionString() {
        return "1.8.2";
    }

    public boolean isValidFirmwareVersion(String string2) {
        return string2 == null || string2.contains(notApplicable) || !string2.contains("1.6.0") && !string2.contains("1.7.0") && !string2.contains("1.7.2") && !string2.contains(fwUnavailable);
    }

    public boolean isValidDeviceName(InspectionState state) {
        if (state.deviceName.contains("\n") || state.deviceName.contains("\r")) {
            return false;
        }
        return this.teamNoRegex.matcher(state.deviceName).find();
    }

    protected abstract boolean inspectingRobotController();

    protected abstract boolean inspectingRemoteDevice();

    protected abstract int getMenu();

    private void showToast(String message) {
        appUtil.showToast(UILocation.BOTH, message);
    }

    class ValidatedInspectionItem {
        TextView txt;
        ImageView img;

        ValidatedInspectionItem(int txtId, int imgId) {
            this.txt = (TextView)InspectionActivity.this.findViewById(txtId);
            this.img = (ImageView)InspectionActivity.this.findViewById(imgId);
        }

        void setVisibility(int visibility) {
            this.txt.setVisibility(visibility);
            this.img.setVisibility(visibility);
        }
    }
}

