/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.inspection;

import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.Build;
import com.google.gson.annotations.SerializedName;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import com.qualcomm.robotcore.util.Device;
import com.qualcomm.robotcore.wifi.NetworkType;
import java.util.List;
import org.firstinspires.ftc.robotcore.internal.collections.SimpleGson;
import org.firstinspires.ftc.robotcore.internal.hardware.CachedLynxModulesInfo;
import org.firstinspires.ftc.robotcore.internal.network.ApChannelManagerFactory;
import org.firstinspires.ftc.robotcore.internal.network.DeviceNameManager;
import org.firstinspires.ftc.robotcore.internal.network.DeviceNameManagerFactory;
import org.firstinspires.ftc.robotcore.internal.network.NetworkConnectionHandler;
import org.firstinspires.ftc.robotcore.internal.network.PasswordManagerFactory;
import org.firstinspires.ftc.robotcore.internal.network.StartResult;
import org.firstinspires.ftc.robotcore.internal.network.WifiDirectAgent;
import org.firstinspires.ftc.robotcore.internal.network.WifiUtil;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.inspection.QrExclude;

public class InspectionState {
    public static final String robotControllerPackage = "com.qualcomm.ftcrobotcontroller";
    public static final String driverStationPackage = "com.qualcomm.ftcdriverstation";
    public static final String NO_VERSION = "";
    public static final int NO_VERSION_CODE = 0;
    @SerializedName(value="mfr")
    public String manufacturer;
    @SerializedName(value="mdl")
    public String model;
    @SerializedName(value="dev")
    public String deviceCodename;
    @SerializedName(value="os")
    public String osVersion;
    @SerializedName(value="chOs")
    public String controlHubOsVersion = "";
    @SerializedName(value="dhOs")
    public String driverHubOsVersion;
    @SerializedName(value="chOsNum")
    public int controlHubOsVersionNum;
    @SerializedName(value="dhOsNum")
    public int driverHubOsVersionNum;
    @SerializedName(value="fw")
    public String firmwareVersion;
    @SerializedName(value="sdk")
    public int sdkInt;
    @SerializedName(value="am")
    public boolean airplaneModeOn;
    @SerializedName(value="bt")
    public boolean bluetoothOn;
    @SerializedName(value="wfEn")
    public boolean wifiEnabled;
    @SerializedName(value="wfConn")
    public boolean wifiConnected;
    @SerializedName(value="wfDirEn")
    public boolean wifiDirectEnabled;
    @SerializedName(value="wfDirConn")
    public boolean wifiDirectConnected;
    @SerializedName(value="wfc")
    public int wifiChannel;
    @SerializedName(value="loc")
    public boolean locationEnabled;
    @SerializedName(value="name")
    public String deviceName;
    @SerializedName(value="bat")
    public double batteryFraction;
    @SerializedName(value="rcIn")
    public boolean robotControllerInstalled;
    @SerializedName(value="dsIn")
    public boolean driverStationInstalled;
    @SerializedName(value="aVmj")
    public int majorSdkVersion;
    @SerializedName(value="aVmn")
    public int minorSdkVersion;
    @SerializedName(value="aVpt")
    public int pointSdkVersion;
    @SerializedName(value="bldTs")
    public String appBuildTime;
    @QrExclude
    public long rxDataCount;
    @QrExclude
    public long txDataCount;
    @QrExclude
    public long bytesPerSecond;
    @SerializedName(value="pw")
    public boolean isDefaultPassword;

    public void initializeLocal() {
        DeviceNameManager nameManager = DeviceNameManagerFactory.getInstance();
        StartResult startResult = new StartResult();
        nameManager.start(startResult);
        this.initializeLocal(nameManager);
        nameManager.stop(startResult);
    }

    public void initializeLocal(DeviceNameManager nameManager) {
        this.manufacturer = Build.MANUFACTURER;
        this.model = Build.MODEL;
        this.deviceCodename = Build.DEVICE;
        this.osVersion = Build.VERSION.RELEASE;
        this.firmwareVersion = InspectionState.getFirmwareInspectionVersions();
        this.sdkInt = Build.VERSION.SDK_INT;
        this.airplaneModeOn = WifiUtil.isAirplaneModeOn();
        this.bluetoothOn = WifiUtil.isBluetoothOn();
        this.wifiEnabled = WifiUtil.isWifiEnabled();
        this.batteryFraction = this.getLocalBatteryFraction();
        this.majorSdkVersion = 10;
        this.minorSdkVersion = 1;
        this.pointSdkVersion = 0;
        this.appBuildTime = "2024-09-19T13:09:54.915-0700";
        this.driverStationInstalled = !this.getPackageVersionString(driverStationPackage).equals(NO_VERSION);
        this.robotControllerInstalled = !this.getPackageVersionString(robotControllerPackage).equals(NO_VERSION);
        this.deviceName = nameManager.getDeviceName();
        if (Device.isRevDriverHub()) {
            this.driverHubOsVersion = LynxConstants.getDriverHubOsVersion();
            this.driverHubOsVersionNum = LynxConstants.getDriverHubOsVersionCode();
        } else {
            this.driverHubOsVersion = NO_VERSION;
            this.driverHubOsVersionNum = 0;
        }
        NetworkConnectionHandler networkConnectionHandler = NetworkConnectionHandler.getInstance();
        NetworkType networkType = networkConnectionHandler.getNetworkType();
        if (networkType == NetworkType.WIRELESSAP || networkType == NetworkType.RCWIRELESSAP) {
            if (Device.isRevControlHub()) {
                this.controlHubOsVersion = LynxConstants.getControlHubOsVersion();
                if (this.controlHubOsVersion == null) {
                    this.controlHubOsVersion = "unknown";
                }
                this.controlHubOsVersionNum = LynxConstants.getControlHubOsVersionCode();
                this.isDefaultPassword = PasswordManagerFactory.getInstance().isDefault();
                this.wifiEnabled = WifiUtil.isWifiApEnabled();
                if (this.wifiEnabled) {
                    this.wifiConnected = true;
                }
            } else {
                this.controlHubOsVersion = NO_VERSION;
                this.controlHubOsVersionNum = 0;
                this.deviceName = WifiUtil.getConnectedSsid();
                this.wifiDirectEnabled = WifiUtil.isWifiEnabled();
                this.wifiConnected = WifiUtil.isWifiConnected();
            }
            this.wifiDirectConnected = false;
        } else {
            this.wifiConnected = WifiDirectAgent.getInstance().isWifiConnected();
            this.wifiDirectEnabled = WifiDirectAgent.getInstance().isWifiDirectEnabled();
            this.wifiDirectConnected = WifiDirectAgent.getInstance().isWifiDirectConnected();
        }
        this.wifiChannel = ApChannelManagerFactory.getInstance().getCurrentChannel().channelNum;
        this.locationEnabled = WifiUtil.areLocationServicesEnabled();
        this.rxDataCount = networkConnectionHandler.getRxDataCount();
        this.txDataCount = networkConnectionHandler.getTxDataCount();
        this.bytesPerSecond = networkConnectionHandler.getBytesPerSecond();
    }

    protected double getLocalBatteryFraction() {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent batteryStatus = AppUtil.getInstance().getApplication().registerReceiver(null, intentFilter);
        int level = batteryStatus.getIntExtra("level", -1);
        int scale = batteryStatus.getIntExtra("scale", -1);
        return (double)level / (double)scale;
    }

    protected String getPackageVersionString(String packageName) {
        PackageManager pm = AppUtil.getDefContext().getPackageManager();
        try {
            return pm.getPackageInfo((String)packageName, (int)128).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            return NO_VERSION;
        }
    }

    public String serialize() {
        return SimpleGson.getInstance().toJson((Object)this);
    }

    public static InspectionState deserialize(String serialized) {
        return (InspectionState)SimpleGson.getInstance().fromJson(serialized, InspectionState.class);
    }

    private static String getFirmwareInspectionVersions() {
        List versions = CachedLynxModulesInfo.getLynxModulesInfo();
        if (versions == null || versions.isEmpty()) {
            return "N/A";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < versions.size(); ++i) {
            stringBuilder.append(String.format("[%s] %s", ((CachedLynxModulesInfo.LynxModuleInfo)versions.get((int)i)).name, ((CachedLynxModulesInfo.LynxModuleInfo)versions.get((int)i)).firmwareVersion));
            if (i >= versions.size() - 1) continue;
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

