/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.inspection;

import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.journeyapps.barcodescanner.BarcodeEncoder;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.configuration.ControllerConfiguration;
import com.qualcomm.robotcore.hardware.configuration.DeviceConfiguration;
import com.qualcomm.robotcore.hardware.configuration.LynxModuleConfiguration;
import com.qualcomm.robotcore.hardware.configuration.ReadXMLFileHandler;
import com.qualcomm.robotcore.hardware.configuration.ServoHubConfiguration;
import com.qualcomm.robotcore.hardware.configuration.WebcamConfiguration;
import com.qualcomm.robotcore.robocol.Command;
import com.qualcomm.robotcore.util.RobotLog;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.zip.Deflater;
import nl.minvws.encoding.Base45;
import org.firstinspires.ftc.robotcore.internal.collections.SimpleGson;
import org.firstinspires.ftc.robotcore.internal.network.CallbackResult;
import org.firstinspires.ftc.robotcore.internal.network.NetworkConnectionHandler;
import org.firstinspires.ftc.robotcore.internal.network.RecvLoopRunnable;
import org.firstinspires.ftc.robotcore.internal.opmode.OpModeMeta;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.usb.VendorProductSerialNumber;
import org.firstinspires.inspection.GamepadInspection;
import org.firstinspires.inspection.InspectionActivity;
import org.firstinspires.inspection.InspectionProperty;
import org.firstinspires.inspection.InspectionState;
import org.firstinspires.inspection.QrData;
import org.firstinspires.inspection.QrExclude;
import org.firstinspires.inspection.R;
import org.firstinspires.inspection.SurveyData;

public class RcInspectionActivity
extends InspectionActivity {
    private InspectionState rcInspectionState;
    private List<OpModeMeta> opModes;
    private List<ControllerConfiguration> controllerList = new ArrayList<ControllerConfiguration>();
    private ArrayList<Integer> gamepads;
    private Boolean advancedGamepadFeatures;
    private View topBar;
    public static final String GAMEPAD_KEY = "gamepads";
    public static final String ADVANCED_FEATURES_KEY = "advancedFeatures";
    private static Gson qrGson;
    final RecvLoopRunnable.RecvLoopCallback recvLoopCallback = new RecvLoopRunnable.DegenerateCallback(){

        public CallbackResult commandEvent(Command command) throws RobotCoreException {
            if (RcInspectionActivity.this.remoteConfigure) {
                switch (command.getName()) {
                    case "CMD_REQUEST_INSPECTION_REPORT_RESP": {
                        final InspectionState rcState = InspectionState.deserialize(command.getExtra());
                        RcInspectionActivity.this.rcInspectionState = rcState;
                        AppUtil.getInstance().runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                RcInspectionActivity.this.refresh(rcState);
                            }
                        });
                        RcInspectionActivity.this.refreshQr();
                        return CallbackResult.HANDLED;
                    }
                    case "CMD_NOTIFY_OP_MODE_LIST": {
                        RcInspectionActivity.this.opModes = (List)SimpleGson.getInstance().fromJson(command.getExtra(), new TypeToken<Collection<OpModeMeta>>(){}.getType());
                        RcInspectionActivity.this.refreshQr();
                        return CallbackResult.HANDLED_CONTINUE;
                    }
                    case "CMD_NOTIFY_ACTIVE_CONFIGURATION": {
                        NetworkConnectionHandler.getInstance().sendCommand(new Command("CMD_REQUEST_PARTICULAR_CONFIGURATION", command.getExtra()));
                        return CallbackResult.HANDLED_CONTINUE;
                    }
                    case "CMD_REQUEST_PARTICULAR_CONFIGURATION_RESP": {
                        ReadXMLFileHandler parser = new ReadXMLFileHandler();
                        RcInspectionActivity.this.controllerList = parser.parse((Reader)new StringReader(command.getExtra()));
                        RcInspectionActivity.this.refreshQr();
                        return CallbackResult.HANDLED_CONTINUE;
                    }
                }
            }
            return CallbackResult.NOT_HANDLED;
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.topBar = this.findViewById(R.id.top_bar);
        NetworkConnectionHandler.getInstance().pushReceiveLoopCallback(this.recvLoopCallback);
        NetworkConnectionHandler.getInstance().sendCommand(new Command("CMD_REQUEST_OP_MODE_LIST"));
        NetworkConnectionHandler.getInstance().sendCommand(new Command("CMD_REQUEST_ACTIVE_CONFIG"));
        Intent intent = this.getIntent();
        if (intent != null) {
            if (intent.hasExtra(GAMEPAD_KEY)) {
                this.gamepads = intent.getIntegerArrayListExtra(GAMEPAD_KEY);
            }
            if (intent.hasExtra(ADVANCED_FEATURES_KEY)) {
                this.advancedGamepadFeatures = intent.getBooleanExtra(ADVANCED_FEATURES_KEY, false);
            }
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        NetworkConnectionHandler.getInstance().removeReceiveLoopCallback(this.recvLoopCallback);
    }

    @Override
    protected void refresh() {
        if (this.remoteConfigure) {
            NetworkConnectionHandler.getInstance().sendCommand(new Command("CMD_REQUEST_INSPECTION_REPORT"));
        } else {
            super.refresh();
        }
    }

    @Override
    protected boolean inspectingRobotController() {
        return true;
    }

    @Override
    protected boolean inspectingRemoteDevice() {
        return this.remoteConfigure;
    }

    @Override
    protected int getMenu() {
        return this.remoteConfigure ? R.menu.inspection_menu_rc_remote : R.menu.inspection_menu_rcds_local;
    }

    private void refreshQr() {
        if (this.rcInspectionState == null || this.opModes == null) {
            return;
        }
        final QrData qrData = new QrData();
        qrData.dsInspectionState = new InspectionState();
        qrData.dsInspectionState.initializeLocal();
        qrData.rcInspectionState = this.rcInspectionState;
        for (int i = 0; this.gamepads != null && i < this.gamepads.size(); i += 2) {
            qrData.gamepads.add(new GamepadInspection(this.gamepads.get(i), this.gamepads.get(i + 1)));
        }
        qrData.surveyData = this.getSurveyData();
        qrData.validSurvey = this.controllerList != null && !this.controllerList.isEmpty();
        qrData.rcValidation = this.getValidation(qrData.rcInspectionState, true);
        qrData.dsValidation = this.getValidation(qrData.dsInspectionState, false);
        Bitmap bitmap = null;
        try {
            String data = qrGson.toJson((Object)qrData);
            Deflater compressor = new Deflater();
            compressor.setInput(data.getBytes());
            compressor.finish();
            byte[] buffer = new byte[data.length()];
            int len = compressor.deflate(buffer);
            compressor.finish();
            byte[] trimmed = new byte[len];
            System.arraycopy(buffer, 0, trimmed, 0, len);
            String base45 = Base45.getEncoder().encodeToString(trimmed);
            BarcodeEncoder barcodeEncoder = new BarcodeEncoder();
            bitmap = barcodeEncoder.encodeBitmap(base45, BarcodeFormat.QR_CODE, 512, 512);
        }
        catch (WriterException e) {
            RobotLog.ee((String)"InspectionActivity", (String)e.getMessage());
        }
        final Bitmap finalBitmap = bitmap;
        AppUtil.getInstance().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                RcInspectionActivity.this.refresh(qrData.rcInspectionState);
                RcInspectionActivity.this.autoInspectQr.setImageBitmap(finalBitmap);
                if (!qrData.validSurvey || qrData.gamepads.isEmpty()) {
                    RcInspectionActivity.this.invalidQr.setVisibility(0);
                    RcInspectionActivity.this.invalidQr.setText(qrData.validSurvey ? R.string.qrNoGamepad : R.string.qrInvalid);
                } else {
                    RcInspectionActivity.this.invalidQr.setVisibility(8);
                }
                DisplayMetrics displayMetrics = RcInspectionActivity.this.getResources().getDisplayMetrics();
                Configuration config = RcInspectionActivity.this.getResources().getConfiguration();
                ViewGroup.LayoutParams params = RcInspectionActivity.this.autoInspectQr.getLayoutParams();
                int heightPx = (int)TypedValue.applyDimension((int)1, (float)config.screenHeightDp, (DisplayMetrics)displayMetrics);
                int widthPx = (int)TypedValue.applyDimension((int)1, (float)config.screenWidthDp, (DisplayMetrics)displayMetrics);
                int topBarPx = ((RcInspectionActivity)RcInspectionActivity.this).topBar.getLayoutParams().height;
                params.height = Math.min(heightPx - topBarPx, widthPx) - 10;
                RcInspectionActivity.this.autoInspectQr.setLayoutParams(params);
            }
        });
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.refreshQr();
    }

    private SurveyData getSurveyData() {
        if (this.opModes == null) {
            return null;
        }
        SurveyData surveyData = new SurveyData();
        for (ControllerConfiguration cc : this.controllerList) {
            this.addControllerToSurvey(surveyData, cc);
        }
        for (OpModeMeta opMode : this.opModes) {
            this.addItemToCount(surveyData.getOpModeFlavors(), opMode.flavor);
            this.addItemToCount(surveyData.getOpModeSources(), opMode.source);
        }
        if (this.advancedGamepadFeatures != null) {
            surveyData.setAdvancedGamepadFeatures(this.advancedGamepadFeatures);
        }
        return surveyData;
    }

    private <T> void addItemToCount(Map<T, Integer> map, T k) {
        if (map.containsKey(k)) {
            map.put(k, map.get(k) + 1);
        } else {
            map.put(k, 1);
        }
    }

    private void addDevicesToSurvey(SurveyData surveyData, List<? extends DeviceConfiguration> devices) {
        for (DeviceConfiguration deviceConfiguration : devices) {
            if (!deviceConfiguration.isEnabled()) continue;
            if (deviceConfiguration instanceof ControllerConfiguration) {
                this.addControllerToSurvey(surveyData, (ControllerConfiguration)deviceConfiguration);
                continue;
            }
            this.addItemToCount(surveyData.getHardwareData(), deviceConfiguration.getConfigurationType().getName());
        }
    }

    private void addControllerToSurvey(SurveyData surveyData, ControllerConfiguration<?> controller) {
        if (!controller.isEnabled()) {
            return;
        }
        if (controller instanceof WebcamConfiguration) {
            WebcamConfiguration webcam = (WebcamConfiguration)controller;
            if (webcam.getSerialNumber().isVendorProduct()) {
                VendorProductSerialNumber sn = (VendorProductSerialNumber)webcam.getSerialNumber();
                this.addItemToCount(surveyData.getHardwareData(), "webcam_" + sn.getVendorId() + "_" + sn.getProductId());
            } else {
                this.addItemToCount(surveyData.getHardwareData(), "webcam");
            }
            return;
        }
        this.addItemToCount(surveyData.getHardwareData(), controller.getName());
        this.addDevicesToSurvey(surveyData, controller.getDevices());
        if (controller instanceof LynxModuleConfiguration) {
            LynxModuleConfiguration lynx = (LynxModuleConfiguration)controller;
            this.addDevicesToSurvey(surveyData, lynx.getMotors());
            this.addDevicesToSurvey(surveyData, lynx.getPwmOutputs());
            this.addDevicesToSurvey(surveyData, lynx.getServos());
            this.addDevicesToSurvey(surveyData, lynx.getAnalogInputs());
            this.addDevicesToSurvey(surveyData, lynx.getDigitalDevices());
            this.addDevicesToSurvey(surveyData, lynx.getI2cDevices());
        } else if (controller instanceof ServoHubConfiguration) {
            ServoHubConfiguration servoHub = (ServoHubConfiguration)controller;
            this.addDevicesToSurvey(surveyData, servoHub.getServos());
        }
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        JsonSerializer<Boolean> booleanSerializer = new JsonSerializer<Boolean>(){

            public JsonElement serialize(Boolean b, Type type, JsonSerializationContext jsonSerializationContext) {
                return new JsonPrimitive((Number)(b != null && b != false ? 1 : 0));
            }
        };
        builder.registerTypeAdapter(Boolean.class, (Object)booleanSerializer);
        builder.registerTypeAdapter(Boolean.TYPE, (Object)booleanSerializer);
        builder.addSerializationExclusionStrategy(new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes fieldAttributes) {
                return fieldAttributes.getAnnotation(QrExclude.class) != null;
            }

            public boolean shouldSkipClass(Class<?> aClass) {
                return false;
            }
        });
        JsonSerializer<InspectionProperty> inspectionPropertyJsonSerializer = new JsonSerializer<InspectionProperty>(){

            public JsonElement serialize(InspectionProperty p, Type type, JsonSerializationContext jsonSerializationContext) {
                return new JsonPrimitive((Number)(p != null && p.valid ? 1 : 0));
            }
        };
        builder.registerTypeAdapter(InspectionProperty.class, (Object)inspectionPropertyJsonSerializer);
        qrGson = builder.create();
    }
}

