/*
 * Decompiled with CFR 0.152.
 */
package dk.sgjesse.r8api;

import com.android.tools.r8.ByteDataView;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import dk.sgjesse.r8api.ZipUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class AndroidDexIndexedConsumer
extends DexIndexedConsumer.ForwardingConsumer {
    private final File destination;
    private final SortedMap<String, ByteDataView> dexFiles = new TreeMap<String, ByteDataView>();

    public AndroidDexIndexedConsumer(File destination) {
        super(null);
        this.destination = destination;
    }

    public void finished(DiagnosticsHandler handler) {
        try {
            ZipOutputStream stream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.destination)));
            if (this.dexFiles.isEmpty()) {
                stream.putNextEntry(new ZipEntry("README.txt"));
                stream.write("Created by FTC SDK.".getBytes());
                stream.closeEntry();
            }
            for (Map.Entry<String, ByteDataView> entry : this.dexFiles.entrySet()) {
                ZipUtils.writeToZipStream(stream, entry.getKey(), entry.getValue(), 8);
            }
            stream.close();
        }
        catch (IOException e) {
            handler.error((Diagnostic)new ExceptionDiagnostic((Throwable)e));
        }
    }

    public void accept(int fileIndex, ByteDataView data, Set<String> descriptors, DiagnosticsHandler handler) {
        String name = this.getDefaultDexFileName(fileIndex);
        this.dexFiles.put(name, ByteDataView.of((byte[])data.copyByteData()));
    }

    private String getDefaultDexFileName(int fileIndex) {
        return "classes" + (fileIndex == 0 ? "" : Integer.valueOf(fileIndex + 1)) + ".dex";
    }
}

