/*
 * Decompiled with CFR 0.152.
 */
package dk.sgjesse.r8api;

import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.origin.ArchiveEntryOrigin;
import com.android.tools.r8.origin.Origin;
import dk.sgjesse.r8api.DescriptorUtils;
import dk.sgjesse.r8api.FileOrigin;
import dk.sgjesse.r8api.ZipUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ArchiveClassFileResourceProvider
implements ClassFileResourceProvider,
Closeable {
    private final File archive;
    private final Origin origin;
    private final ZipFile zipFile;
    private final Set<String> descriptors = new HashSet<String>();
    private volatile boolean closed;

    public ArchiveClassFileResourceProvider(File archive) throws IOException {
        this.archive = archive;
        this.origin = new FileOrigin(archive);
        this.zipFile = new ZipFile(archive);
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!ZipUtils.isClassFile(entryName)) continue;
            this.descriptors.add(DescriptorUtils.guessTypeDescriptor(entryName));
        }
    }

    public Set<String> getClassDescriptors() {
        return Collections.unmodifiableSet(this.descriptors);
    }

    public ProgramResource getProgramResource(String descriptor) {
        ProgramResource programResource;
        block9: {
            if (!this.descriptors.contains(descriptor)) {
                return null;
            }
            ZipEntry entry = this.zipFile.getEntry(DescriptorUtils.getPathFromDescriptor(descriptor));
            String name = entry.getName();
            ArchiveEntryOrigin entryOrigin = new ArchiveEntryOrigin(name, this.origin);
            InputStream stream = this.zipFile.getInputStream(entry);
            try {
                programResource = ProgramResource.fromBytes((Origin)entryOrigin, (ProgramResource.Kind)ProgramResource.Kind.CF, (byte[])ZipUtils.toByteArray(stream), Collections.singleton(descriptor));
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read '" + descriptor + " from " + this.archive.getAbsolutePath(), e);
                }
            }
            stream.close();
        }
        return programResource;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.descriptors.clear();
            this.zipFile.close();
        }
    }
}

