/*
 * Decompiled with CFR 0.152.
 */
package dk.sgjesse.r8api;

import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ProgramResourceProvider;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.origin.ArchiveEntryOrigin;
import com.android.tools.r8.origin.Origin;
import dk.sgjesse.r8api.DescriptorUtils;
import dk.sgjesse.r8api.FileOrigin;
import dk.sgjesse.r8api.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ArchiveProgramResourceProvider
implements ProgramResourceProvider {
    private final File archive;
    private final Origin origin;

    public ArchiveProgramResourceProvider(File archive) {
        this.archive = archive;
        this.origin = new FileOrigin(archive);
    }

    public Collection<ProgramResource> getProgramResources() throws ResourceException {
        ArrayList<ProgramResource> programResources = new ArrayList<ProgramResource>();
        try (ZipFile zipFile = new ZipFile(this.archive);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!ZipUtils.isClassFile(name)) continue;
                ArchiveEntryOrigin entryOrigin = new ArchiveEntryOrigin(name, this.origin);
                InputStream stream = zipFile.getInputStream(entry);
                try {
                    String descriptor = DescriptorUtils.guessTypeDescriptor(name);
                    programResources.add(ProgramResource.fromBytes((Origin)entryOrigin, (ProgramResource.Kind)ProgramResource.Kind.CF, (byte[])ZipUtils.toByteArray(stream), Collections.singleton(descriptor)));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            throw new ResourceException(this.origin, (Throwable)e);
        }
        return programResources;
    }
}

