/*
 * Decompiled with CFR 0.152.
 */
package dk.sgjesse.r8api;

import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.ProgramResource;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OrderedClassFileResourceProvider
implements ClassFileResourceProvider,
Closeable {
    private final List<ClassFileResourceProvider> providers = new ArrayList<ClassFileResourceProvider>();
    private final Set<String> descriptors = new HashSet<String>();
    private boolean empty = true;
    private volatile boolean closed;

    public void addClassFileResourceProvider(ClassFileResourceProvider provider) {
        this.providers.add(provider);
        this.descriptors.addAll(provider.getClassDescriptors());
        this.empty = false;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public Set<String> getClassDescriptors() {
        return this.descriptors;
    }

    public ProgramResource getProgramResource(String descriptor) {
        for (ClassFileResourceProvider provider : this.providers) {
            if (!provider.getClassDescriptors().contains(descriptor)) continue;
            return provider.getProgramResource(descriptor);
        }
        return null;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            for (ClassFileResourceProvider provider : this.providers) {
                if (!(provider instanceof Closeable)) continue;
                ((Closeable)provider).close();
            }
            this.providers.clear();
            this.descriptors.clear();
        }
    }
}

