/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.onbotjava;

import androidx.annotation.NonNull;
import com.qualcomm.robotcore.util.ReadWriteFile;
import com.qualcomm.robotcore.util.RobotLog;
import fi.iki.elonen.NanoHTTPD;
import java.io.File;
import java.io.FileNotFoundException;
import org.firstinspires.ftc.onbotjava.OnBotJavaBroadcastManager;
import org.firstinspires.ftc.onbotjava.OnBotJavaFileSystemUtils;
import org.firstinspires.ftc.onbotjava.OnBotJavaManager;
import org.firstinspires.ftc.onbotjava.StandardResponses;
import org.firstinspires.ftc.robotcore.internal.files.FileModifyObserver;

public class BuildMonitor {
    private final Object buildCompletionNotifier = new Object();
    private final Object buildInformationUpdateLock = new Object();
    private static final File buildStartedFile = OnBotJavaManager.buildStartedFile;
    private static final File buildCompleteFile = OnBotJavaManager.buildCompleteFile;
    private final FileModifyObserver runningObserver;
    private final FileModifyObserver completedObserver;
    private final OnBotJavaBroadcastManager webSocketBroadcastManager;
    private CurrentBuildStatus buildStatus = CurrentBuildStatus.NOT_STARTED;
    private boolean closed = false;
    private long lastStartedBuild = -1L;
    private String TAG = "ONBOTJAVA_BUILD_MONITOR";

    BuildMonitor(OnBotJavaBroadcastManager broadcastManager) {
        this.webSocketBroadcastManager = broadcastManager;
        File statusDir = OnBotJavaManager.statusDir;
        if (!statusDir.isDirectory()) {
            statusDir.mkdirs();
        }
        this.runningObserver = new FileModifyObserver(buildStartedFile, new FileModifyObserver.Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFileChanged(int event, File file) {
                Object object = BuildMonitor.this.buildInformationUpdateLock;
                synchronized (object) {
                    if (BuildMonitor.this.buildStatus == CurrentBuildStatus.RUNNING) {
                        return;
                    }
                    BuildMonitor.this.buildStatus = CurrentBuildStatus.RUNNING;
                }
                BuildMonitor.this.broadcastUpdateToWebsocket();
                RobotLog.ii((String)BuildMonitor.this.TAG, (String)("Build " + BuildMonitor.this.lastStartedBuild + " has successfully started"));
            }
        });
        this.completedObserver = new FileModifyObserver(buildCompleteFile, new FileModifyObserver.Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFileChanged(int event, File file) {
                OnBotJavaManager.BuildStatus newBuildStatus = OnBotJavaManager.getBuildStatus();
                Object object = BuildMonitor.this.buildInformationUpdateLock;
                synchronized (object) {
                    if (BuildMonitor.this.buildStatus == CurrentBuildStatus.SUCCESSFUL || BuildMonitor.this.buildStatus == CurrentBuildStatus.FAILED) {
                        return;
                    }
                    BuildMonitor.this.buildStatus = newBuildStatus == OnBotJavaManager.BuildStatus.SUCCESSFUL ? CurrentBuildStatus.SUCCESSFUL : CurrentBuildStatus.FAILED;
                }
                object = BuildMonitor.this.buildCompletionNotifier;
                synchronized (object) {
                    BuildMonitor.this.buildCompletionNotifier.notifyAll();
                }
                BuildMonitor.this.broadcastUpdateToWebsocket();
                RobotLog.ii((String)BuildMonitor.this.TAG, (String)("Build " + BuildMonitor.this.lastStartedBuild + " completed with status " + (Object)((Object)newBuildStatus)));
            }
        });
    }

    private void broadcastUpdateToWebsocket() {
        this.webSocketBroadcastManager.broadcast("build:status", new BuildStatusReportWebsocket(this.buildStatus, this.lastStartedBuild));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildStatusReport currentBuildStatus() {
        if (this.closed) {
            throw new IllegalStateException("BuildMonitor has been closed!");
        }
        Object object = this.buildInformationUpdateLock;
        synchronized (object) {
            return new BuildStatusReport(this.lastStartedBuild, this.buildStatus.isCurrentlyRunning(), this.buildStatus == CurrentBuildStatus.SUCCESSFUL);
        }
    }

    @NonNull
    public NanoHTTPD.Response currentBuildLog() {
        try {
            return OnBotJavaFileSystemUtils.serveFile(OnBotJavaManager.buildLogFile.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            return StandardResponses.serverError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForRunningBuildCompletion() {
        try {
            boolean isBuildCurrentlyRunning;
            Object object = this.buildInformationUpdateLock;
            synchronized (object) {
                isBuildCurrentlyRunning = this.buildStatus.isCurrentlyRunning();
                if (!isBuildCurrentlyRunning) {
                    return false;
                }
            }
            do {
                object = this.buildCompletionNotifier;
                synchronized (object) {
                    this.buildCompletionNotifier.wait();
                }
                object = this.buildInformationUpdateLock;
                synchronized (object) {
                    isBuildCurrentlyRunning = this.buildStatus.isCurrentlyRunning();
                }
            } while (isBuildCurrentlyRunning);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return true;
        }
        return false;
    }

    public void close() {
        this.closed = true;
        this.runningObserver.close();
        this.completedObserver.close();
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.closed) {
            return;
        }
        RobotLog.ww((String)"FetchBuildStatus", (String)"Did not call close(), running finalizer");
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long launchBuild() {
        File buildStartFile = OnBotJavaManager.buildRequestFile;
        long startTime = System.currentTimeMillis();
        Object object = this.buildInformationUpdateLock;
        synchronized (object) {
            if (this.buildStatus.isCurrentlyRunning()) {
                RobotLog.vv((String)this.TAG, (String)"Refusing to launch build...another build is already running");
                return this.lastStartedBuild;
            }
            this.buildStatus = CurrentBuildStatus.PENDING;
            this.lastStartedBuild = startTime;
        }
        this.broadcastUpdateToWebsocket();
        ReadWriteFile.writeFile((File)buildStartFile, (String)(startTime + " - begin build"));
        RobotLog.ii((String)this.TAG, (String)("Build " + this.lastStartedBuild + " is pending"));
        return startTime;
    }

    public static class BuildStatusReportWebsocket {
        public static final transient String TAG = "build:status";
        final CurrentBuildStatus status;
        final long startTimestamp;

        public BuildStatusReportWebsocket(CurrentBuildStatus status, long startTimestamp) {
            this.status = status;
            this.startTimestamp = startTimestamp;
        }
    }

    public static class BuildStatusReport {
        final boolean completed;
        final boolean running;
        final boolean successful;
        final long timestamp;
        final long startTimestamp;

        private BuildStatusReport(long startTimestamp, boolean running, boolean successful) {
            this.completed = !running;
            this.running = running;
            this.successful = successful;
            this.startTimestamp = startTimestamp;
            this.timestamp = System.nanoTime();
        }
    }

    private static enum CurrentBuildStatus {
        NOT_STARTED,
        PENDING,
        RUNNING,
        FAILED,
        SUCCESSFUL;


        boolean isCurrentlyRunning() {
            return this == PENDING || this == RUNNING;
        }
    }
}

