/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.onbotjava;

import android.content.SharedPreferences;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.qualcomm.robotcore.util.RobotLog;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.firstinspires.ftc.onbotjava.OnBotJavaWebInterfaceManager;
import org.firstinspires.ftc.robotcore.internal.collections.SimpleGson;

public class EditorSettings {
    public final Setting<Boolean> autocompleteEnabledSetting = new Setting("autocompleteEnabled", Boolean.class, true);
    public final Setting<Boolean> autocompleteForceEnabledSetting = new Setting("autocompleteForceEnabled", Boolean.class, false);
    public final Setting<List> autocompletePackagesSetting = new Setting("autocompletePackages", List.class, OnBotJavaWebInterfaceManager.packagesToAutocomplete());
    public final Setting<Boolean> autoImportEnabledSetting = new Setting("autoImportEnabled", Boolean.class, true);
    public final Setting<String> defaultPackageSetting = new Setting("defaultPackage", String.class, "org.firstinspires.ftc.teamcode");
    public final Setting<String> fontSetting = new Setting("font", String.class, "Source Code Pro");
    public final Setting<Integer> fontSizeSetting = new Setting("fontSize", Integer.class, 16);
    public final Setting<String> keybindingSetting = new Setting("keybinding", String.class, "OnBotJava");
    public final Setting<Boolean> showInvisibleCharsSetting = new Setting("invisibleChars", Boolean.class, false);
    public final Setting<Boolean> showPrintMarginSetting = new Setting("printMargin", Boolean.class, true);
    public final Setting<Boolean> softWrapSetting = new Setting("softWrap", Boolean.class, false);
    public final Setting<Integer> spacesToTabSetting = new Setting("spacesToTab", Integer.class, 4);
    public final Setting<String> themeSetting = new Setting("theme", String.class, "chrome");
    public final Setting<Boolean> useNewOnBotJavaWorker = new Setting("useNewOnBotJavaWorker", Boolean.class, true);
    public final Setting<String> whitespaceSetting = new Setting("whitespace", String.class, "space");
    public final Setting<Integer> settingEpoch = new Setting("settingEpoch", Integer.class, 0);
    private final Map<String, Setting<?>> settings;
    private static final Gson settingsSerializer = new GsonBuilder().registerTypeAdapter(Setting.class, (Object)new SettingTypeAdapter()).create();

    private EditorSettings() {
        HashMap<String, Setting<Object>> settings = new HashMap<String, Setting<Object>>();
        settings.put(this.autocompleteEnabledSetting.name, this.autocompleteEnabledSetting);
        settings.put(this.autocompleteForceEnabledSetting.name, this.autocompleteForceEnabledSetting);
        settings.put(this.autocompletePackagesSetting.name, this.autocompletePackagesSetting);
        settings.put(this.autoImportEnabledSetting.name, this.autoImportEnabledSetting);
        settings.put(this.defaultPackageSetting.name, this.defaultPackageSetting);
        settings.put(this.fontSetting.name, this.fontSetting);
        settings.put(this.fontSizeSetting.name, this.fontSizeSetting);
        settings.put(this.keybindingSetting.name, this.keybindingSetting);
        settings.put(this.showInvisibleCharsSetting.name, this.showInvisibleCharsSetting);
        settings.put(this.showPrintMarginSetting.name, this.showPrintMarginSetting);
        settings.put(this.softWrapSetting.name, this.softWrapSetting);
        settings.put(this.spacesToTabSetting.name, this.spacesToTabSetting);
        settings.put(this.themeSetting.name, this.themeSetting);
        settings.put(this.useNewOnBotJavaWorker.name, this.useNewOnBotJavaWorker);
        settings.put(this.whitespaceSetting.name, this.whitespaceSetting);
        settings.put(this.settingEpoch.name, this.settingEpoch);
        this.settings = Collections.unmodifiableMap(settings);
    }

    private EditorSettings(Map<String, Object> settingValuesMap) {
        this();
        for (Map.Entry<String, Object> settingValueEntry : settingValuesMap.entrySet()) {
            Setting<?> setting = this.settings.get(settingValueEntry.getKey());
            setting.setWithUnknownType(settingValueEntry.getValue());
        }
        this.autocompletePackagesSetting.set(OnBotJavaWebInterfaceManager.packagesToAutocomplete());
        this.upgradeOnBotJavaSettings(null);
    }

    private void upgradeOnBotJavaSettings(SharedPreferences.Editor editor) {
        if ((Integer)((Setting)this.settingEpoch).value == 0) {
            this.useNewOnBotJavaWorker.set(true);
            this.settingEpoch.set(1);
            if (editor != null) {
                this.persistValue(editor, this.useNewOnBotJavaWorker.name);
                this.persistValue(editor, this.settingEpoch.name);
            }
        }
    }

    EditorSettings(SharedPreferences preferences) {
        this();
        SharedPreferences.Editor edit = preferences.edit();
        Map prefMap = preferences.getAll();
        for (String key : this.settings.keySet()) {
            if (prefMap.containsKey(key)) {
                Setting<?> setting = this.settings.get(key);
                setting.setWithUnknownType(prefMap.get(key));
                continue;
            }
            this.persistValue(edit, key);
        }
        this.autocompletePackagesSetting.set(OnBotJavaWebInterfaceManager.packagesToAutocomplete());
        this.upgradeOnBotJavaSettings(edit);
        edit.apply();
    }

    private static EditorSettings fromJson(String json) {
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        return new EditorSettings((Map)OnBotJavaWebInterfaceManager.instance().gson().fromJson(json, type));
    }

    private void persistValue(SharedPreferences.Editor edit, String key) {
        Object obj = this.settings.get(key).get();
        if (obj instanceof Integer) {
            edit.putInt(key, ((Integer)obj).intValue());
        } else if (obj instanceof String) {
            edit.putString(key, (String)obj);
        } else if (obj instanceof Boolean) {
            edit.putBoolean(key, ((Boolean)obj).booleanValue());
        } else if (obj instanceof Float) {
            edit.putFloat(key, ((Float)obj).floatValue());
        } else if (obj instanceof Double) {
            edit.putFloat(key, ((Double)obj).floatValue());
        } else {
            edit.putString(key, SimpleGson.getInstance().toJson(obj));
        }
    }

    public void updateFromJson(String json) {
        EditorSettings newEditorSettings = EditorSettings.fromJson(json);
        this.update(newEditorSettings, OnBotJavaWebInterfaceManager.instance().sharedPrefs());
    }

    private void update(EditorSettings newSettings, SharedPreferences preferences) {
        SharedPreferences.Editor editor = preferences.edit();
        for (Map.Entry<String, Setting<?>> newEntry : newSettings.settings.entrySet()) {
            String key = newEntry.getKey();
            Object newValue = newEntry.getValue().get();
            Setting<?> existingSetting = this.settings.get(key);
            existingSetting.set(newValue);
            this.persistValue(editor, key);
        }
        editor.apply();
    }

    private void trim(SharedPreferences preferences) {
        Map prefMap = preferences.getAll();
        SharedPreferences.Editor edit = preferences.edit();
        for (String key : prefMap.keySet()) {
            if (this.settings.containsKey(key)) continue;
            edit.remove(key);
        }
        edit.apply();
    }

    public void resetToDefaults() {
        SharedPreferences preferences = OnBotJavaWebInterfaceManager.instance().sharedPrefs();
        this.update(new EditorSettings(), preferences);
        this.trim(preferences);
    }

    public String toJSON() {
        return settingsSerializer.toJson(this.settings);
    }

    private static class SettingTypeAdapter
    extends TypeAdapter<Setting> {
        private SettingTypeAdapter() {
        }

        public void write(JsonWriter jsonWriter, Setting setting) throws IOException {
            if (setting == null) {
                jsonWriter.nullValue();
                return;
            }
            this.handleSetting(setting, jsonWriter);
        }

        private <T> void handleSetting(Setting<T> setting, JsonWriter jsonWriter) throws IOException {
            T value = setting.get();
            TypeAdapter valueTypeAdapter = settingsSerializer.getAdapter(setting.type);
            valueTypeAdapter.write(jsonWriter, value);
        }

        public Setting read(JsonReader jsonReader) throws IOException {
            throw new IllegalStateException("The settingsSerializer only supports serializing a Settings instance, not deserializing one.");
        }
    }

    public static final class Setting<T> {
        final String name;
        final Class<T> type;
        private T value;

        private Setting(String name, Class<T> type, T defaultValue) {
            this.name = name;
            this.type = type;
            this.value = defaultValue;
        }

        public T get() {
            return this.value;
        }

        public final void set(T value) {
            this.setWithUnknownType(value);
        }

        public void setWithUnknownType(Object value) {
            try {
                this.value = Setting.safelyConvertFromObject(value, this.type);
            }
            catch (RuntimeException e) {
                RobotLog.ee((String)EditorSettings.class.getName(), (Throwable)e, (String)"Setting %s not updated.", (Object[])new Object[]{this.name});
            }
        }

        private static <T> T safelyConvertFromObject(Object value, Class<T> type) {
            if (type.isInstance(value)) {
                return (T)value;
            }
            JsonSyntaxException gsonException = null;
            if (value instanceof String) {
                boolean convertingToInt;
                Class<Object> gsonTargetType = type;
                boolean bl = convertingToInt = type == Integer.class;
                if (convertingToInt) {
                    gsonTargetType = Double.class;
                }
                try {
                    Object gsonResult = SimpleGson.getInstance().fromJson((String)value, gsonTargetType);
                    if (!convertingToInt) {
                        return (T)gsonResult;
                    }
                    value = gsonResult;
                }
                catch (JsonSyntaxException e) {
                    gsonException = e;
                }
            }
            if (type == Integer.class && value instanceof Double) {
                int intValue = ((Double)value).intValue();
                return (T)Integer.valueOf(intValue);
            }
            if (type == Integer.class && value instanceof Float) {
                int intValue = ((Float)value).intValue();
                return (T)Integer.valueOf(((Float)value).intValue());
            }
            if (type == Double.class && value instanceof Float) {
                double doubleValue = ((Float)value).doubleValue();
                return (T)Double.valueOf(doubleValue);
            }
            if (type == Float.class && value instanceof Double) {
                float floatValue = ((Double)value).floatValue();
                return (T)Float.valueOf(floatValue);
            }
            throw new IllegalArgumentException(String.format("Unable to convert %s to %s.", value.getClass().getSimpleName(), type.getSimpleName()), gsonException);
        }
    }
}

