/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.onbotjava;

import android.os.Process;
import androidx.annotation.Nullable;
import com.qualcomm.robotcore.util.RobotLog;
import fi.iki.elonen.NanoHTTPD;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.firstinspires.ftc.onbotjava.ExternalLibrariesClassLoader;
import org.firstinspires.ftc.onbotjava.ExternalLibrary;
import org.firstinspires.ftc.onbotjava.OnBotJavaManager;
import org.firstinspires.ftc.robotcore.external.Predicate;
import org.firstinspires.ftc.robotcore.internal.opmode.ClassManager;
import org.firstinspires.ftc.robotcore.internal.opmode.RegisteredOpModes;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;

public class ExternalLibraries {
    private static final String TAG = "ExternalLibraries";
    private static final Comparator<File> compareByLastModifiedTime = new Comparator<File>(){

        @Override
        public int compare(File a, File b) {
            return Long.compare(a.lastModified(), b.lastModified());
        }
    };
    private static String jniSubdirPrefix;
    private final Map<File, ExternalLibrary> map = new TreeMap<File, ExternalLibrary>(compareByLastModifiedTime);
    @Nullable
    private ClassLoader classLoader;

    public static ExternalLibraries getInstance() {
        return InstanceHolder.theInstance;
    }

    public void onCreate() {
        jniSubdirPrefix = ExternalLibraries.getJniSubdirPrefix();
        List uploadedFiles = AppUtil.getInstance().filesIn(OnBotJavaManager.extLibDir, (Predicate)new Predicate<File>(){

            public boolean test(File file) {
                return file.isFile() && ExternalLibraries.this.isExternalLibrariesFile(file.getName());
            }
        });
        Collections.sort(uploadedFiles, compareByLastModifiedTime);
        ArrayList<File> dexFiles = new ArrayList<File>();
        ArrayList<File> soFiles = new ArrayList<File>();
        for (File uploadedFile : uploadedFiles) {
            ExternalLibrary externalLibrary = new ExternalLibrary(uploadedFile);
            String errorMessage = externalLibrary.onCreate();
            if (errorMessage != null) continue;
            this.map.put(uploadedFile, externalLibrary);
            dexFiles.addAll(externalLibrary.getDexFiles());
            soFiles.addAll(externalLibrary.getSoFiles());
        }
        this.classLoader = ExternalLibraries.createClassLoader(null, dexFiles, soFiles, true);
    }

    private static ClassLoader createClassLoader(ClassLoader parentClassLoader, Collection<File> dexFiles, Collection<File> soFiles, boolean deleteOrphanedSoFiles) {
        AppUtil appUtil = AppUtil.getInstance();
        ArrayList<File> librarySearchPathFiles = new ArrayList<File>();
        ArrayList<File> librarySearchPathDirs = new ArrayList<File>();
        for (File soFile : soFiles) {
            try {
                File srcParentDir = soFile.getParentFile();
                if (!srcParentDir.getName().startsWith(jniSubdirPrefix)) continue;
                String relativePath = appUtil.getRelativePath(AppUtil.FIRST_FOLDER, soFile).getPath();
                File destFile = new File(AppUtil.getDefContext().getFilesDir(), relativePath);
                if (destFile.isDirectory()) {
                    appUtil.delete(destFile);
                }
                if (!destFile.exists() || !AppUtil.computeMd5((File)soFile).equals(AppUtil.computeMd5((File)destFile))) {
                    destFile.getParentFile().mkdirs();
                    appUtil.copyFile(soFile, destFile);
                }
                librarySearchPathFiles.add(destFile);
                librarySearchPathDirs.add(destFile.getParentFile());
            }
            catch (Exception e) {
                RobotLog.ee((String)TAG, (Throwable)e, (String)("Could not use " + soFile.getAbsolutePath()));
            }
        }
        if (deleteOrphanedSoFiles) {
            for (File soFile : appUtil.filesUnder(AppUtil.getDefContext().getFilesDir(), ".so")) {
                if (librarySearchPathFiles.contains(soFile)) continue;
                appUtil.delete(soFile);
            }
        }
        if (!dexFiles.isEmpty() || !librarySearchPathDirs.isEmpty()) {
            StringBuilder dexPath = new StringBuilder();
            String delimiter = "";
            for (File dotDexFile : dexFiles) {
                dexPath.append(delimiter).append(dotDexFile.getAbsolutePath());
                delimiter = File.pathSeparator;
            }
            StringBuilder librarySearchPath = new StringBuilder();
            delimiter = "";
            for (File dir : librarySearchPathDirs) {
                librarySearchPath.append(delimiter).append(dir.getAbsolutePath());
                delimiter = File.pathSeparator;
            }
            if (parentClassLoader == null) {
                parentClassLoader = ExternalLibraries.class.getClassLoader();
            }
            return new ExternalLibrariesClassLoader(dexPath.toString(), librarySearchPath.toString(), parentClassLoader);
        }
        return null;
    }

    private static String getJniSubdirPrefix() {
        String jniSubdirPrefix = "armeabi";
        try {
            String mapsFile = "/proc/" + Process.myPid() + "/maps";
            try (BufferedReader reader = new BufferedReader(new FileReader(mapsFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    int n;
                    String lib;
                    if (!line.endsWith(".so") || !(lib = line.substring((n = line.lastIndexOf(" ")) + 1)).endsWith("libRobotCore.so")) continue;
                    if (lib.contains("64")) {
                        jniSubdirPrefix = "arm64";
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            RobotLog.ee((String)TAG, (Throwable)e, (String)"Unable to determine whether we are running in 64-bit mode.");
        }
        return jniSubdirPrefix;
    }

    Collection<String> getClassNames() {
        TreeSet<String> classNames = new TreeSet<String>();
        for (ExternalLibrary externalLibrary : this.map.values()) {
            classNames.addAll(externalLibrary.getClassNames());
        }
        return Collections.unmodifiableCollection(classNames);
    }

    ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public NanoHTTPD.Response onUpload(File uploadedFile) {
        ExternalLibrary externalLibrary = new ExternalLibrary(uploadedFile);
        NanoHTTPD.Response response = externalLibrary.onUpload();
        if (response.getStatus() == NanoHTTPD.Response.Status.OK) {
            this.map.put(uploadedFile, externalLibrary);
            Collection<File> dexFiles = externalLibrary.getDexFiles();
            Collection<File> soFiles = externalLibrary.getSoFiles();
            ClassLoader newClassLoader = ExternalLibraries.createClassLoader(this.classLoader, dexFiles, soFiles, false);
            if (newClassLoader != null) {
                this.classLoader = newClassLoader;
            }
            ClassManager.getInstance().processExternalLibrariesClasses();
            RegisteredOpModes.getInstance().setExternalLibrariesChanged();
        } else {
            uploadedFile.delete();
        }
        return response;
    }

    Collection<File> getClasspathFiles() {
        ArrayList<File> classpathFiles = new ArrayList<File>();
        for (ExternalLibrary externalLibrary : this.map.values()) {
            classpathFiles.addAll(externalLibrary.getJarFiles());
        }
        return Collections.unmodifiableCollection(classpathFiles);
    }

    public void deleteExternalLibrary(File uploadedFile) {
        ExternalLibrary externalLibrary = this.map.remove(uploadedFile);
        if (externalLibrary != null) {
            externalLibrary.delete();
        }
        ArrayList<File> dexFiles = new ArrayList<File>();
        ArrayList<File> soFiles = new ArrayList<File>();
        for (ExternalLibrary otherExternalLibrary : this.map.values()) {
            dexFiles.addAll(otherExternalLibrary.getDexFiles());
            soFiles.addAll(otherExternalLibrary.getSoFiles());
        }
        if (soFiles.isEmpty()) {
            this.classLoader = ExternalLibraries.createClassLoader(null, dexFiles, soFiles, false);
        }
        ClassManager.getInstance().processExternalLibrariesClasses();
        RegisteredOpModes.getInstance().setExternalLibrariesChanged();
    }

    boolean isClassIncludedInAnotherExternalLibrary(@Nullable ExternalLibrary extLib, String className) {
        for (ExternalLibrary externalLibrary : this.map.values()) {
            if (externalLibrary.equals(extLib) || !externalLibrary.containsClassName(className)) continue;
            return true;
        }
        return false;
    }

    public List<String> getExternalLibrariesNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (File f : AppUtil.getInstance().filesIn(OnBotJavaManager.extLibDir)) {
            if (!f.isFile()) continue;
            list.add(f.getName());
        }
        return list;
    }

    public boolean isExternalLibrariesFile(String filename) {
        return filename.endsWith(".jar") || filename.endsWith(".aar");
    }

    boolean isExternalLibrariesError(NoClassDefFoundError noClassDefFoundError) {
        for (Throwable t = noClassDefFoundError; t != null; t = t.getCause()) {
            String className;
            if (!(t instanceof ClassNotFoundException) || !this.isClassIncludedInAnotherExternalLibrary(null, className = t.getMessage())) continue;
            return true;
        }
        return false;
    }

    private static class InstanceHolder {
        private static ExternalLibraries theInstance = new ExternalLibraries();

        private InstanceHolder() {
        }
    }
}

