/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.onbotjava;

import com.qualcomm.robotcore.util.RobotLog;
import fi.iki.elonen.NanoHTTPD;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.firstinspires.ftc.onbotjava.ExternalLibraries;
import org.firstinspires.ftc.onbotjava.OnBotJavaDiagnosticsListener;
import org.firstinspires.ftc.onbotjava.OnBotJavaManager;
import org.firstinspires.ftc.onbotjava.StandardResponses;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotserver.internal.webserver.RobotWebHandlerManager;

class ExternalLibrary {
    private static final String TAG = "ExternalLibrary";
    final File uploadedFile;
    final String name;
    private final File subdirectory;
    private final File dexFileParent;
    private final Set<File> jarFiles = new HashSet<File>();
    private final Set<File> soFiles = new HashSet<File>();
    private final Set<File> dexFiles = new HashSet<File>();
    private final Set<String> classNames = new HashSet<String>();

    ExternalLibrary(File uploadedFile) {
        this.uploadedFile = uploadedFile;
        this.name = uploadedFile.getName();
        File subdirectory = null;
        if (this.name.endsWith(".jar")) {
            subdirectory = new File(OnBotJavaManager.extLibDir, ExternalLibrary.replaceSuffix(this.name, ".jar", "_jar"));
        } else if (this.name.endsWith(".aar")) {
            subdirectory = new File(OnBotJavaManager.extLibDir, ExternalLibrary.replaceSuffix(this.name, ".aar", "_aar"));
        }
        this.subdirectory = subdirectory;
        this.dexFileParent = new File(subdirectory, "dex");
    }

    NanoHTTPD.Response onUpload() {
        NanoHTTPD.Response response;
        if (this.subdirectory != null) {
            this.subdirectory.mkdirs();
        }
        if (this.dexFileParent != null) {
            this.dexFileParent.mkdirs();
        }
        if (this.name.endsWith(".jar")) {
            response = this.onUploadJarFile();
        } else if (this.name.endsWith(".aar")) {
            response = this.onUploadAarFile();
        } else {
            RobotLog.ee((String)TAG, (String)("onUpload: unexpected file " + this.name));
            return null;
        }
        if (response.getStatus() != NanoHTTPD.Response.Status.OK) {
            AppUtil.getInstance().delete(this.subdirectory);
        }
        return response;
    }

    private NanoHTTPD.Response onUploadJarFile() {
        this.jarFiles.add(this.uploadedFile);
        String errorMessage = this.collectClassNames();
        if (errorMessage != null) {
            return RobotWebHandlerManager.clientBadRequestError((String)TAG, (String)errorMessage);
        }
        boolean dexifySuccess = this.dexify();
        if (!dexifySuccess) {
            return RobotWebHandlerManager.clientBadRequestError((String)TAG, (String)("Error: The file " + this.name + " can not be used because it could not be dexified."));
        }
        this.dexFiles.addAll(AppUtil.getInstance().filesUnder(this.dexFileParent, ".dex"));
        return StandardResponses.successfulRequest("");
    }

    private NanoHTTPD.Response onUploadAarFile() {
        try {
            OnBotJavaManager.unpackZipFile(this.uploadedFile, this.subdirectory);
        }
        catch (IOException e) {
            String errorMessage = "Error: The file " + this.name + " could not be processed for FTC.";
            return RobotWebHandlerManager.clientBadRequestError((String)TAG, (String)errorMessage);
        }
        this.jarFiles.addAll(AppUtil.getInstance().filesUnder(this.subdirectory, ".jar"));
        this.soFiles.addAll(AppUtil.getInstance().filesUnder(this.subdirectory, ".so"));
        String errorMessage = this.collectClassNames();
        if (errorMessage != null) {
            return RobotWebHandlerManager.clientBadRequestError((String)TAG, (String)errorMessage);
        }
        boolean dexifySuccess = this.dexify();
        if (!dexifySuccess) {
            return RobotWebHandlerManager.clientBadRequestError((String)TAG, (String)("Error: The file " + this.name + " can not be used because it contains .jar file(s) that could not be dexified."));
        }
        this.dexFiles.addAll(AppUtil.getInstance().filesUnder(this.dexFileParent, ".dex"));
        return StandardResponses.successfulRequest("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dexify() {
        OnBotJavaDiagnosticsListener diagnosticListener = new OnBotJavaDiagnosticsListener(null);
        try {
            OnBotJavaManager.dexifyFiles(this.getJarFiles(), this.dexFileParent, diagnosticListener);
        }
        catch (Exception e) {
            boolean bl;
            try {
                RobotLog.ee((String)TAG, (Throwable)e, (String)"dexify failed");
                bl = false;
            }
            catch (Throwable throwable) {
                try {
                    diagnosticListener.flush();
                    diagnosticListener.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    RobotLog.ee((String)TAG, (Throwable)e2, (String)"Could not flush/close the diagnosticListener");
                }
            }
            diagnosticListener.flush();
            diagnosticListener.close();
            return bl;
        }
        diagnosticListener.flush();
        diagnosticListener.close();
        return true;
    }

    String onCreate() {
        String errorMessage = null;
        if (this.name.endsWith(".jar")) {
            errorMessage = this.onCreateJarFile();
        } else if (this.name.endsWith(".aar")) {
            errorMessage = this.onCreateAarFile();
        }
        return errorMessage;
    }

    private String onCreateJarFile() {
        this.jarFiles.add(this.uploadedFile);
        this.dexFiles.addAll(AppUtil.getInstance().filesUnder(this.subdirectory, ".dex"));
        return this.collectClassNames();
    }

    private String onCreateAarFile() {
        this.jarFiles.addAll(AppUtil.getInstance().filesUnder(this.subdirectory, ".jar"));
        this.soFiles.addAll(AppUtil.getInstance().filesUnder(this.subdirectory, ".so"));
        this.dexFiles.addAll(AppUtil.getInstance().filesUnder(this.subdirectory, ".dex"));
        return this.collectClassNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String collectClassNames() {
        Iterator<File> iterator = this.jarFiles.iterator();
        block7: while (iterator.hasNext()) {
            File dotJarFile = iterator.next();
            try (JarFile jarFile = new JarFile(dotJarFile);){
                Enumeration<JarEntry> entries = jarFile.entries();
                while (true) {
                    String entryName;
                    if (!entries.hasMoreElements()) continue block7;
                    JarEntry entry = entries.nextElement();
                    if (entry.isDirectory() || !(entryName = entry.getName()).endsWith(".class")) continue;
                    String className = entryName.substring(0, entryName.lastIndexOf(46)).replace('/', '.');
                    if (ExternalLibraries.getInstance().isClassIncludedInAnotherExternalLibrary(this, className)) {
                        String string = "Error: The file " + this.name + " can not be used because it contains classes that already exist in another external library.";
                        return string;
                    }
                    if (ExternalLibrary.isClassIncludedInRobotControllerApp(className)) {
                        String string = "Error: The file " + this.name + " can not be used because it contains classes that already exist in the FtcRobotController app.";
                        return string;
                    }
                    this.classNames.add(className);
                }
            }
            catch (IOException e) {
                RobotLog.ee((String)TAG, (Throwable)e, (String)"collectClassNames");
                return "Error: The file " + this.name + " could not be processed for FTC.";
            }
        }
        return null;
    }

    boolean containsClassName(String className) {
        return this.classNames.contains(className);
    }

    long getLastModified() {
        return this.uploadedFile.lastModified();
    }

    Collection<File> getJarFiles() {
        return Collections.unmodifiableCollection(this.jarFiles);
    }

    Collection<File> getSoFiles() {
        return Collections.unmodifiableCollection(this.soFiles);
    }

    Collection<File> getDexFiles() {
        return Collections.unmodifiableCollection(this.dexFiles);
    }

    Collection<String> getClassNames() {
        return Collections.unmodifiableCollection(this.classNames);
    }

    void delete() {
        AppUtil appUtil = AppUtil.getInstance();
        if (this.uploadedFile.exists()) {
            appUtil.delete(this.uploadedFile);
        }
        if (this.subdirectory != null && this.subdirectory.exists()) {
            appUtil.delete(this.subdirectory);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof ExternalLibrary) {
            ExternalLibrary that = (ExternalLibrary)o;
            return this.uploadedFile.equals(that.uploadedFile);
        }
        return false;
    }

    public int hashCode() {
        return this.uploadedFile.hashCode();
    }

    private static boolean isClassIncludedInRobotControllerApp(String className) {
        try {
            return ExternalLibrary.class.getClassLoader().loadClass(className) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static String replaceSuffix(String s, String oldSuffix, String newSuffix) {
        return s.substring(0, s.length() - oldSuffix.length()) + newSuffix;
    }
}

