/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.onbotjava;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.qualcomm.robotcore.util.ReadWriteFile;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.firstinspires.ftc.onbotjava.OnBotJavaFileSystemUtils;
import org.firstinspires.ftc.onbotjava.OnBotJavaManager;

public class JavaSourceFile {
    private final File sourceFile;

    private JavaSourceFile(@NonNull File sourceFile) {
        this.sourceFile = sourceFile;
    }

    @NonNull
    public static JavaSourceFile forFile(@NonNull File sourceFile) {
        return new JavaSourceFile(sourceFile);
    }

    public void copyTo(@NonNull File dest) throws IOException {
        this.copyTo(dest, null);
    }

    private void copyTo(@NonNull File dest, @Nullable String sourcePackageName) throws IOException {
        String contents = OnBotJavaFileSystemUtils.readFile(OnBotJavaFileSystemUtils.LineEndings.UNIX.lineEnding, this.sourceFile).toString();
        String oldPackageName = sourcePackageName == null ? this.packageName() : sourcePackageName;
        String oldClassName = this.className();
        this.writeJavaFileFromContents(oldClassName, oldPackageName, contents, dest);
    }

    public void writeJavaFileFromContents(@NonNull String oldClassName, @Nullable String oldPackageName, @NonNull String contents, @NonNull File dest) {
        JavaSourceFile destSource = JavaSourceFile.forFile(dest);
        String newPackageName = destSource.packageName();
        String newClassName = destSource.className();
        String newContents = contents;
        if (oldPackageName != null) {
            newContents = contents.replaceAll("(\\s*)package(\\s+)" + oldPackageName + ";(\\s)", "$1package$2" + newPackageName + ";$3");
        }
        newContents = newContents.replaceAll("(\\s+)(class|interface|@interface)(\\s+)" + oldClassName + "(\\s+)", "$1$2$3" + newClassName + "$4");
        ReadWriteFile.writeFile((File)dest, (String)newContents);
    }

    private String packageName() {
        String packageName = this.sourceFile.getAbsolutePath();
        if ((packageName = packageName.substring(0, packageName.lastIndexOf("/"))).indexOf(OnBotJavaManager.srcDir.getAbsolutePath()) == 0) {
            packageName = packageName.substring(OnBotJavaManager.srcDir.getAbsolutePath().length() + 1);
        }
        packageName = packageName.replaceAll("/", ".");
        return packageName;
    }

    public String className() {
        String oldClassName = this.sourceFile.getName();
        if (oldClassName.endsWith(".java")) {
            oldClassName = oldClassName.substring(0, oldClassName.length() - ".java".length());
        } else if (oldClassName.contains(".")) {
            oldClassName = oldClassName.substring(0, oldClassName.lastIndexOf("."));
        }
        return oldClassName;
    }

    @Nullable
    public String packageNameFromContents() {
        try {
            String code = OnBotJavaFileSystemUtils.readFile(OnBotJavaFileSystemUtils.LineEndings.UNIX, this.sourceFile).toString();
            return JavaSourceFile.extractPackageNameFromContents(code);
        }
        catch (IOException e) {
            throw new RuntimeException("could not extract package name from contents of file", e);
        }
    }

    @Nullable
    public static String extractPackageNameFromContents(@NonNull String code) {
        Pattern packagePattern = Pattern.compile("(?:\\n|)package\\s+(.+);(?:\\n|\\s*)");
        Matcher matcher = packagePattern.matcher(code);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

