/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.onbotjava;

import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import org.firstinspires.ftc.onbotjava.OnBotJavaFileSystemUtils;
import org.firstinspires.ftc.onbotjava.OnBotJavaManager;

class OnBotJavaBackupManager {
    protected static final int NUM_SRC_BACKUPS_TO_KEEP = 35;
    protected static final int NUM_INDEX_DIGITS = 8;
    protected static final int INDEX_INVALID = -1;
    protected static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd+HH.mm.ss", Locale.US);
    protected static final String BACKUP_NAME_PREFIX = "OnBot-build-";
    protected static final String TAG = "OnBotJavaBackupManager";

    OnBotJavaBackupManager() {
    }

    protected static int parseBackupNumber(String filename) {
        if (!filename.endsWith(".zip")) {
            return -1;
        }
        if (!filename.startsWith(BACKUP_NAME_PREFIX)) {
            return -1;
        }
        if (filename.replace(".zip", "").length() < 8 + BACKUP_NAME_PREFIX.length()) {
            return -1;
        }
        try {
            String indexSubstring = filename.substring(BACKUP_NAME_PREFIX.length(), BACKUP_NAME_PREFIX.length() + 8);
            int i = Integer.parseInt(indexSubstring);
            if (i < 0) {
                return -1;
            }
            return i;
        }
        catch (Exception e) {
            return -1;
        }
    }

    protected static ArrayList<File> getSortedBackupList() {
        ArrayList<File> backups = new ArrayList<File>();
        File[] allFiles = OnBotJavaManager.srcBackupDir.listFiles();
        if (allFiles != null) {
            for (File f : allFiles) {
                if (!f.isFile() || OnBotJavaBackupManager.parseBackupNumber(f.getName()) == -1) continue;
                backups.add(f);
            }
        }
        backups.sort(new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                int i2;
                int i1 = OnBotJavaBackupManager.parseBackupNumber(f1.getName());
                if (i1 == (i2 = OnBotJavaBackupManager.parseBackupNumber(f2.getName()))) {
                    return 0;
                }
                return i1 > i2 ? 1 : -1;
            }
        });
        return backups;
    }

    protected static void archiveSourceForBuild() {
        ArrayList<File> sortedBackups = OnBotJavaBackupManager.getSortedBackupList();
        if (sortedBackups.size() >= 35) {
            Log.d((String)TAG, (String)String.format("Trimming old build backup: %s", sortedBackups.get(0).getAbsolutePath()));
            sortedBackups.get(0).delete();
            sortedBackups.remove(0);
        }
        int nextIndex = sortedBackups.size() > 0 ? OnBotJavaBackupManager.parseBackupNumber(sortedBackups.get(sortedBackups.size() - 1).getName()) + 1 : 0;
        String fileName = String.format(Locale.US, "%s%08d-%s.zip", BACKUP_NAME_PREFIX, nextIndex, DATE_FORMAT.format(new Date()));
        File file = new File(OnBotJavaManager.srcBackupDir, fileName);
        Log.d((String)TAG, (String)String.format("Backing up source code for this build to: %s", file.getAbsolutePath()));
        try {
            OnBotJavaFileSystemUtils.createZipFileFrom(OnBotJavaManager.srcDir, file);
            Log.d((String)TAG, (String)"Finished backing up source code for this build");
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)"FAILED to backup source code for this build");
        }
    }
}

