/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.onbotjava;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.firstinspires.ftc.robotcore.internal.collections.SimpleGson;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.FtcWebSocketMessage;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketManager;

public class OnBotJavaBroadcastManager {
    private static String NAMESPACE = "ONBOTJAVA";
    private WebSocketManager webSocketManager;
    private final ConcurrentLinkedQueue<FtcWebSocketMessage> messageQueue = new ConcurrentLinkedQueue();

    protected OnBotJavaBroadcastManager() {
    }

    public void broadcast(String type, Object message) {
        FtcWebSocketMessage msg = new FtcWebSocketMessage(NAMESPACE, type, SimpleGson.getInstance().toJson(message));
        if (this.webSocketManager == null) {
            this.messageQueue.add(msg);
        } else {
            this.webSocketManager.broadcastToNamespace(NAMESPACE, msg);
        }
    }

    void registerWebSocketManager(WebSocketManager webSocketManager) {
        this.webSocketManager = webSocketManager;
        while (!this.messageQueue.isEmpty()) {
            FtcWebSocketMessage msg = this.messageQueue.poll();
            webSocketManager.broadcastToNamespace(NAMESPACE, msg);
        }
    }
}

