/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.onbotjava;

import com.qualcomm.robotcore.util.RobotLog;
import com.sun.tools.javac.api.JavacTool;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.firstinspires.ftc.onbotjava.OnBotJavaDiagnosticsListener;
import org.firstinspires.ftc.onbotjava.OnBotJavaStandardFileManager;
import org.firstinspires.ftc.robotcore.external.Predicate;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;

public class OnBotJavaCompiler {
    public static final String TAG = "OnBotJava:Compiler";

    public boolean compile(File srcRoot, OnBotJavaDiagnosticsListener diagnosticListener) {
        List<File> javaFiles = this.javaFilesUnder(srcRoot);
        JavacTool javac = JavacTool.create();
        OnBotJavaStandardFileManager fileManager = new OnBotJavaStandardFileManager(javac.getStandardFileManager((DiagnosticListener)diagnosticListener, (Locale)null, (Charset)null));
        fileManager.setSourcePath(Collections.singleton(srcRoot));
        Iterable<? extends JavaFileObject> javaFileObjects = fileManager.getJavaFileObjects(javaFiles.toArray(new File[javaFiles.size()]));
        if (javaFileObjects.iterator().hasNext()) {
            String version = "1.8";
            List<String> options = Arrays.asList("-source", version, "-target", version, "-g", "-encoding", "UTF-8", "-Xlint:unchecked", "-Xlint:deprecation", "-XDuseUnsharedTable=true");
            try {
                JavaCompiler.CompilationTask task = javac.getTask(diagnosticListener.getWriter(), (JavaFileManager)fileManager, (DiagnosticListener)diagnosticListener, options, (Iterable)null, (Iterable)javaFileObjects);
                return task.call();
            }
            catch (RuntimeException e) {
                RobotLog.logStackTrace((String)TAG, (Throwable)e);
                return false;
            }
        }
        RobotLog.vv((String)TAG, (String)"no source files; omitting javac compile");
        return true;
    }

    protected List<File> javaFilesUnder(File src) {
        return AppUtil.getInstance().filesUnder(src, (Predicate)new Predicate<File>(){

            public boolean test(File file) {
                return file.getName().endsWith(".java");
            }
        });
    }
}

