/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.onbotjava;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.firstinspires.ftc.onbotjava.OnBotJavaManager;
import org.firstinspires.ftc.robotcore.internal.files.LogOutputStream;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;

public class OnBotJavaDiagnosticsListener
implements DiagnosticListener<JavaFileObject> {
    public static final String TAG = "OnBotJava:Diagnostics";
    protected List<Diagnostic<? extends JavaFileObject>> diagnostics = Collections.synchronizedList(new ArrayList());
    protected Charset charset = Charset.forName("UTF-8");
    protected Locale locale = Locale.getDefault();
    protected File srcDir;
    protected LogOutputStream logInfoStream;
    protected LogOutputStream logWarningStream;
    protected LogOutputStream logErrorStream;
    protected File logFile;
    protected FileOutputStream logFileStream;
    protected TeeStream teeStream;
    protected PrintStream printStream;
    protected Writer writer;

    public OnBotJavaDiagnosticsListener(File srcDir) throws IOException {
        this.srcDir = srcDir;
        this.logInfoStream = new LogOutputStream(4, TAG, this.charset);
        this.logWarningStream = new LogOutputStream(5, TAG, this.charset);
        this.logErrorStream = new LogOutputStream(6, TAG, this.charset);
        this.logFile = OnBotJavaManager.buildLogFile;
        this.logFileStream = new FileOutputStream(this.logFile, false);
        this.teeStream = new TeeStream(this.logFileStream, (OutputStream)this.logErrorStream);
        this.printStream = new PrintStream((OutputStream)this.teeStream, false, this.charset.name());
        this.writer = new OutputStreamWriter((OutputStream)this.teeStream, this.charset.name());
    }

    public void flush() throws IOException {
        this.writer.flush();
        this.printStream.flush();
        this.logInfoStream.flush();
        this.logWarningStream.flush();
        this.logErrorStream.flush();
        this.logFileStream.flush();
    }

    public void close() throws IOException {
        this.writer.close();
        this.printStream.close();
        this.logInfoStream.close();
        this.logWarningStream.close();
        this.logErrorStream.close();
        this.logFileStream.close();
    }

    public Writer getWriter() {
        return this.writer;
    }

    public PrintStream getPrintStream() {
        return this.printStream;
    }

    protected LogOutputStream getLogInfoStream(Diagnostic.Kind kind) {
        switch (kind) {
            case ERROR: {
                return this.logErrorStream;
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                return this.logWarningStream;
            }
        }
        return this.logInfoStream;
    }

    @Override
    public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
        File absoluteFile = new File(diagnostic.getSource().getName());
        File relativeFile = AppUtil.getInstance().getRelativePath(this.srcDir, absoluteFile);
        String message = String.format(this.locale, "%s(%d:%d): %s: %s", new Object[]{relativeFile.getPath(), diagnostic.getLineNumber(), diagnostic.getColumnNumber(), diagnostic.getKind(), diagnostic.getMessage(this.locale)});
        this.println((OutputStream)this.getLogInfoStream(diagnostic.getKind()), message);
        this.println(this.logFileStream, message);
    }

    protected void println(OutputStream outputStream, String message) {
        try {
            PrintStream printStream = new PrintStream(outputStream, false, this.charset.name());
            printStream.println(message);
        }
        catch (UnsupportedEncodingException e) {
            throw AppUtil.getInstance().unreachable(TAG, (Throwable)e);
        }
    }

    protected class TeeStream
    extends OutputStream {
        protected OutputStream firstStream;
        protected OutputStream secondStream;

        public TeeStream(OutputStream firstStream, OutputStream secondStream) {
            this.firstStream = firstStream;
            this.secondStream = secondStream;
        }

        @Override
        public synchronized void close() throws IOException {
            this.flush();
        }

        @Override
        public synchronized void flush() throws IOException {
            this.firstStream.flush();
            this.secondStream.flush();
        }

        @Override
        public synchronized void write(int oneByte) throws IOException {
            this.firstStream.write(oneByte);
            this.secondStream.write(oneByte);
        }
    }
}

